/*! For license information please see editor-variables.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-variables/src/api.ts":function(e,a,r){r.r(a),r.d(a,{apiClient:function(){return o}});var t=r("@elementor/http-client");const n="elementor/v1/variables",o={list:()=>(0,t.httpService)().get(n+"/list"),create:(e,a,r)=>(0,t.httpService)().post(n+"/create",{type:e,label:a,value:r}),update:(e,a,r,o)=>(0,t.httpService)().put(n+"/update",{id:e,label:a,value:r,type:o}),delete:e=>(0,t.httpService)().post(n+"/delete",{id:e}),restore:(e,a,r,o)=>{const i={id:e};return a&&(i.label=a),r&&(i.value=r),o&&(i.type=o),(0,t.httpService)().post(n+"/restore",i)},batch:e=>(0,t.httpService)().post(n+"/batch",e)}},"./packages/packages/core/editor-variables/src/batch-operations.ts":function(e,a,r){r.r(a),r.d(a,{buildOperationsArray:function(){return buildOperationsArray},generateTempId:function(){return generateTempId},isTempId:function(){return isTempId}});const generateTempId=()=>`tmp-${Date.now().toString(36)}-${Math.random().toString(36).substring(2,8)}`,isTempId=e=>e.startsWith("tmp-"),buildOperationsArray=(e,a,r)=>{const t=[];return Object.entries(a).forEach(([a,r])=>{if(isTempId(a))t.push({type:"create",variable:{...r,id:a}});else if(e[a]){const n=e[a];n.deleted&&!r.deleted?t.push({type:"restore",id:a,...n.label!==r.label&&{label:r.label},...n.value!==r.value&&{value:r.value}}):r.deleted||n.label===r.label&&n.value===r.value&&n.order===r.order&&n.type===r.type||t.push({type:"update",id:a,variable:{...n.label!==r.label&&{label:r.label},...n.value!==r.value&&{value:r.value},...n.order!==r.order&&{order:r.order},...n.type!==r.type&&{type:r.type}}})}}),r.forEach(e=>{t.push({type:"delete",id:e})}),t.filter(e=>{const r=e.id||e.variable?.id;return r&&!(isTempId(r)&&a[r]?.deleted)})}},"./packages/packages/core/editor-variables/src/components/fields/color-field.tsx":function(e,a,r){r.r(a),r.d(a,{ColorField:function(){return ColorField}});var t=r("react"),n=r("@elementor/ui"),o=r("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),i=r("./packages/packages/core/editor-variables/src/utils/validations.ts");const ColorField=({value:e,onChange:a,onValidationChange:r})=>{const[s,l]=(0,t.useState)(e),[c,p]=(0,t.useState)(""),u=(0,t.useRef)(null),d=(0,o.usePopoverContentRef)()??u.current;return t.createElement(n.UnstableColorField,{id:"color-variable-field",size:"tiny",fullWidth:!0,value:s,onChange:e=>{l(e);const t=(0,i.validateValue)(e);p(t),r?.(t),a(t?"":e)},error:c||void 0,slotProps:{colorPicker:{anchorEl:d,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-10},slotProps:{colorIndicator:{size:"inherit",sx:{borderRadius:.5}}}}}})}},"./packages/packages/core/editor-variables/src/components/fields/font-field.tsx":function(e,a,r){r.r(a),r.d(a,{FontField:function(){return FontField}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/editor-editing-panel"),i=r("@elementor/icons"),s=r("@elementor/ui"),l=r("@wordpress/i18n"),c=r("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),p=r("./packages/packages/core/editor-variables/src/utils/validations.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const FontField=({value:e,onChange:a,onValidationChange:r})=>{const[u,d]=(0,t.useState)(e),b=(0,t.useRef)(null),g=(0,c.usePopoverContentRef)()??b.current,m=(0,s.usePopupState)({variant:"popover"}),v=(0,o.useFontFamilies)(),k=(0,o.useSectionWidth)(),f=t.useMemo(()=>v.map(({label:e,fonts:a})=>({label:e,items:a})),[v]),y=(0,t.useId)();return t.createElement(t.Fragment,null,t.createElement(s.UnstableTag,_extends({id:y,variant:"outlined",label:u,endIcon:t.createElement(i.ChevronDownIcon,{fontSize:"tiny"})},(0,s.bindTrigger)(m),{fullWidth:!0})),t.createElement(s.Popover,_extends({disablePortal:!0,disableScrollLock:!0,anchorEl:g,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-28}},(0,s.bindPopover)(m)),t.createElement(n.ItemSelector,{id:"font-family-variables-selector",itemsList:f,selectedItem:u,onItemChange:e=>{(e=>{d(e);const t=(0,p.validateValue)(e);r?.(t),a(t?"":e)})(e),m.close()},onClose:m.close,sectionWidth:k,title:(0,l.__)("Font family","elementor"),itemStyle:e=>({fontFamily:e.value}),onDebounce:n.enqueueFont,icon:i.TextIcon})))}},"./packages/packages/core/editor-variables/src/components/fields/label-field.tsx":function(e,a,r){r.r(a),r.d(a,{LabelField:function(){return LabelField},useLabelError:function(){return useLabelError}});var t=r("react"),n=r("@elementor/editor-ui"),o=r("@elementor/ui"),i=r("./packages/packages/core/editor-variables/src/utils/validations.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}function isLabelEqual(e,a){return e.trim().toLowerCase()===a.trim().toLowerCase()}const useLabelError=e=>{const[a,r]=(0,t.useState)(e??{value:"",message:""});return{labelFieldError:a,setLabelFieldError:r}},LabelField=({value:e,error:a,onChange:r,id:s,onErrorChange:l,size:c="tiny",focusOnShow:p=!1,selectOnShow:u=!1,showWarningInfotip:d=!1,variables:b,onKeyDown:g})=>{const[m,v]=(0,t.useState)(e),[k,f]=(0,t.useState)(""),y=(0,t.useRef)(null);let h=k;isLabelEqual(m,a?.value??"")&&a?.message&&(h=a.message);const E=h?"":(0,i.labelHint)(m),_=t.createElement(o.TextField,{ref:y,id:s,size:c,fullWidth:!0,value:m,error:!!h,onChange:e=>(e=>{v(e);const t=(0,i.validateLabel)(e,b);f(t),l?.(t),r(isLabelEqual(e,a?.value??"")||t?"":e)})(e.target.value),inputProps:{maxLength:i.VARIABLE_LABEL_MAX_LENGTH,...u&&{onFocus:e=>e.target.select()},"aria-label":"Name",onKeyDown:g},autoFocus:p});if(d){const e=Math.max(240,y.current?.getBoundingClientRect().width??240);return t.createElement(n.WarningInfotip,_extends({open:Boolean(h||E),text:h||E,placement:"bottom-start",width:e,offset:[0,-15]},E&&{hasError:!1}),_)}return _}},"./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx":function(e,a,r){r.r(a),r.d(a,{ColorIndicator:function(){return n}});var t=r("@elementor/ui");const n=(0,t.styled)(t.UnstableColorIndicator)(({theme:e})=>({borderRadius:e.shape.borderRadius/2+"px",marginRight:e.spacing(.25)}))},"./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx":function(e,a,r){r.r(a),r.d(a,{DeleteConfirmationDialog:function(){return DeleteConfirmationDialog}});var t=r("react"),n=r("@elementor/editor-ui"),o=r("@elementor/ui"),i=r("@wordpress/i18n");const DeleteConfirmationDialog=({open:e,label:a,closeDialog:r,onConfirm:s})=>t.createElement(n.ConfirmationDialog,{open:e,onClose:r},t.createElement(n.ConfirmationDialog.Title,null,(0,i.__)("Delete this variable?","elementor")),t.createElement(n.ConfirmationDialog.Content,null,t.createElement(n.ConfirmationDialog.ContentText,null,(0,i.__)("All elements using","elementor")," ",t.createElement(o.Typography,{variant:"subtitle2",component:"span",sx:{lineBreak:"anywhere"}},a)," ",(0,i.__)("will keep their current values, but the variable itself will be removed.","elementor"))),t.createElement(n.ConfirmationDialog.Actions,{onClose:r,onConfirm:s}))},"./packages/packages/core/editor-variables/src/components/ui/deleted-variable-alert.tsx":function(e,a,r){r.r(a),r.d(a,{DeletedVariableAlert:function(){return DeletedVariableAlert}});var t=r("react"),n=r("@elementor/ui"),o=r("@wordpress/i18n");const DeletedVariableAlert=({onClose:e,onUnlink:a,onRestore:r,label:i})=>t.createElement(n.ClickAwayListener,{onClickAway:e},t.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:t.createElement(t.Fragment,null,a&&t.createElement(n.AlertAction,{variant:"contained",onClick:a},(0,o.__)("Unlink","elementor")),r&&t.createElement(n.AlertAction,{variant:"outlined",onClick:r},(0,o.__)("Restore","elementor"))),sx:{maxWidth:300}},t.createElement(n.AlertTitle,null,(0,o.__)("Deleted variable","elementor")),t.createElement(n.Typography,{variant:"body2",color:"textPrimary"},(0,o.__)("The variable","elementor")," '",t.createElement(n.Typography,{variant:"body2",component:"span",sx:{lineBreak:"anywhere"}},i),"' ",(0,o.__)("has been deleted, but it is still referenced in this location. You may restore the variable or unlink it to assign a different value.","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/edit-confirmation-dialog.tsx":function(e,a,r){r.r(a),r.d(a,{EDIT_CONFIRMATION_DIALOG_ID:function(){return s},EditConfirmationDialog:function(){return EditConfirmationDialog}});var t=r("react"),n=r("@elementor/icons"),o=r("@elementor/ui"),i=r("@wordpress/i18n");const s="edit-confirmation-dialog",EditConfirmationDialog=({closeDialog:e,onConfirm:a,onSuppressMessage:r})=>{const[s,l]=(0,t.useState)(!1);return t.createElement(o.Dialog,{open:!0,onClose:e,maxWidth:"xs"},t.createElement(o.DialogTitle,{display:"flex",alignItems:"center",gap:1},t.createElement(n.AlertTriangleFilledIcon,{color:"secondary"}),(0,i.__)("Changes to variables go live right away.","elementor")),t.createElement(o.DialogContent,null,t.createElement(o.DialogContentText,{variant:"body2",color:"textPrimary"},(0,i.__)("Don't worry - all other changes you make will wait until you publish your site.","elementor"))),t.createElement(o.DialogActions,{sx:{justifyContent:"space-between",alignItems:"center"}},t.createElement(o.FormControlLabel,{control:t.createElement(o.Checkbox,{checked:s,onChange:e=>l(e.target.checked),size:"small"}),label:t.createElement(o.Typography,{variant:"body2"},(0,i.__)("Don't show me again","elementor"))}),t.createElement("div",null,t.createElement(o.Button,{color:"secondary",onClick:e},(0,i.__)("Keep editing","elementor")),t.createElement(o.Button,{variant:"contained",color:"secondary",onClick:()=>{s&&r?.(),a?.()},sx:{ml:1}},(0,i.__)("Save","elementor")))))}},"./packages/packages/core/editor-variables/src/components/ui/empty-state.tsx":function(e,a,r){r.r(a),r.d(a,{EmptyState:function(){return EmptyState}});var t=r("react"),n=r("@elementor/ui"),o=r("@wordpress/i18n"),i=r("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts");const EmptyState=({icon:e,title:a,message:r,onAdd:s,children:l})=>{const c=(0,i.usePermissions)().canAdd(),p=c?a:(0,o.__)("There are no variables","elementor"),u=c?r:(0,o.__)("With your current role, you can only connect and detach variables.","elementor");return t.createElement(Content,{title:p,message:u,icon:e},l||s&&t.createElement(n.Button,{variant:"outlined",color:"secondary",size:"small",onClick:s},(0,o.__)("Create a variable","elementor")))};function Content({title:e,message:a,icon:r,children:o}){return t.createElement(n.Stack,{gap:1,alignItems:"center",justifyContent:"flex-start",height:"100%",color:"text.secondary",sx:{p:2.5,pt:8,pb:5.5}},r,t.createElement(n.Typography,{align:"center",variant:"subtitle2"},e),t.createElement(n.Typography,{align:"center",variant:"caption",maxWidth:"180px"},a),o)}},"./packages/packages/core/editor-variables/src/components/ui/form-field.tsx":function(e,a,r){r.r(a),r.d(a,{FormField:function(){return FormField}});var t=r("react"),n=r("@elementor/ui");const FormField=({id:e,label:a,errorMsg:r,noticeMsg:o,children:i})=>t.createElement(n.Grid,{container:!0,gap:.75,alignItems:"center"},t.createElement(n.Grid,{item:!0,xs:12},t.createElement(n.FormLabel,{htmlFor:e,size:"tiny"},a)),t.createElement(n.Grid,{item:!0,xs:12},i,r&&t.createElement(n.FormHelperText,{error:!0},r),o&&t.createElement(n.FormHelperText,null,o)))},"./packages/packages/core/editor-variables/src/components/ui/menu-item-content.tsx":function(e,a,r){r.r(a),r.d(a,{MenuItemContent:function(){return MenuItemContent}});var t=r("react"),n=r("@elementor/editor-ui"),o=r("@elementor/icons"),i=r("@elementor/ui"),s=r("@wordpress/i18n");const l=(0,s.__)("Edit variable","elementor"),MenuItemContent=({item:e,disabled:a=!1})=>{const r=e.onEdit;return t.createElement(t.Fragment,null,t.createElement(i.ListItemIcon,{sx:{color:a?"text.disabled":"inherit"}},e.icon),t.createElement(i.Box,{sx:{flex:1,minWidth:0,display:"flex",alignItems:"center",gap:1}},t.createElement(n.EllipsisWithTooltip,{title:e.label||e.value,as:i.Typography,variant:"caption",color:a?"text.disabled":"text.primary",sx:{marginTop:"1px",lineHeight:"2"},maxWidth:"50%"}),e.secondaryText&&t.createElement(n.EllipsisWithTooltip,{title:e.secondaryText,as:i.Typography,variant:"caption",color:a?"text.disabled":"text.tertiary",sx:{marginTop:"1px",lineHeight:"1"},maxWidth:"50%"})),!!r&&!a&&t.createElement(i.Tooltip,{placement:"top",title:l},t.createElement(i.IconButton,{sx:{mx:1,opacity:"0"},onClick:a=>{a.stopPropagation(),r(e.value)},"aria-label":l},t.createElement(o.EditIcon,{color:"action",fontSize:"tiny"}))))}},"./packages/packages/core/editor-variables/src/components/ui/mismatch-variable-alert.tsx":function(e,a,r){r.r(a),r.d(a,{MismatchVariableAlert:function(){return MismatchVariableAlert}});var t=r("react"),n=r("@elementor/ui"),o=r("@wordpress/i18n");const i={title:(0,o.__)("Variable has changed","elementor"),message:(0,o.__)("This variable is no longer compatible with this property. You can clear it or select a different one.","elementor"),buttons:{clear:(0,o.__)("Clear","elementor"),select:(0,o.__)("Select variable","elementor")}},MismatchVariableAlert=({onClose:e,onClear:a,triggerSelect:r})=>t.createElement(n.ClickAwayListener,{onClickAway:e},t.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:t.createElement(t.Fragment,null,a&&t.createElement(n.AlertAction,{variant:"contained",onClick:a},i.buttons.clear),r&&t.createElement(n.AlertAction,{variant:"outlined",onClick:r},i.buttons.select)),sx:{maxWidth:300}},t.createElement(n.AlertTitle,null,i.title),t.createElement(n.Typography,{variant:"body2",color:"textPrimary"},i.message)))},"./packages/packages/core/editor-variables/src/components/ui/missing-variable-alert.tsx":function(e,a,r){r.r(a),r.d(a,{MissingVariableAlert:function(){return MissingVariableAlert}});var t=r("react"),n=r("@elementor/ui"),o=r("@wordpress/i18n");const MissingVariableAlert=({onClose:e,onClear:a})=>t.createElement(n.ClickAwayListener,{onClickAway:e},t.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:t.createElement(t.Fragment,null,a&&t.createElement(n.AlertAction,{variant:"contained",onClick:a},(0,o.__)("Clear","elementor"))),sx:{maxWidth:300}},t.createElement(n.AlertTitle,null,(0,o.__)("This variable is missing","elementor")),t.createElement(n.Typography,{variant:"body2",color:"textPrimary"},(0,o.__)("It may have been deleted. Try clearing this field and select a different value or variable.","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx":function(e,a,r){r.r(a),r.d(a,{NoSearchResults:function(){return NoSearchResults}});var t=r("react"),n=r("@elementor/ui"),o=r("@wordpress/i18n");const NoSearchResults=({searchValue:e,onClear:a,icon:r})=>t.createElement(n.Stack,{gap:1,alignItems:"center",justifyContent:"center",p:2.5,color:"text.secondary",sx:{pb:3.5,pt:8}},r,t.createElement(n.Typography,{align:"center",variant:"subtitle2"},(0,o.__)("Sorry, nothing matched","elementor"),t.createElement("br",null),"“",e,"”."),t.createElement(n.Typography,{align:"center",variant:"caption",sx:{display:"flex",flexDirection:"column"}},(0,o.__)("Try something else.","elementor"),t.createElement(n.Link,{color:"text.secondary",variant:"caption",component:"button",onClick:a},(0,o.__)("Clear & try again","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/styled-menu-list.tsx":function(e,a,r){r.r(a),r.d(a,{VariablesStyledMenuList:function(){return n}});var t=r("@elementor/ui");const n=(0,t.styled)(t.MenuList)(({theme:e,disabled:a})=>({"& > li":{height:32,width:"100%",display:"flex",alignItems:"center"},'& > [role="option"]':{...e.typography.caption,lineHeight:"inherit",padding:e.spacing(.5,1,.5,2),...!a&&{"&:hover, &:focus":{backgroundColor:e.palette.action.hover},cursor:"pointer"},'&[aria-selected="true"]':{backgroundColor:e.palette.action.selected},textOverflow:"ellipsis",position:"absolute",top:0,left:0,"&:hover .MuiIconButton-root, .MuiIconButton-root:focus":{opacity:1}},width:"100%",position:"relative"}))},"./packages/packages/core/editor-variables/src/components/ui/tags/assigned-tag.tsx":function(e,a,r){r.r(a),r.d(a,{AssignedTag:function(){return AssignedTag},SIZE:function(){return s}});var t=r("react"),n=r("@elementor/icons"),o=r("@elementor/ui"),i=r("@wordpress/i18n");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const s="tiny",l=(0,i.__)("Unlink variable","elementor"),AssignedTag=({startIcon:e,label:a,onUnlink:r,...i})=>{const c=[];return r&&c.push(t.createElement(o.Tooltip,{key:"unlink",title:l,placement:"bottom"},t.createElement(o.IconButton,{size:s,onClick:r,"aria-label":l},t.createElement(n.DetachIcon,{fontSize:s})))),t.createElement(o.Tooltip,{title:a,placement:"top"},t.createElement(o.UnstableTag,_extends({fullWidth:!0,showActionsOnHover:!0,startIcon:t.createElement(o.Stack,{gap:.5,direction:"row",alignItems:"center"},e),label:t.createElement(o.Box,{sx:{display:"inline-grid",minWidth:0}},t.createElement(o.Typography,{sx:{lineHeight:1.34},variant:"caption",noWrap:!0},a)),actions:c},i)))}},"./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx":function(e,a,r){r.r(a),r.d(a,{WarningVariableTag:function(){return i}});var t=r("react"),n=r("@elementor/icons"),o=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const i=t.forwardRef(({label:e,suffix:a,onClick:r,icon:i,...s},l)=>{const c=a?`${e} (${a})`:e;return t.createElement(o.Chip,_extends({ref:l,size:"tiny",color:"warning",shape:"rounded",variant:"standard",onClick:r,icon:t.createElement(n.AlertTriangleFilledIcon,null),label:t.createElement(o.Tooltip,{title:c,placement:"top"},t.createElement(o.Box,{sx:{display:"inline-grid",minWidth:0}},t.createElement(o.Typography,{variant:"caption",noWrap:!0,sx:{lineHeight:1.34}},c))),sx:{height:e=>e.spacing(3.5),borderRadius:e=>e.spacing(1),justifyContent:"flex-start",width:"100%"}},s))});i.displayName="WarningVariableTag"},"./packages/packages/core/editor-variables/src/components/ui/variable-promotion-chip.tsx":function(e,a,r){r.r(a),r.d(a,{VariablePromotionChip:function(){return l}});var t=r("react"),n=r("@elementor/editor-ui"),o=r("@elementor/ui"),i=r("@elementor/utils"),s=r("@wordpress/i18n");const l=(0,t.forwardRef)(({variableType:e,upgradeUrl:a},r)=>{const[l,c]=(0,t.useState)(!1);(0,n.useCanvasClickHandler)(l,()=>c(!1));const toggle=()=>c(e=>!e);(0,t.useImperativeHandle)(r,()=>({toggle:toggle}),[]);const p=(0,s.sprintf)((0,s.__)("%s variables","elementor"),(0,i.capitalize)(e)),u=(0,s.sprintf)((0,s.__)("Upgrade to continue creating and editing %s variables.","elementor"),e);return t.createElement(n.PromotionPopover,{open:l,title:p,content:u,ctaText:(0,s.__)("Upgrade now","elementor"),ctaUrl:a,onClose:e=>{e.stopPropagation(),c(!1)}},t.createElement(o.Box,{onClick:e=>{e.stopPropagation(),toggle()},sx:{cursor:"pointer",display:"inline-flex"}},t.createElement(n.PromotionChip,null)))})},"./packages/packages/core/editor-variables/src/components/ui/variable/assigned-variable.tsx":function(e,a,r){r.r(a),r.d(a,{AssignedVariable:function(){return AssignedVariable}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/icons"),i=r("@elementor/ui"),s=r("./packages/packages/core/editor-variables/src/utils/unlink-variable.ts"),l=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),c=r("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),p=r("./packages/packages/core/editor-variables/src/components/ui/tags/assigned-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const AssignedVariable=({variable:e,propTypeKey:a})=>{const{startIcon:r,propTypeUtil:u}=(0,l.getVariableType)(a),{setValue:d}=(0,n.useBoundProp)(),b=(0,t.useRef)(null),g=(0,t.useId)(),m=(0,i.usePopupState)({variant:"popover",popupId:`elementor-variables-list-${g}`}),v=(0,s.createUnlinkHandler)(e,a,d),k=r||(()=>null);return t.createElement(i.Box,{ref:b},t.createElement(p.AssignedTag,_extends({label:e.label,startIcon:t.createElement(t.Fragment,null,t.createElement(o.ColorFilterIcon,{fontSize:p.SIZE}),t.createElement(k,{value:e.value})),onUnlink:v},(0,i.bindTrigger)(m))),t.createElement(i.Popover,_extends({disableScrollLock:!0,anchorEl:b.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,i.bindPopover)(m)),t.createElement(c.VariableSelectionPopover,{selectedVariable:e,closePopover:m.close,propTypeKey:u.key})))}},"./packages/packages/core/editor-variables/src/components/ui/variable/deleted-variable.tsx":function(e,a,r){r.r(a),r.d(a,{DeletedVariable:function(){return DeletedVariable}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/ui"),i=r("@wordpress/i18n"),s=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),l=r("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),c=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),p=r("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),u=r("./packages/packages/core/editor-variables/src/utils/unlink-variable.ts"),d=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),b=r("./packages/packages/core/editor-variables/src/components/variable-restore.tsx"),g=r("./packages/packages/core/editor-variables/src/components/ui/deleted-variable-alert.tsx"),m=r("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const DeletedVariable=({variable:e,propTypeKey:a})=>{const{propTypeUtil:r}=(0,d.getVariableType)(a),v=(0,n.useBoundProp)(),k=(0,l.usePermissions)(),[f,y]=(0,t.useState)(!1),closeInfotip=()=>y(!1),h=(0,t.useRef)(null),E=(0,t.useId)(),_=(0,o.usePopupState)({variant:"popover",popupId:`elementor-variables-restore-${E}`}),x={};k.canUnlink()&&(x.onUnlink=(0,u.createUnlinkHandler)(e,a,v.setValue)),k.canRestore()&&(x.onRestore=()=>{e.key&&(0,c.restoreVariable)(e.key).then(e=>{(0,p.resolveBoundPropAndSetValue)(r.create(e),v),closeInfotip()}).catch(()=>{closeInfotip(),_.setAnchorEl(h.current),_.open()})});return t.createElement(t.Fragment,null,t.createElement(o.Box,{ref:h},f&&t.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),t.createElement(o.Infotip,{color:"warning",placement:"right-start",open:f,disableHoverListener:!0,onClose:closeInfotip,content:t.createElement(g.DeletedVariableAlert,{onClose:closeInfotip,onUnlink:x.onUnlink,onRestore:x.onRestore,label:e.label}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},t.createElement(m.WarningVariableTag,{label:e.label,onClick:()=>y(e=>!e),suffix:(0,i.__)("deleted","elementor")})),t.createElement(o.Popover,_extends({disableScrollLock:!0,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,o.bindPopover)(_)),t.createElement(s.VariableTypeProvider,{propTypeKey:a},t.createElement(b.VariableRestore,{variableId:e.key??"",onClose:_.close,onSubmit:()=>{_.close()}})))))}},"./packages/packages/core/editor-variables/src/components/ui/variable/mismatch-variable.tsx":function(e,a,r){r.r(a),r.d(a,{MismatchVariable:function(){return MismatchVariable}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/ui"),i=r("@wordpress/i18n"),s=r("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),l=r("./packages/packages/core/editor-variables/src/components/ui/mismatch-variable-alert.tsx"),c=r("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const MismatchVariable=({variable:e})=>{const{setValue:a,value:r}=(0,n.useBoundProp)(),p=(0,t.useRef)(null),u=(0,t.useId)(),d=(0,o.usePopupState)({variant:"popover",popupId:`elementor-variables-list-${u}`}),[b,g]=(0,t.useState)(!1),closeInfotip=()=>g(!1),m=!!r;return t.createElement(o.Box,{ref:p},b&&t.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),t.createElement(o.Infotip,{color:"warning",placement:"right-start",open:b,disableHoverListener:!0,onClose:closeInfotip,content:t.createElement(l.MismatchVariableAlert,{onClose:closeInfotip,onClear:m?()=>{closeInfotip(),a(null)}:void 0,triggerSelect:()=>{closeInfotip(),d.setAnchorEl(p.current),d.open()}}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},t.createElement(c.WarningVariableTag,{label:e.label,onClick:()=>g(e=>!e),suffix:(0,i.__)("changed","elementor")})),t.createElement(o.Popover,_extends({disableScrollLock:!0,anchorEl:p.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,o.bindPopover)(d)),t.createElement(s.VariableSelectionPopover,{selectedVariable:e,closePopover:d.close,propTypeKey:e.type})))}},"./packages/packages/core/editor-variables/src/components/ui/variable/missing-variable.tsx":function(e,a,r){r.r(a),r.d(a,{MissingVariable:function(){return MissingVariable}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/ui"),i=r("@wordpress/i18n"),s=r("./packages/packages/core/editor-variables/src/components/ui/missing-variable-alert.tsx"),l=r("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");const MissingVariable=()=>{const{setValue:e}=(0,n.useBoundProp)(),[a,r]=(0,t.useState)(!1),closeInfotip=()=>r(!1);return t.createElement(t.Fragment,null,a&&t.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),t.createElement(o.Infotip,{color:"warning",placement:"right-start",open:a,disableHoverListener:!0,onClose:closeInfotip,content:t.createElement(s.MissingVariableAlert,{onClose:closeInfotip,onClear:()=>e(null)}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},t.createElement(l.WarningVariableTag,{label:(0,i.__)("Missing variable","elementor"),onClick:()=>r(e=>!e)})))}},"./packages/packages/core/editor-variables/src/components/variable-creation.tsx":function(e,a,r){r.r(a),r.d(a,{VariableCreation:function(){return VariableCreation}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/editor-editing-panel"),i=r("@elementor/editor-ui"),s=r("@elementor/icons"),l=r("@elementor/ui"),c=r("@wordpress/i18n"),p=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=r("./packages/packages/core/editor-variables/src/hooks/use-initial-value.ts"),d=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),b=r("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),g=r("./packages/packages/core/editor-variables/src/utils/tracking.ts"),m=r("./packages/packages/core/editor-variables/src/utils/validations.ts"),v=r("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),k=r("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const f="tiny",VariableCreation=({onGoBack:e,onClose:a})=>{const{icon:r,valueField:y,variableType:h,propTypeUtil:E}=(0,p.useVariableType)(),{setVariableValue:_,path:x}=(0,b.useVariableBoundProp)(),{propType:C}=(0,n.useBoundProp)(),T=(0,u.useInitialValue)(),[V,w]=(0,t.useState)(T),[S,P]=(0,t.useState)(""),[I,A]=(0,t.useState)(""),[R,L]=(0,t.useState)(""),[O,B]=(0,t.useState)(E.key),{labelFieldError:D,setLabelFieldError:M}=(0,v.useLabelError)(),closePopover=()=>{w(""),P(""),A(""),L(""),a()},handleCreateAndTrack=()=>{(0,d.createVariable)({value:V,label:S,type:O}).then(e=>{_(e),closePopover()}).catch(e=>{const a=(0,m.mapServerError)(e);if(a&&"label"===a.field)return P(""),void M({value:S,message:a.message});A(m.ERROR_MESSAGES.UNEXPECTED_ERROR)}),(0,g.trackVariableEvent)({varType:h,controlPath:x.join("."),action:"save"})},U=""===S.trim()||("string"==typeof V?""===V.trim():!1===Boolean(V))||!!I,handleKeyDown=e=>{"Enter"!==e.key||U||(e.preventDefault(),handleCreateAndTrack())};return t.createElement(o.PopoverBody,{height:"auto"},t.createElement(i.PopoverHeader,{icon:t.createElement(t.Fragment,null,e&&t.createElement(l.IconButton,{size:f,"aria-label":(0,c.__)("Go Back","elementor"),onClick:e},t.createElement(s.ArrowLeftIcon,{fontSize:f})),t.createElement(r,{fontSize:f})),title:(0,c.__)("Create variable","elementor"),onClose:closePopover}),t.createElement(l.Divider,null),t.createElement(n.PopoverContent,{p:2},t.createElement(k.FormField,{id:"variable-label",label:(0,c.__)("Name","elementor"),errorMsg:D?.message,noticeMsg:(0,m.labelHint)(S)},t.createElement(v.LabelField,{id:"variable-label",value:S,error:D,onChange:e=>{P(e),A("")},onErrorChange:e=>{M({value:S,message:e})},onKeyDown:handleKeyDown})),y&&t.createElement(k.FormField,{errorMsg:R,label:(0,c.__)("Value","elementor")},t.createElement(l.Typography,{variant:"h5",id:"variable-value-wrapper"},t.createElement(y,{value:V,onPropTypeKeyChange:e=>B(e),onChange:e=>{w(e),A(""),L("")},onValidationChange:L,propType:C,onKeyDown:handleKeyDown}))),I&&t.createElement(l.FormHelperText,{error:!0},I)),t.createElement(l.CardActions,{sx:{pt:.5,pb:1}},t.createElement(l.Button,{id:"create-variable-button",size:"small",variant:"contained",disabled:U,onClick:handleCreateAndTrack},(0,c.__)("Create","elementor"))))}},"./packages/packages/core/editor-variables/src/components/variable-edit.tsx":function(e,a,r){r.r(a),r.d(a,{VariableEdit:function(){return VariableEdit}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/editor-current-user"),i=r("@elementor/editor-editing-panel"),s=r("@elementor/editor-ui"),l=r("@elementor/icons"),c=r("@elementor/ui"),p=r("@wordpress/i18n"),u=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),d=r("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),b=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),g=r("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),m=r("./packages/packages/core/editor-variables/src/style-variables-repository.ts"),v=r("./packages/packages/core/editor-variables/src/utils/validations.ts"),k=r("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),f=r("./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx"),y=r("./packages/packages/core/editor-variables/src/components/ui/edit-confirmation-dialog.tsx"),h=r("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const E="tiny",_=(0,p.__)("Delete variable","elementor"),VariableEdit=({onClose:e,onGoBack:a,onSubmit:r,editId:x})=>{const{icon:C,valueField:T,variableType:V,propTypeUtil:w}=(0,u.useVariableType)(),{setVariableValue:S,variableId:P}=(0,g.useVariableBoundProp)(),{propType:I}=(0,n.useBoundProp)(),[A,R]=(0,o.useSuppressedMessage)(y.EDIT_CONFIRMATION_DIALOG_ID),[L,O]=(0,t.useState)(!1),[B,D]=(0,t.useState)(!1),[M,U]=(0,t.useState)(""),[F,z]=(0,t.useState)(""),{labelFieldError:N,setLabelFieldError:j}=(0,k.useLabelError)(),H=(0,b.useVariable)(x),[W,G]=(0,t.useState)(H?.type??w.key);if(!H)throw new Error(`Global ${V} variable not found`);const q=(0,d.usePermissions)(),[$,K]=(0,t.useState)(()=>H.value),[X,Q]=(0,t.useState)(()=>H.label);(0,t.useEffect)(()=>(m.styleVariablesRepository.update({[x]:{...H,value:$}}),()=>{m.styleVariablesRepository.update({[x]:{...H}})}),[x,$,H]);const handleUpdate=()=>{A?handleSaveVariable():D(!0)},handleSaveVariable=()=>{const e=W!==H.type?{value:$,label:X,type:W}:{value:$,label:X};(0,b.updateVariable)(x,e).then(()=>{maybeTriggerBoundPropChange(),r?.()}).catch(e=>{const a=(0,v.mapServerError)(e);if(a&&"label"===a.field)return Q(""),void j({value:X,message:a.message});U(v.ERROR_MESSAGES.UNEXPECTED_ERROR)})},maybeTriggerBoundPropChange=()=>{x===P&&S(x)},handleDeleteConfirmation=()=>{O(!0)},Z=[];q.canDelete()&&Z.push(t.createElement(c.Tooltip,{key:"delete",placement:"top",title:_},t.createElement(c.IconButton,{size:E,onClick:handleDeleteConfirmation,"aria-label":_},t.createElement(l.TrashIcon,{fontSize:E}))));const J=$===H.value&&X===H.label||""===X.trim()||("string"==typeof $?""===$.trim():!1===Boolean($))||!!M,handleKeyDown=e=>{"Enter"!==e.key||J||(e.preventDefault(),handleUpdate())};return t.createElement(t.Fragment,null,t.createElement(i.PopoverBody,{height:"auto"},t.createElement(s.PopoverHeader,{title:(0,p.__)("Edit variable","elementor"),onClose:e,icon:t.createElement(t.Fragment,null,a&&t.createElement(c.IconButton,{size:E,"aria-label":(0,p.__)("Go Back","elementor"),onClick:a},t.createElement(l.ArrowLeftIcon,{fontSize:E})),t.createElement(C,{fontSize:E})),actions:Z}),t.createElement(c.Divider,null),t.createElement(n.PopoverContent,{p:2},t.createElement(h.FormField,{id:"variable-label",label:(0,p.__)("Name","elementor"),errorMsg:N?.message,noticeMsg:(0,v.labelHint)(X)},t.createElement(k.LabelField,{id:"variable-label",value:X,error:N,onChange:e=>{Q(e),U("")},onErrorChange:e=>{j({value:X,message:e})},onKeyDown:handleKeyDown})),T&&t.createElement(h.FormField,{errorMsg:F,label:(0,p.__)("Value","elementor")},t.createElement(c.Typography,{variant:"h5"},t.createElement(T,{propTypeKey:H.type,onPropTypeKeyChange:e=>G(e),value:$,onChange:e=>{K(e),U(""),z("")},onKeyDown:handleKeyDown,onValidationChange:z,propType:I}))),M&&t.createElement(c.FormHelperText,{error:!0},M)),t.createElement(c.CardActions,{sx:{pt:.5,pb:1}},t.createElement(c.Button,{size:"small",variant:"contained",disabled:J,onClick:handleUpdate},(0,p.__)("Save","elementor")))),L&&t.createElement(f.DeleteConfirmationDialog,{open:!0,label:X,onConfirm:()=>{(0,b.deleteVariable)(x).then(()=>{maybeTriggerBoundPropChange(),r?.()})},closeDialog:()=>{O(!1)}}),B&&!A&&t.createElement(y.EditConfirmationDialog,{closeDialog:()=>{D(!1)},onConfirm:handleSaveVariable,onSuppressMessage:R}))}},"./packages/packages/core/editor-variables/src/components/variable-restore.tsx":function(e,a,r){r.r(a),r.d(a,{VariableRestore:function(){return VariableRestore}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("@elementor/editor-editing-panel"),i=r("@elementor/editor-ui"),s=r("@elementor/ui"),l=r("@wordpress/i18n"),c=r("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),p=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),d=r("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),b=r("./packages/packages/core/editor-variables/src/utils/validations.ts"),g=r("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),m=r("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const VariableRestore=({variableId:e,onClose:a,onSubmit:r})=>{const{icon:v,valueField:k,variableType:f,propTypeUtil:y}=(0,p.useVariableType)(),{setVariableValue:h}=(0,d.useVariableBoundProp)(),{propType:E}=(0,n.useBoundProp)(),_=(0,u.useVariable)(e);if(!_)throw new Error(`Global ${f} variable not found`);const[x,C]=(0,t.useState)(""),[T,V]=(0,t.useState)(""),[w,S]=(0,t.useState)(_.label),[P,I]=(0,t.useState)(_.value),[A,R]=(0,t.useState)(_?.type??y.key),{labelFieldError:L,setLabelFieldError:O}=(0,g.useLabelError)({value:_.label,message:b.ERROR_MESSAGES.DUPLICATED_LABEL}),handleRestore=()=>{(A!==_.type?(0,u.restoreVariable)(e,w,P,A):(0,u.restoreVariable)(e,w,P)).then(()=>{h(e),r?.()}).catch(e=>{const a=(0,b.mapServerError)(e);if(a&&"label"===a.field)return S(""),void O({value:w,message:a.message});C(b.ERROR_MESSAGES.UNEXPECTED_ERROR)})},B=P===_.value&&w===_.label||""===w.trim()||("string"==typeof P?""===P.trim():!1===Boolean(P))||!!x,handleKeyDown=e=>{"Enter"!==e.key||B||(e.preventDefault(),handleRestore())};return t.createElement(c.PopoverContentRefContextProvider,null,t.createElement(o.PopoverBody,{height:"auto"},t.createElement(i.PopoverHeader,{icon:t.createElement(v,{fontSize:"tiny"}),title:(0,l.__)("Restore variable","elementor"),onClose:a}),t.createElement(s.Divider,null),t.createElement(n.PopoverContent,{p:2},t.createElement(m.FormField,{id:"variable-label",label:(0,l.__)("Name","elementor"),errorMsg:L?.message,noticeMsg:(0,b.labelHint)(w)},t.createElement(g.LabelField,{id:"variable-label",value:w,error:L,onChange:e=>{S(e),C("")},onErrorChange:e=>{O({value:w,message:e})},onKeyDown:handleKeyDown})),k&&t.createElement(m.FormField,{errorMsg:T,label:(0,l.__)("Value","elementor")},t.createElement(s.Typography,{variant:"h5"},t.createElement(k,{propTypeKey:A,onPropTypeKeyChange:e=>R(e),value:P,onChange:e=>{I(e),C(""),V("")},onValidationChange:V,propType:E,onKeyDown:handleKeyDown}))),x&&t.createElement(s.FormHelperText,{error:!0},x)),t.createElement(s.CardActions,{sx:{pt:.5,pb:1}},t.createElement(s.Button,{size:"small",variant:"contained",disabled:B,onClick:handleRestore},(0,l.__)("Restore","elementor")))))}},"./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx":function(e,a,r){r.r(a),r.d(a,{VariableSelectionPopover:function(){return VariableSelectionPopover}});var t=r("react"),n=r("@elementor/editor-v1-adapters"),o=r("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),i=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),s=r("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),l=r("./packages/packages/core/editor-variables/src/hooks/use-quota-permissions.ts"),c=r("./packages/packages/core/editor-variables/src/components/variable-creation.tsx"),p=r("./packages/packages/core/editor-variables/src/components/variable-edit.tsx"),u=r("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx"),d=r("./packages/packages/core/editor-variables/src/components/variables-selection.tsx");const b="list",g="add",m="edit",VariableSelectionPopover=({closePopover:e,propTypeKey:a,selectedVariable:r})=>{const[v,k]=(0,t.useState)(b),[f,y]=(0,t.useState)(""),{open:h}=(0,u.usePanelActions)(),E=(0,n.isExperimentActive)("e_variables_manager")?()=>{h()}:void 0;return t.createElement(i.VariableTypeProvider,{propTypeKey:a},t.createElement(o.PopoverContentRefContextProvider,null,function RenderView(e){const a=(0,s.usePermissions)(),r=(0,l.useQuotaPermissions)(e.propTypeKey),n={onClose:()=>{e.closePopover()},onGoBack:()=>{e.setCurrentView(b)}};a.canAdd()&&(n.onAdd=()=>{e.setCurrentView(g)});a.canEdit()&&(n.onEdit=a=>{e.setEditId(a),e.setCurrentView(m)});a.canManageSettings()&&e.onSettings&&(n.onSettings=()=>{e.closePopover(),e.onSettings?.()});const handleSubmitOnEdit=()=>{e?.selectedVariable?.key===e.editId?n.onClose():n.onGoBack?.()};if(b===e.currentView)return t.createElement(d.VariablesSelection,{closePopover:n.onClose,onAdd:n.onAdd,onEdit:n.onEdit,onSettings:n.onSettings,disabled:!r.canAdd()});if(g===e.currentView)return t.createElement(c.VariableCreation,{onGoBack:n.onGoBack,onClose:n.onClose});if(m===e.currentView)return t.createElement(p.VariableEdit,{editId:e.editId,onGoBack:n.onGoBack,onClose:n.onClose,onSubmit:handleSubmitOnEdit});return null}({propTypeKey:a,currentView:v,selectedVariable:r,editId:f,setEditId:y,setCurrentView:k,closePopover:e,onSettings:E})))}},"./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-auto-edit.ts":function(e,a,r){r.r(a),r.d(a,{useAutoEdit:function(){return useAutoEdit}});var t=r("react");const useAutoEdit=()=>{const[e,a]=(0,t.useState)(void 0);return{autoEditVariableId:e,startAutoEdit:(0,t.useCallback)(e=>{a(e)},[]),handleAutoEditComplete:(0,t.useCallback)(()=>{setTimeout(()=>{a(void 0)},100)},[])}}},"./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-error-navigation.ts":function(e,a,r){r.r(a),r.d(a,{useErrorNavigation:function(){return useErrorNavigation}});var t=r("react");const useErrorNavigation=()=>{const e=(0,t.useRef)(0);return{createNavigationCallback:(0,t.useCallback)((a,r,t)=>()=>{if(!a?.length)return;const n=e.current,o=a[n];if(o){r(o);const i=n+1;i>=a.length?(t(),e.current=0):e.current=i}},[]),resetNavigation:(0,t.useCallback)(()=>{e.current=0},[])}}},"./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-variables-manager-state.ts":function(e,a,r){r.r(a),r.d(a,{useVariablesManagerState:function(){return useVariablesManagerState}});var t=r("react"),n=r("./packages/packages/core/editor-variables/src/batch-operations.ts"),o=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),i=r("./packages/packages/core/editor-variables/src/service.ts"),s=r("./packages/packages/core/editor-variables/src/utils/filter-by-search.ts"),l=r("./packages/packages/core/editor-variables/src/utils/variables-to-list.ts"),c=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const useVariablesManagerState=()=>{const[e,a]=(0,t.useState)(()=>(0,o.getVariables)(!1)),[r,p]=(0,t.useState)([]),[u,d]=(0,t.useState)(!1),[b,g]=(0,t.useState)(!1),[m,v]=(0,t.useState)(!1),[k,f]=(0,t.useState)(""),y=(0,t.useCallback)(r=>{a({...e,...r}),g(!0)},[e]),h=(0,t.useCallback)((e,r,t)=>{const o=(0,n.generateTempId)(),i={id:o,label:r.trim(),value:t.trim(),type:e};return a(e=>({...e,[o]:i})),g(!0),o},[]),E=(0,t.useCallback)(e=>{p(a=>[...a,e]),a(a=>({...a,[e]:{...a[e],deleted:!0}})),g(!0)},[]),_=(0,t.useCallback)(async()=>{const t=(0,o.getVariables)(!1);v(!0);const n=await i.service.batchSave(t,e,r);if(n.success){await i.service.load();const e=i.service.variables();a(e),p([]),g(!1)}return{success:n.success}},[e,r]);return{variables:(0,t.useCallback)(()=>{const a=(0,l.variablesToList)(e).filter(e=>!e.deleted),r=(0,l.applySelectionFilters)(a,(0,c.getVariableTypes)()),t=(0,s.filterBySearch)(r,k);return Object.fromEntries(t.map(({key:e,...a})=>[e,a]))},[e,k])(),deletedVariables:r,isDirty:b,isSaveDisabled:u,handleOnChange:y,createVariable:h,handleDeleteVariable:E,handleSave:_,isSaving:m,handleSearch:e=>{f(e)},searchValue:k,setIsSaving:v,setIsSaveDisabled:d}}},"./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-edit-menu.tsx":function(e,a,r){r.r(a),r.d(a,{VariableEditMenu:function(){return VariableEditMenu}});var t=r("react"),n=r("@elementor/icons"),o=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const VariableEditMenu=({menuActions:e,disabled:a,itemId:r})=>{const i=(0,o.usePopupState)({variant:"popover"}),s=(0,o.bindTrigger)(i);return t.createElement(t.Fragment,null,t.createElement(o.IconButton,_extends({},s,{disabled:a,size:"tiny",onClick:e=>{e.stopPropagation(),s.onClick?.(e)}}),t.createElement(n.DotsVerticalIcon,{fontSize:"tiny"})),t.createElement(o.Menu,_extends({disablePortal:!0,MenuListProps:{dense:!0},PaperProps:{elevation:6}},(0,o.bindMenu)(i),{anchorEl:i.anchorEl,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},open:i.isOpen,onClose:i.close}),e.map(e=>t.createElement(o.MenuItem,{key:e.name,onClick:a=>{a.stopPropagation(),e.onClick?.(r),i.close()},sx:{color:e.color,gap:1}},e.icon&&(0,t.createElement)(e.icon,{fontSize:"inherit"})," ",e.name))))}},"./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-cell.tsx":function(e,a,r){r.r(a),r.d(a,{VariableTableCell:function(){return VariableTableCell}});var t=r("react"),n=r("@elementor/ui");const VariableTableCell=({children:e,isHeader:a,width:r,maxWidth:o,align:i,noPadding:s,sx:l})=>{const c={maxWidth:o??150,cursor:"initial",typography:"caption",...a&&{color:"text.primary",fontWeight:"bold"},...a&&!s&&{padding:"10px 16px"},...r&&{width:r},...l};return t.createElement(n.TableCell,{size:"small",padding:s?"none":void 0,align:i,sx:c},e)}},"./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-row.tsx":function(e,a,r){r.r(a),r.d(a,{VariableRow:function(){return VariableRow}});var t=r("react"),n=r("@elementor/editor-ui"),o=r("@elementor/icons"),i=r("@elementor/ui"),s=r("./packages/packages/core/editor-variables/src/hooks/use-quota-permissions.ts"),l=r("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),c=r("./packages/packages/core/editor-variables/src/components/ui/variable-promotion-chip.tsx"),p=r("./packages/packages/core/editor-variables/src/components/variables-manager/variable-editable-cell.tsx"),u=r("./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-edit-menu.tsx"),d=r("./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-cell.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const VariableRow=e=>{const{row:a,variables:r,handleOnChange:b,autoEditVariableId:g,onAutoEditComplete:m,onFieldError:v,menuActions:k,handleRowRef:f,itemProps:y,showDropIndication:h,triggerProps:E,itemStyle:_,triggerStyle:x,isDragged:C,dropPosition:T,setTriggerRef:V,isSorting:w}=e,S=(0,t.useRef)(null),P=!(0,s.useQuotaPermissions)(a.type).canEdit(),I=h&&"before"===T,A=h&&"after"===T;return t.createElement(i.TableRow,_extends({},y,{ref:y.ref,selected:C,sx:{...P&&{"& td, & th":{color:"text.disabled"}},...I&&{"& td, & th":{borderTop:"2px solid",borderTopColor:"primary.main"}},...A&&{"& td, & th":{borderBottom:"2px solid",borderBottomColor:"primary.main"}},"&:hover, &:focus-within":{backgroundColor:"action.hover",'& [role="toolbar"], & [draggable]':{opacity:1}},'& [role="toolbar"], & [draggable]':{opacity:0}},style:{..._,...x},onClick:()=>{P&&S.current?.toggle()}}),t.createElement(d.VariableTableCell,{noPadding:!0,width:10,maxWidth:10},t.createElement(i.IconButton,_extends({size:"small",ref:V},E,{disabled:w,draggable:!0}),t.createElement(o.GripVerticalIcon,{fontSize:"inherit"}))),t.createElement(d.VariableTableCell,null,t.createElement(p.VariableEditableCell,{initialValue:a.name,onChange:e=>{e===a.name||P||b({...r,[a.id]:{...r[a.id],label:e}})},prefixElement:(0,t.createElement)(a.icon,{fontSize:"inherit",color:P?"disabled":"inherit"}),editableElement:({value:e,onChange:n,onValidationChange:o,error:i})=>t.createElement(l.LabelField,{id:"variable-label-"+a.id,size:"tiny",value:e,onChange:n,onErrorChange:e=>{o?.(e),v?.(!!e)},error:i,focusOnShow:!0,selectOnShow:g===a.id,showWarningInfotip:!0,variables:r}),autoEdit:g===a.id&&!P,onRowRef:f(a.id),onAutoEditComplete:g===a.id?m:void 0,fieldType:"label",disabled:P},t.createElement(n.EllipsisWithTooltip,{title:a.name,sx:{border:"4px solid transparent"}},a.name))),t.createElement(d.VariableTableCell,null,t.createElement(p.VariableEditableCell,{initialValue:a.value,onChange:e=>{e===a.value||P||b({...r,[a.id]:{...r[a.id],value:e}})},editableElement:({value:e,onChange:n,onValidationChange:o,error:i})=>a.valueField?.({value:e,onChange:n,onPropTypeKeyChange:e=>{P||b({...r,[a.id]:{...r[a.id],type:e}})},propTypeKey:a.type,onValidationChange:e=>{o?.(e),v?.(!!e)},error:i})??t.createElement(t.Fragment,null),onRowRef:f(a.id),gap:.25,fieldType:"value",disabled:P},a.startIcon&&a.startIcon({value:a.value}),t.createElement(n.EllipsisWithTooltip,{title:a.value,sx:{border:"4px solid transparent",lineHeight:"1",pt:.25}},a.value))),t.createElement(d.VariableTableCell,{align:"right",noPadding:!0,width:16,maxWidth:16,sx:{paddingInlineEnd:1}},t.createElement(i.Stack,{role:"toolbar",direction:"row",justifyContent:"flex-end",alignItems:"center"},P&&t.createElement(c.VariablePromotionChip,{variableType:a.variableType,upgradeUrl:`https://go.elementor.com/renew-license-manager-${a.variableType}-variable`,ref:S}),t.createElement(u.VariableEditMenu,{menuActions:k(a.id),disabled:w,itemId:a.id}))))}},"./packages/packages/core/editor-variables/src/components/variables-manager/variable-editable-cell.tsx":function(e,a,r){r.r(a),r.d(a,{VariableEditableCell:function(){return i}});var t=r("react"),n=r("@elementor/ui"),o=r("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx");const i=t.memo(({initialValue:e,children:a,editableElement:r,onChange:i,prefixElement:s,autoEdit:l=!1,onRowRef:c,onAutoEditComplete:p,gap:u=1,fieldType:d,disabled:b=!1})=>{const[g,m]=(0,t.useState)(e),[v,k]=(0,t.useState)(!1),{labelFieldError:f,setLabelFieldError:y}=(0,o.useLabelError)(),[h,E]=(0,t.useState)(""),_=(0,t.useRef)(null),x=(0,t.useCallback)(()=>{"label"===d&&f?.message||"value"===d&&h||i(g),k(!1)},[g,i,d,f,h]);(0,t.useEffect)(()=>{c?.(_?.current)},[c]),(0,t.useEffect)(()=>{!l||v||b||(k(!0),p?.())},[l,v,p,b]);const handleDoubleClick=()=>{b||k(!0)},handleKeyDown=e=>{b||("Enter"===e.key?x():"Escape"===e.key&&k(!1)," "!==e.key||v||(e.preventDefault(),k(!0)))},C=(0,t.useCallback)(e=>{m(e)},[]),T=(0,t.useCallback)(e=>{"label"===d?y({value:g,message:e}):E(e)},[d,g,y,E]);let V;"label"===d?V=f:"value"===d&&(V={value:g,message:h});const w=r({value:g,onChange:C,onValidationChange:T,error:V});return v?t.createElement(n.ClickAwayListener,{onClickAway:x},t.createElement(n.Stack,{ref:_,direction:"row",alignItems:"center",gap:u,onDoubleClick:handleDoubleClick,onKeyDown:handleKeyDown,tabIndex:0,role:"button","aria-label":"Double click or press Space to edit"},s,w)):t.createElement(n.Stack,{ref:_,direction:"row",alignItems:"center",gap:u,onDoubleClick:handleDoubleClick,onKeyDown:handleKeyDown,tabIndex:b?-1:0,role:"button","aria-label":b?"":"Double click or press Space to edit"},s,a)})},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-create-menu.tsx":function(e,a,r){r.r(a),r.d(a,{SIZE:function(){return d},VariableManagerCreateMenu:function(){return VariableManagerCreateMenu}});var t=r("react"),n=r("@elementor/icons"),o=r("@elementor/ui"),i=r("@elementor/utils"),s=r("@wordpress/i18n"),l=r("./packages/packages/core/editor-variables/src/hooks/use-quota-permissions.ts"),c=r("./packages/packages/core/editor-variables/src/utils/tracking.ts"),p=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),u=r("./packages/packages/core/editor-variables/src/components/ui/variable-promotion-chip.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const d="tiny",VariableManagerCreateMenu=({variables:e,onCreate:a,menuState:r})=>{const i=(0,t.useRef)(null),l=(0,p.getVariableTypes)(),c=(0,t.useMemo)(()=>Object.entries(l).filter(([,e])=>!!e.defaultValue).map(([e,a])=>({key:e,propTypeKey:a.propTypeUtil.key,variableType:a.variableType,defaultValue:a.defaultValue||"",icon:a.icon})),[l]);return t.createElement(t.Fragment,null,t.createElement(o.IconButton,_extends({},(0,o.bindTrigger)(r),{ref:i,size:d,"aria-label":(0,s.__)("Add variable","elementor")}),t.createElement(n.PlusIcon,{fontSize:d})),t.createElement(o.Menu,_extends({disablePortal:!0,MenuListProps:{dense:!0},PaperProps:{elevation:6}},(0,o.bindMenu)(r),{anchorEl:i.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},"data-testid":"variable-manager-create-menu"}),c.map(n=>t.createElement(MenuOption,{key:n.key,config:n,variables:e,onCreate:a,onClose:r.close}))))},MenuOption=({config:e,variables:a,onCreate:r,onClose:n})=>{const s=(0,t.useRef)(null),p=(0,l.useQuotaPermissions)(e.propTypeKey),b=(0,i.capitalize)(e.variableType),g=!p.canAdd();return t.createElement(o.MenuItem,{onClick:()=>{if(g)return void s.current?.toggle();const t=getDefaultName(a,e.key,e.variableType);r(e.key,t,e.defaultValue),(0,c.trackVariablesManagerEvent)({action:"add",varType:e.variableType}),n()},sx:{gap:1.5,cursor:"pointer"}},(0,t.createElement)(e.icon,{fontSize:d,color:g?"disabled":"action"}),t.createElement(o.Typography,{variant:"caption",color:g?"text.disabled":"text.primary"},b),g&&t.createElement(u.VariablePromotionChip,{variableType:e.variableType,upgradeUrl:`https://go.elementor.com/go-pro-manager-${e.variableType}-variable/`,ref:s}))},getDefaultName=(e,a,r)=>{const t=Object.values(e).filter(e=>e.type===a).map(e=>e.label);let n=1,o=`${r}-${n}`;for(;t.includes(o);)n++,o=`${r}-${n}`;return o}},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx":function(e,a,r){r.r(a),r.d(a,{VariablesManagerPanel:function(){return VariablesManagerPanel},panel:function(){return _},usePanelActions:function(){return x}});var t=r("react"),n=r("@elementor/editor-panels"),o=r("@elementor/editor-ui"),i=r("@elementor/editor-v1-adapters"),s=r("@elementor/icons"),l=r("@elementor/ui"),c=r("@wordpress/i18n"),p=r("./packages/packages/core/editor-variables/src/utils/tracking.ts"),u=r("./packages/packages/core/editor-variables/src/utils/validations.ts"),d=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),b=r("./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx"),g=r("./packages/packages/core/editor-variables/src/components/ui/empty-state.tsx"),m=r("./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx"),v=r("./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-auto-edit.ts"),k=r("./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-error-navigation.ts"),f=r("./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-variables-manager-state.ts"),y=r("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-create-menu.tsx"),h=r("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-table.tsx");const E="variables-manager",{panel:_,usePanelActions:x}=(0,n.__createPanel)({id:E,component:VariablesManagerPanel,allowedEditModes:["edit",E],onOpen:()=>{(0,i.changeEditMode)(E)},onClose:async()=>{(0,i.changeEditMode)("edit")},isOpenPreviousElement:!0});function VariablesManagerPanel(){const{close:e}=x(),{open:a,close:r,isOpen:i}=(0,o.useDialog)(),E=(0,l.usePopupState)({variant:"popover"}),{variables:_,isDirty:C,searchValue:T,isSaveDisabled:V,handleOnChange:w,createVariable:S,handleDeleteVariable:P,handleSave:I,isSaving:A,handleSearch:R,setIsSaving:L,setIsSaveDisabled:O}=(0,f.useVariablesManagerState)(),{autoEditVariableId:B,startAutoEdit:D,handleAutoEditComplete:M}=(0,v.useAutoEdit)(),{createNavigationCallback:U,resetNavigation:F}=(0,k.useErrorNavigation)(),[z,N]=(0,t.useState)(null),[j,H]=(0,t.useState)(null);usePreventUnload(C);const W=(0,t.useCallback)((e,a,r)=>{const t=S(e,a,r);t&&D(t)},[S,D]),handleSaveClick=async()=>{try{H(null),F();const e=await I();return(0,p.trackVariablesManagerEvent)({action:"saveChanges"}),e}catch(e){const a=(0,u.mapServerError)(e),r=a?.action?.data?.duplicatedIds;return a&&"label"===a.field&&(r&&a.action&&(a.action.callback=U(r,D,()=>{O(!1)})),H(a),O(!0),F()),{success:!1,error:a}}finally{L(!1)}},G=(0,t.useCallback)(e=>{P(e),N(null)},[P]),q=(0,t.useCallback)(()=>[{name:(0,c.__)("Delete","elementor"),icon:s.TrashIcon,color:"error.main",onClick:e=>{const a=_[e];if(a){N({id:e,label:a.label});const r=(0,d.getVariableType)(a.type);(0,p.trackVariablesManagerEvent)({action:"delete",varType:r?.variableType})}}}],[_]),$=Object.keys(_).length>0;return t.createElement(o.ThemeProvider,null,t.createElement(n.Panel,null,t.createElement(n.PanelHeader,{sx:{height:"unset"}},t.createElement(l.Stack,{width:"100%",direction:"column",alignItems:"center"},t.createElement(l.Stack,{p:1,pl:2,width:"100%",direction:"row",alignItems:"center"},t.createElement(l.Stack,{width:"100%",direction:"row",gap:1},t.createElement(n.PanelHeaderTitle,{sx:{display:"flex",alignItems:"center",gap:.5}},t.createElement(s.ColorFilterIcon,{fontSize:"inherit"}),(0,c.__)("Variables Manager","elementor"))),t.createElement(l.Stack,{direction:"row",gap:.5,alignItems:"center"},t.createElement(y.VariableManagerCreateMenu,{onCreate:W,variables:_,menuState:E}),t.createElement(l.CloseButton,{"aria-label":"Close",slotProps:{icon:{fontSize:y.SIZE}},onClick:()=>{C?a():e()}}))),t.createElement(l.Stack,{width:"100%",direction:"row",gap:1},t.createElement(o.SearchField,{sx:{display:"flex",flex:1},placeholder:(0,c.__)("Search","elementor"),value:T,onSearch:R})),t.createElement(l.Divider,{sx:{width:"100%"}}))),t.createElement(n.PanelBody,{sx:{display:"flex",flexDirection:"column",height:"100%"}},$&&t.createElement(h.VariablesManagerTable,{menuActions:q,variables:_,onChange:w,autoEditVariableId:B,onAutoEditComplete:M,onFieldError:O}),!$&&T&&t.createElement(m.NoSearchResults,{searchValue:T,onClear:()=>R(""),icon:t.createElement(s.ColorFilterIcon,{fontSize:"large"})}),!$&&!T&&t.createElement(g.EmptyState,{title:(0,c.__)("Create your first variable","elementor"),message:(0,c.__)("Variables are saved attributes that you can apply anywhere on your site.","elementor"),icon:t.createElement(s.ColorFilterIcon,{fontSize:"large"}),onAdd:E.open})),t.createElement(n.PanelFooter,null,t.createElement(l.Infotip,{placement:"right",open:!!j,content:j?t.createElement(l.Alert,{severity:j.severity??"error",action:j.action?.label?t.createElement(l.AlertAction,{onClick:j.action.callback},j.action.label):void 0,onClose:j.action?.label?void 0:()=>{H(null),O(!1)},icon:j.IconComponent?t.createElement(j.IconComponent,null):t.createElement(s.AlertTriangleFilledIcon,null)},t.createElement(l.AlertTitle,null,j.message),j.action?.message):null,arrow:!1,slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[-10,10]}}]}}},t.createElement(l.Button,{fullWidth:!0,size:"small",color:"global",variant:"contained",disabled:V||!C||A,onClick:handleSaveClick,loading:A},(0,c.__)("Save changes","elementor"))))),z&&t.createElement(b.DeleteConfirmationDialog,{open:!0,label:z.label,onConfirm:()=>G(z.id),closeDialog:()=>N(null)}),i&&t.createElement(o.SaveChangesDialog,null,t.createElement(o.SaveChangesDialog.Title,{onClose:r},(0,c.__)("You have unsaved changes","elementor")),t.createElement(o.SaveChangesDialog.Content,null,t.createElement(o.SaveChangesDialog.ContentText,null,(0,c.__)("To avoid losing your updates, save your changes before leaving.","elementor"))),t.createElement(o.SaveChangesDialog.Actions,{actions:{discard:{label:(0,c.__)("Discard","elementor"),action:()=>{r(),e()}},confirm:{label:(0,c.__)("Save","elementor"),action:async()=>{const a=await handleSaveClick();r(),a?.success&&e()}}}})))}const usePreventUnload=e=>{(0,t.useEffect)(()=>{const handleBeforeUnload=a=>{e&&a.preventDefault()};return window.addEventListener("beforeunload",handleBeforeUnload),()=>{window.removeEventListener("beforeunload",handleBeforeUnload)}},[e])}},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-table.tsx":function(e,a,r){r.r(a),r.d(a,{VariablesManagerTable:function(){return VariablesManagerTable}});var t=r("react"),n=r("@elementor/ui"),o=r("@wordpress/i18n"),i=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),s=r("./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-cell.tsx"),l=r("./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-row.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const VariablesManagerTable=({menuActions:e,variables:a,onChange:r,autoEditVariableId:c,onAutoEditComplete:p,onFieldError:u})=>{const d=(0,t.useRef)(null),b=(0,t.useRef)(new Map);(0,t.useEffect)(()=>{if(c&&d.current){const e=b.current.get(c);e&&setTimeout(()=>{e.scrollIntoView({behavior:"smooth",block:"center",inline:"nearest"})},100)}},[c]);const handleRowRef=e=>a=>{a?b.current.set(e,a):b.current.delete(e)},g=Object.keys(a).sort(function sortVariablesOrder(e){return(a,r)=>(e[a]?.order??Number.MAX_SAFE_INTEGER)-(e[r]?.order??Number.MAX_SAFE_INTEGER)}(a)),m=g.map(e=>{const r=a[e],t=(0,i.getVariableType)(r.type);return t?{id:e,type:r.type,name:r.label,value:r.value,...t}:null}).filter(Boolean),v={minWidth:250,tableLayout:"fixed"};return t.createElement(n.TableContainer,{ref:d,sx:{overflow:"initial"}},t.createElement(n.Table,{sx:v,"aria-label":"Variables manager list with drag and drop reordering",stickyHeader:!0},t.createElement(n.TableHead,null,t.createElement(n.TableRow,null,t.createElement(s.VariableTableCell,{isHeader:!0,noPadding:!0,width:10,maxWidth:10}),t.createElement(s.VariableTableCell,{isHeader:!0},(0,o.__)("Name","elementor")),t.createElement(s.VariableTableCell,{isHeader:!0},(0,o.__)("Value","elementor")),t.createElement(s.VariableTableCell,{isHeader:!0,noPadding:!0,width:16,maxWidth:16}))),t.createElement(n.TableBody,null,t.createElement(n.UnstableSortableProvider,{value:g,onChange:e=>{const t={...a};e.forEach((e,a)=>{const r=t[e];r&&(t[e]=Object.assign({},r,{order:a+1}))}),r(t)},variant:"static",restrictAxis:!0,dragOverlay:({children:e,...a})=>t.createElement(n.Table,_extends({sx:v},a),t.createElement(n.TableBody,null,e))},m.map(o=>t.createElement(n.UnstableSortableItem,{key:o.id,id:o.id,render:n=>t.createElement(l.VariableRow,_extends({},n,{row:o,variables:a,handleOnChange:r,autoEditVariableId:c,onAutoEditComplete:p,onFieldError:u,menuActions:e,handleRowRef:handleRowRef}))}))))))}},"./packages/packages/core/editor-variables/src/components/variables-repeater-item-slot.tsx":function(e,a,r){r.r(a),r.d(a,{BackgroundRepeaterColorIndicator:function(){return BackgroundRepeaterColorIndicator},BackgroundRepeaterLabel:function(){return BackgroundRepeaterLabel},BoxShadowRepeaterColorIndicator:function(){return BoxShadowRepeaterColorIndicator}});var t=r("react"),n=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),o=r("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx");const useColorVariable=e=>{const a=e?.value?.color?.value;return(0,n.useVariable)(a||"")},BackgroundRepeaterColorIndicator=({value:e})=>{const a=useColorVariable(e);return t.createElement(o.ColorIndicator,{component:"span",size:"inherit",value:a?.value})},BackgroundRepeaterLabel=({value:e})=>{const a=useColorVariable(e);return t.createElement("span",null,a?.label)},BoxShadowRepeaterColorIndicator=({value:e})=>{const a=useColorVariable(e);return t.createElement(o.ColorIndicator,{component:"span",size:"inherit",value:a?.value})}},"./packages/packages/core/editor-variables/src/components/variables-selection.tsx":function(e,a,r){r.r(a),r.d(a,{VariablesSelection:function(){return VariablesSelection}});var t=r("react"),n=r("@elementor/editor-editing-panel"),o=r("@elementor/editor-ui"),i=r("@elementor/icons"),s=r("@elementor/ui"),l=r("@wordpress/i18n"),c=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),p=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),u=r("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),d=r("./packages/packages/core/editor-variables/src/utils/tracking.ts"),b=r("./packages/packages/core/editor-variables/src/components/ui/empty-state.tsx"),g=r("./packages/packages/core/editor-variables/src/components/ui/menu-item-content.tsx"),m=r("./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx"),v=r("./packages/packages/core/editor-variables/src/components/ui/styled-menu-list.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var r=arguments[a];for(var t in r)({}).hasOwnProperty.call(r,t)&&(e[t]=r[t])}return e},_extends.apply(null,arguments)}const k="tiny",f=(0,l.__)("Create variable","elementor"),y=(0,l.__)("Variables Manager","elementor"),getProUpgradeUrl=e=>`https://go.elementor.com/renew-license-panel-${e}-variable`,VariablesSelection=({closePopover:e,onAdd:a,onEdit:r,onSettings:h,disabled:E=!1})=>{const{icon:_,startIcon:x,variableType:C,propTypeUtil:T,emptyState:V}=(0,c.useVariableType)(),{value:w,setValue:S,path:P}=(0,u.useVariableBoundProp)(),[I,A]=(0,t.useState)(""),{list:R,hasMatches:L,isSourceNotEmpty:O,hasNoCompatibleVariables:B}=(0,p.useFilteredVariables)(I,T.key),onAddAndTrack=()=>{a?.(),(0,d.trackVariableEvent)({varType:C,controlPath:P.join("."),action:"add"})},D=[];if(a&&D.push(t.createElement(s.Tooltip,{key:"add",placement:"top",title:f},t.createElement("span",null,t.createElement(s.IconButton,{id:"add-variable-button",size:k,onClick:onAddAndTrack,"aria-label":f,disabled:E},t.createElement(i.PlusIcon,{fontSize:k}))))),h){const handleOpenManager=()=>{h(),(0,d.trackVariablesManagerEvent)({action:"openManager",varType:C,controlPath:P.join(".")})};D.push(t.createElement(s.Tooltip,{key:"settings",placement:"top",title:y},t.createElement(s.IconButton,{id:"variables-manager-button",size:k,onClick:handleOpenManager,"aria-label":y},t.createElement(i.SettingsIcon,{fontSize:k}))))}const M=x||(()=>t.createElement(_,{fontSize:k})),U=R.map(({value:e,label:a,key:n})=>({type:"item",value:n,label:a,icon:t.createElement(M,{value:e}),secondaryText:e,onEdit:r?()=>r?.(n):void 0}));return t.createElement(n.PopoverBody,null,t.createElement(o.PopoverHeader,{title:(0,l.__)("Variables","elementor"),icon:t.createElement(i.ColorFilterIcon,{fontSize:k}),onClose:e,actions:D}),O&&t.createElement(o.SearchField,{value:I,onSearch:e=>{A(e)},placeholder:(0,l.__)("Search","elementor")}),t.createElement(s.Divider,null),O&&L&&t.createElement(t.Fragment,null,t.createElement(o.PopoverMenuList,{items:U,onSelect:E?()=>{}:a=>{S(a),(0,d.trackVariableEvent)({varType:C,controlPath:P.join("."),action:"connect"}),e()},onClose:()=>{},selectedValue:w,"data-testid":`${C}-variables-list`,menuListTemplate:e=>t.createElement(v.VariablesStyledMenuList,_extends({},e,{disabled:E})),menuItemContentTemplate:e=>t.createElement(g.MenuItemContent,{item:e,disabled:E})}),E&&t.createElement(o.PromotionAlert,{message:(0,l.sprintf)((0,l.__)("Upgrade to continue creating and editing %s variables.","elementor"),C),upgradeUrl:getProUpgradeUrl(C)})),!L&&O&&t.createElement(m.NoSearchResults,{searchValue:I,onClear:()=>{A("")},icon:t.createElement(_,{fontSize:"large"})}),E&&!O&&t.createElement(b.EmptyState,{title:(0,l.sprintf)((0,l.__)("No %s variables yet","elementor"),C),message:(0,l.sprintf)((0,l.__)("Upgrade to create %s variables and maintain consistent element sizing.","elementor"),C),icon:t.createElement(_,{fontSize:"large"})},V),!O&&!B&&!E&&t.createElement(b.EmptyState,{title:(0,l.sprintf)((0,l.__)("Create your first %s variable","elementor"),C),message:(0,l.__)("Variables are saved attributes that you can apply anywhere on your site.","elementor"),icon:t.createElement(_,{fontSize:"large"}),onAdd:a}),B&&!E&&t.createElement(b.EmptyState,{title:(0,l.__)("No compatible variables","elementor"),message:(0,l.__)("Looks like none of your variables work with this control. Create a new variable to use it here.","elementor"),icon:t.createElement(_,{fontSize:"large"}),onAdd:a}))}},"./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx":function(e,a,r){r.r(a),r.d(a,{PopoverContentRefContextProvider:function(){return PopoverContentRefContextProvider},usePopoverContentRef:function(){return usePopoverContentRef}});var t=r("react"),n=r("@elementor/ui");const o=(0,t.createContext)(null),PopoverContentRefContextProvider=({children:e})=>{const[a,r]=(0,t.useState)(null);return t.createElement(o.Provider,{value:a},t.createElement(n.Box,{ref:r},e))},usePopoverContentRef=()=>(0,t.useContext)(o)},"./packages/packages/core/editor-variables/src/context/variable-type-context.tsx":function(e,a,r){r.r(a),r.d(a,{VariableTypeProvider:function(){return VariableTypeProvider},useVariableType:function(){return useVariableType}});var t=r("react"),n=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const o=(0,t.createContext)(null);function VariableTypeProvider({children:e,propTypeKey:a}){return t.createElement(o.Provider,{value:a},e)}function useVariableType(){const e=(0,t.useContext)(o);if(null===e)throw new Error("useVariableType must be used within a VariableTypeProvider");return(0,n.getVariableType)(e)}},"./packages/packages/core/editor-variables/src/controls/variable-control.tsx":function(e,a,r){r.r(a),r.d(a,{VariableControl:function(){return VariableControl}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("./packages/packages/core/editor-variables/src/components/ui/variable/assigned-variable.tsx"),i=r("./packages/packages/core/editor-variables/src/components/ui/variable/deleted-variable.tsx"),s=r("./packages/packages/core/editor-variables/src/components/ui/variable/mismatch-variable.tsx"),l=r("./packages/packages/core/editor-variables/src/components/ui/variable/missing-variable.tsx"),c=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),p=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const VariableControl=()=>{const e=(0,n.useBoundProp)(),a=e.value??e.placeholder,r=(0,c.useVariable)(a?.value);if(!r)return t.createElement(l.MissingVariable,null);const{$$type:u}=a;if(r?.deleted)return t.createElement(i.DeletedVariable,{variable:r,propTypeKey:u});const{isCompatible:d}=(0,p.getVariableType)(r.type);return d&&!d(e?.propType,r)?t.createElement(s.MismatchVariable,{variable:r}):t.createElement(o.AssignedVariable,{variable:r,propTypeKey:u})}},"./packages/packages/core/editor-variables/src/create-style-variables-repository.ts":function(e,a,r){r.r(a),r.d(a,{createStyleVariablesRepository:function(){return createStyleVariablesRepository}});var t=r("./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts"),n=r("./packages/packages/core/editor-variables/src/sync/enqueue-font.ts");const createStyleVariablesRepository=()=>{const e={};let a;const shouldUpdate=(a,r)=>!(a in e)||(e[a].label!==r.label||(e[a].value!==r.value||(!(e[a]?.deleted||!r?.deleted)||!(!e[a]?.deleted||r?.deleted)))),fontEnqueue=e=>{if(e)try{(0,n.enqueueFont)(e)}catch{}};return{subscribe:e=>(a=e,()=>{a=()=>{}}),update:r=>{(a=>{let r=!1;for(const[n,o]of Object.entries(a))shouldUpdate(n,o)&&(e[n]=o,o.type===t.fontVariablePropTypeUtil.key&&fontEnqueue(o.value),r=!0);return r})(r)&&"function"==typeof a&&a({...e})}}}},"./packages/packages/core/editor-variables/src/hooks/use-initial-value.ts":function(e,a,r){r.r(a),r.d(a,{useInitialValue:function(){return useInitialValue}});var t=r("@elementor/editor-controls"),n=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),o=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts");const useInitialValue=()=>{const{value:e}=(0,t.useBoundProp)(),a=(0,n.hasVariableType)(e?.$$type)&&Boolean(e?.value),r=(0,o.useVariable)(a?e.value:"");return a?r?r.value:"":e?.value??""}},"./packages/packages/core/editor-variables/src/hooks/use-permissions.ts":function(e,a,r){r.r(a),r.d(a,{usePermissions:function(){return usePermissions}});var t=r("@elementor/editor-current-user");const usePermissions=()=>{const{canUser:e,isAdmin:a}=(0,t.useCurrentUserCapabilities)();return{canAssign:()=>e("edit_posts"),canUnlink:()=>e("edit_posts"),canAdd:()=>a,canDelete:()=>a,canEdit:()=>a,canRestore:()=>a,canManageSettings:()=>a}}},"./packages/packages/core/editor-variables/src/hooks/use-prop-variable-action.tsx":function(e,a,r){r.r(a),r.d(a,{usePropVariableAction:function(){return usePropVariableAction}});var t=r("react"),n=r("@elementor/editor-editing-panel"),o=r("@elementor/icons"),i=r("@wordpress/i18n"),s=r("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),l=r("./packages/packages/core/editor-variables/src/utils/tracking.ts"),c=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const usePropVariableAction=()=>{const{propType:e,path:a}=(0,n.useBoundProp)(),r=resolveVariableFromPropType(e);return{visible:Boolean(r),icon:o.ColorFilterIcon,title:(0,i.__)("Variables","elementor"),content:({close:e})=>r?(trackOpenVariablePopover(a,r.variableType),t.createElement(s.VariableSelectionPopover,{closePopover:e,propTypeKey:r.propTypeUtil.key})):null}},resolveVariableFromPropType=e=>{if("union"===e.kind)for(const a of Object.keys(e.prop_types)){const e=(0,c.getVariableType)(a);if(e)return e}},trackOpenVariablePopover=(e,a)=>{(0,l.trackVariableEvent)({varType:a,controlPath:e.join("."),action:"open"})}},"./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts":function(e,a,r){r.r(a),r.d(a,{createVariable:function(){return createVariable},deleteVariable:function(){return deleteVariable},getVariables:function(){return getVariables},restoreVariable:function(){return restoreVariable},updateVariable:function(){return updateVariable},useFilteredVariables:function(){return useFilteredVariables},useVariable:function(){return useVariable}});var t=r("react"),n=r("@elementor/editor-controls"),o=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),i=r("./packages/packages/core/editor-variables/src/service.ts"),s=r("./packages/packages/core/editor-variables/src/utils/filter-by-search.ts"),l=r("./packages/packages/core/editor-variables/src/utils/variables-to-list.ts"),c=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const getVariables=(e=!0)=>{const a=i.service.variables();return e?a:Object.fromEntries(Object.entries(a).filter(([,e])=>!e.deleted))},useVariable=e=>{const a=getVariables();return a?.[e]?{...a[e],key:e}:null},useFilteredVariables=(e,a)=>{const r=usePropVariables(a),t=useVariableSelectionFilter(r),n=(0,s.filterBySearch)(t,e);return{list:n.sort((e,a)=>(e.order??Number.MAX_SAFE_INTEGER)-(a.order??Number.MAX_SAFE_INTEGER)),hasMatches:n.length>0,isSourceNotEmpty:t.length>0,hasNoCompatibleVariables:r.length>0&&0===t.length}},useVariableSelectionFilter=e=>{const{selectionFilter:a}=(0,o.useVariableType)(),{propType:r}=(0,n.useBoundProp)();return a?a(e,r):e},usePropVariables=e=>(0,t.useMemo)(()=>normalizeVariables(e),[e]),normalizeVariables=e=>{const a=getVariables(!1),r=(e=>{const a=[],r=(0,c.getVariableTypes)(),t=(0,c.getVariableType)(e);return Object.entries(r).forEach(([e,r])=>{t.variableType===r.variableType&&a.push(e)}),a})(e);return(0,l.variablesToList)(a).filter(e=>r.includes(e.type)).map(l.toNormalizedVariable)},extractId=({id:e})=>e,createVariable=e=>i.service.create(e).then(extractId),updateVariable=(e,{value:a,label:r,type:t})=>i.service.update(e,{value:a,label:r,type:t}).then(extractId),deleteVariable=e=>i.service.delete(e).then(extractId),restoreVariable=(e,a,r,t)=>i.service.restore(e,a,r,t).then(extractId)},"./packages/packages/core/editor-variables/src/hooks/use-quota-permissions.ts":function(e,a,r){r.r(a),r.d(a,{useQuotaPermissions:function(){return useQuotaPermissions}});const useQuotaPermissions=e=>{const a={...window.ElementorVariablesQuotaConfig??{},...window.ElementorVariablesQuotaConfigExtended??{}},r=void 0===a[e]&&window.elementorPro,t=a[e]||0,n=r||t>0;return{canAdd:()=>n,canEdit:()=>n}}},"./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts":function(e,a,r){r.r(a),r.d(a,{resolveBoundPropAndSetValue:function(){return resolveBoundPropAndSetValue},useVariableBoundProp:function(){return useVariableBoundProp}});var t=r("@elementor/editor-controls"),n=r("@elementor/editor-props"),o=r("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx");const useVariableBoundProp=()=>{const{propTypeUtil:e}=(0,o.useVariableType)(),a=(0,t.useBoundProp)(e);return{...a,setVariableValue:e=>resolveBoundPropAndSetValue(e,a),variableId:a.value??a.placeholder}},resolveBoundPropAndSetValue=(e,a)=>{const r=unwrapValue(a.value),t=unwrapValue(a.placeholder),n=unwrapValue(e);return r||t!==n?a.setValue(e):a.setValue(null)},unwrapValue=e=>(0,n.isTransformable)(e)?e.value:e},"./packages/packages/core/editor-variables/src/init.ts":function(e,a,r){r.r(a),r.d(a,{init:function(){return init}});var t=r("@elementor/editor"),n=r("@elementor/editor-editing-panel"),o=r("@elementor/editor-panels"),i=r("@elementor/editor-props"),s=r("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx"),l=r("./packages/packages/core/editor-variables/src/controls/variable-control.tsx"),c=r("./packages/packages/core/editor-variables/src/hooks/use-prop-variable-action.tsx"),p=r("./packages/packages/core/editor-variables/src/mcp/index.ts"),u=r("./packages/packages/core/editor-variables/src/register-variable-types.tsx"),d=r("./packages/packages/core/editor-variables/src/renderers/style-variables-renderer.tsx"),b=r("./packages/packages/core/editor-variables/src/repeater-injections.ts"),g=r("./packages/packages/core/editor-variables/src/service.ts"),m=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const{registerPopoverAction:v}=n.controlActionsMenu;function init(){(0,u.registerVariableTypes)(),(0,b.registerRepeaterInjections)(),(0,n.registerControlReplacement)({component:l.VariableControl,condition:({value:e,placeholder:a})=>!!hasVariableAssigned(e)||!e&&hasVariableAssigned(a)}),v({id:"variables",useProps:c.usePropVariableAction}),g.service.init().then(()=>{(0,p.initMcp)()}),(0,t.injectIntoTop)({id:"canvas-style-variables-render",component:d.StyleVariablesRenderer}),(0,o.__registerPanel)(s.panel)}function hasVariableAssigned(e){return!!(0,i.isTransformable)(e)&&(0,m.hasVariableType)(e.$$type)}},"./packages/packages/core/editor-variables/src/mcp/index.ts":function(e,a,r){r.r(a),r.d(a,{initMcp:function(){return initMcp}});var t=r("@elementor/editor-mcp"),n=r("./packages/packages/core/editor-variables/src/mcp/manage-variable-tool.ts"),o=r("./packages/packages/core/editor-variables/src/mcp/variables-resource.ts");function initMcp(){(0,t.isAngieAvailable)()&&((0,n.initManageVariableTool)(),(0,o.initVariablesResource)())}},"./packages/packages/core/editor-variables/src/mcp/manage-variable-tool.ts":function(e,a,r){r.r(a),r.d(a,{initManageVariableTool:function(){return initManageVariableTool}});var t=r("@elementor/editor-mcp"),n=r("@elementor/schema"),o=r("./packages/packages/core/editor-variables/src/service.ts"),i=r("./packages/packages/core/editor-variables/src/mcp/variables-resource.ts");const initManageVariableTool=()=>{(0,t.getMCPByDomain)("variables").addTool({name:"manage-global-variable",schema:{action:n.z.enum(["create","update","delete"]).describe("Operation to perform"),id:n.z.string().optional().describe("Variable id (required for update/delete). Get from list-global-variables."),type:n.z.string().optional().describe('Variable type: "global-color-variable" or "global-font-variable" (required for create)'),label:n.z.string().optional().describe("Variable label (required for create/update)"),value:n.z.string().optional().describe("Variable value (required for create/update)")},outputSchema:{status:n.z.enum(["ok"]).describe("Operation status"),message:n.z.string().optional().describe("Error details if status is error")},modelPreferences:{intelligencePriority:.75,speedPriority:.75},requiredResources:[{uri:i.GLOBAL_VARIABLES_URI,description:"Global variables"}],description:'Manages global variables (create/update/delete). Existing variables available in resources.\nCREATE: requires type, label, value. Ensure label is unique.\nUPDATE: requires id, label, value. When renaming: keep existing value. When updating value: keep exact label.\nDELETE: requires id. DESTRUCTIVE - confirm with user first.\n\n# NAMING - IMPORTANT\nthe variables names should ALWAYS be lowercased and dashed spaced. example: "Headline Primary" should be "headline-primary"\n',handler:async e=>{const a=function getServiceActions(e){return{create({type:a,label:r,value:t}){if(!a||!r||!t)throw new Error("Create requires type, label, and value");return e.create({type:a,label:r,value:t})},update({id:a,label:r,value:t}){if(!a||!r||!t)throw new Error("Update requires id, label, and value");return e.update(a,{label:r,value:t})},delete({id:a}){if(!a)throw new Error("delete requires id");return e.delete(a)}}}(o.service)[e.action];if(a)return await a(e),{status:"ok"};throw new Error(`Unknown action ${e.action}`)},isDestructive:!0})}},"./packages/packages/core/editor-variables/src/mcp/variables-resource.ts":function(e,a,r){r.r(a),r.d(a,{GLOBAL_VARIABLES_URI:function(){return o},initVariablesResource:function(){return initVariablesResource}});var t=r("@elementor/editor-mcp"),n=r("./packages/packages/core/editor-variables/src/service.ts");const o="elementor://global-variables",initVariablesResource=()=>{[(0,t.getMCPByDomain)("canvas"),(0,t.getMCPByDomain)("variables")].forEach(e=>{const{mcpServer:a}=e;a.resource("global-variables",o,{description:"List of Global variables. Defined as a key-value store (ID as key, global-variable object as value)"},async()=>{const e={};return Object.entries(n.service.variables()).forEach(([a,r])=>{r.deleted||(e[a]=r)}),{contents:[{uri:o,text:JSON.stringify(e)}]}}),window.addEventListener("variables:updated",()=>{a.server.sendResourceUpdated({uri:o,contents:[{uri:o,text:localStorage["elementor-global-variables"]}]})})})}},"./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts":function(e,a,r){r.r(a),r.d(a,{colorVariablePropTypeUtil:function(){return o}});var t=r("@elementor/editor-props"),n=r("@elementor/schema");const o=(0,t.createPropUtils)("global-color-variable",n.z.string())},"./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts":function(e,a,r){r.r(a),r.d(a,{fontVariablePropTypeUtil:function(){return o}});var t=r("@elementor/editor-props"),n=r("@elementor/schema");const o=(0,t.createPropUtils)("global-font-variable",n.z.string())},"./packages/packages/core/editor-variables/src/prop-types/size-variable-prop-type.ts":function(e,a,r){r.r(a),r.d(a,{sizeVariablePropTypeUtil:function(){return o}});var t=r("@elementor/editor-props"),n=r("@elementor/schema");const o=(0,t.createPropUtils)("global-size-variable",n.z.string())},"./packages/packages/core/editor-variables/src/register-variable-types.tsx":function(e,a,r){r.r(a),r.d(a,{registerVariableTypes:function(){return registerVariableTypes}});var t=r("react"),n=r("@elementor/editor-props"),o=r("@elementor/editor-ui"),i=r("@elementor/icons"),s=r("./packages/packages/core/editor-variables/src/components/fields/color-field.tsx"),l=r("./packages/packages/core/editor-variables/src/components/fields/font-field.tsx"),c=r("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx"),p=r("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts"),u=r("./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts"),d=r("./packages/packages/core/editor-variables/src/prop-types/size-variable-prop-type.ts"),b=r("./packages/packages/core/editor-variables/src/transformers/empty-transformer.tsx"),g=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function registerVariableTypes(){(0,g.registerVariableType)({key:p.colorVariablePropTypeUtil.key,valueField:s.ColorField,icon:i.BrushIcon,propTypeUtil:p.colorVariablePropTypeUtil,fallbackPropTypeUtil:n.colorPropTypeUtil,variableType:"color",startIcon:({value:e})=>t.createElement(c.ColorIndicator,{size:"inherit",component:"span",value:e}),defaultValue:"#ffffff"}),(0,g.registerVariableType)({key:u.fontVariablePropTypeUtil.key,valueField:l.FontField,icon:i.TextIcon,propTypeUtil:u.fontVariablePropTypeUtil,fallbackPropTypeUtil:n.stringPropTypeUtil,variableType:"font",defaultValue:"Roboto"});const e={isActive:!1,icon:i.ExpandDiagonalIcon,propTypeUtil:d.sizeVariablePropTypeUtil,fallbackPropTypeUtil:n.sizePropTypeUtil,styleTransformer:b.EmptyTransformer,variableType:"size",selectionFilter:()=>[],emptyState:t.createElement(o.CtaButton,{size:"small",href:"https://go.elementor.com/go-pro-panel-size-variable/"})};(0,g.registerVariableType)({...e,key:d.sizeVariablePropTypeUtil.key,defaultValue:"0px"}),(0,g.registerVariableType)({...e,key:"global-custom-size-variable"})}},"./packages/packages/core/editor-variables/src/renderers/style-variables-renderer.tsx":function(e,a,r){r.r(a),r.d(a,{StyleVariablesRenderer:function(){return StyleVariablesRenderer}});var t=r("react"),n=r("@elementor/editor-v1-adapters"),o=r("@elementor/ui"),i=r("./packages/packages/core/editor-variables/src/style-variables-repository.ts");const s="body";function StyleVariablesRenderer(){const e=function usePortalContainer(){return(0,n.__privateUseListenTo)((0,n.commandEndEvent)("editor/documents/attach-preview"),()=>(0,n.getCanvasIframeDocument)()?.head)}(),a=function useStyleVariables(){const[e,a]=(0,t.useState)({});return(0,t.useEffect)(()=>{const e=i.styleVariablesRepository.subscribe(a);return()=>{e()}},[]),e}(),r=Object.keys(a).length>0;if(!e||!r)return null;const l=function convertToCssVariables(e){return Object.entries(e).map(([e,a])=>function cssVariableDeclaration(e,a){const r=a?.deleted?e:a.label,t=a.value;return`--${r}:${t};`}(e,a)).join("")}(a),c=`${s}{${l}}`;return t.createElement(o.Portal,{container:e},t.createElement("style",{"data-e-style-id":"e-variables",key:c},c))}},"./packages/packages/core/editor-variables/src/repeater-injections.ts":function(e,a,r){r.r(a),r.d(a,{registerRepeaterInjections:function(){return registerRepeaterInjections}});var t=r("@elementor/editor-controls"),n=r("@elementor/editor-props"),o=r("./packages/packages/core/editor-variables/src/components/variables-repeater-item-slot.tsx"),i=r("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts");function registerRepeaterInjections(){(0,t.injectIntoRepeaterItemIcon)({id:"color-variables-background-icon",component:o.BackgroundRepeaterColorIndicator,condition:({value:e})=>hasAssignedColorVariable(n.backgroundColorOverlayPropTypeUtil.extract(e)?.color)}),(0,t.injectIntoRepeaterItemIcon)({id:"color-variables-icon",component:o.BoxShadowRepeaterColorIndicator,condition:({value:e})=>hasAssignedColorVariable(n.shadowPropTypeUtil.extract(e)?.color)}),(0,t.injectIntoRepeaterItemLabel)({id:"color-variables-label",component:o.BackgroundRepeaterLabel,condition:({value:e})=>hasAssignedColorVariable(n.backgroundColorOverlayPropTypeUtil.extract(e)?.color)})}const hasAssignedColorVariable=e=>!!i.colorVariablePropTypeUtil.isValid(e)},"./packages/packages/core/editor-variables/src/service.ts":function(e,a,r){r.r(a),r.d(a,{service:function(){return c}});var t=r("@wordpress/i18n"),n=r("./packages/packages/core/editor-variables/src/api.ts"),o=r("./packages/packages/core/editor-variables/src/batch-operations.ts"),i=r("./packages/packages/core/editor-variables/src/storage.ts"),s=r("./packages/packages/core/editor-variables/src/style-variables-repository.ts");const l=new i.Storage,c={variables:()=>l.load(),findIdByLabel(e){const a=Object.entries(this.variables()).find(([,a])=>a.label===e);if(!a)throw new Error(`Variable with label ${e} not found`);return a[0]},findVariableByLabel(e){return Object.values(this.variables()).find(a=>a.label===e)||null},getWatermark:()=>l.state.watermark,init:()=>c.load(),load:()=>n.apiClient.list().then(e=>{const{success:a,data:r}=e.data;if(!a)throw new Error("Unexpected response from server");return r}).then(e=>{const{variables:a,watermark:r}=e;return l.fill(a,r),s.styleVariablesRepository.update(a),a}),create:({type:e,label:a,value:r})=>n.apiClient.create(e,a,r).then(e=>{const{success:a,data:r}=e.data;if(!a){const e=r?.message||(0,t.__)("Unexpected response from server","elementor");throw new Error(e)}return r}).then(e=>{const{variable:a,watermark:r}=e;handleWatermark(i.OP_RW,r);const{id:t,...n}=a;return l.add(t,n),s.styleVariablesRepository.update({[t]:n}),{id:t,variable:n}}),update:(e,{label:a,value:r,type:o})=>n.apiClient.update(e,a,r,o).then(e=>{const{success:a,data:r}=e.data;if(!a){const e=r?.message||(0,t.__)("Unexpected response from server","elementor");throw new Error(e)}return r}).then(e=>{const{variable:a,watermark:r}=e;handleWatermark(i.OP_RW,r);const{id:t,...n}=a;return l.update(t,n),s.styleVariablesRepository.update({[t]:n}),{id:t,variable:n}}),delete:e=>n.apiClient.delete(e).then(e=>{const{success:a,data:r}=e.data;if(!a)throw new Error("Unexpected response from server");return r}).then(e=>{const{variable:a,watermark:r}=e;handleWatermark(i.OP_RW,r);const{id:t,...n}=a;return l.update(t,n),s.styleVariablesRepository.update({[t]:n}),{id:t,variable:n}}),restore:(e,a,r,t)=>n.apiClient.restore(e,a,r,t).then(e=>{const{success:a,data:r}=e.data;if(!a)throw new Error("Unexpected response from server");return r}).then(e=>{const{variable:a,watermark:r}=e;handleWatermark(i.OP_RW,r);const{id:t,...n}=a;return l.update(t,n),s.styleVariablesRepository.update({[t]:n}),{id:t,variable:n}}),batchSave:(e,a,r)=>{const t=(0,o.buildOperationsArray)(e,a,r),c={operations:t,watermark:l.state.watermark};return 0===t.length?Promise.resolve({success:!0,watermark:l.state.watermark,operations:0}):n.apiClient.batch(c).then(e=>{const{success:a,data:r}=e.data;if(!a)throw new Error("Unexpected response from server");return r}).then(e=>{const{results:a,watermark:r}=e;return handleWatermark(i.OP_RW,r),a&&a.forEach(e=>{if(e.variable){const{id:a,...r}=e.variable;"create"===e.type?l.add(a,r):l.update(a,r),s.styleVariablesRepository.update({[a]:r})}}),{success:!0,watermark:r,operations:t.length}})}},handleWatermark=(e,a)=>{l.watermarkDiff(e,a)&&setTimeout(()=>c.load(),500),l.watermark(a)}},"./packages/packages/core/editor-variables/src/storage.ts":function(e,a,r){r.r(a),r.d(a,{OP_RW:function(){return o},Storage:function(){return Storage}});const t="elementor-global-variables",n="elementor-global-variables-watermark",o="RW";class Storage{notifyChange(){window.dispatchEvent(new Event("variables:updated"))}constructor(){this.state={watermark:-1,variables:{}}}load(){return this.state.watermark=parseInt(localStorage.getItem(n)||"-1"),this.state.variables=JSON.parse(localStorage.getItem(t)||"{}"),this.state.variables}fill(e,a){this.state.variables={},e&&Object.keys(e).length&&(this.state.variables=e),this.state.watermark=a,localStorage.setItem(n,this.state.watermark.toString()),localStorage.setItem(t,JSON.stringify(this.state.variables)),this.notifyChange()}add(e,a){this.load(),this.state.variables[e]=a,localStorage.setItem(t,JSON.stringify(this.state.variables)),this.notifyChange()}update(e,a){this.load(),this.state.variables[e]=a,localStorage.setItem(t,JSON.stringify(this.state.variables)),this.notifyChange()}watermark(e){this.state.watermark=e,localStorage.setItem(n,this.state.watermark.toString())}watermarkDiff(e,a){const r=a-this.state.watermark;return o===e?1!==r:"RO"===e&&0!==r}}},"./packages/packages/core/editor-variables/src/style-variables-repository.ts":function(e,a,r){r.r(a),r.d(a,{styleVariablesRepository:function(){return t}});const t=(0,r("./packages/packages/core/editor-variables/src/create-style-variables-repository.ts").createStyleVariablesRepository)()},"./packages/packages/core/editor-variables/src/sync/enqueue-font.ts":function(e,a,r){r.r(a),r.d(a,{enqueueFont:function(){return enqueueFont}});const enqueueFont=(e,a="preview")=>{const r=window;return r.elementor?.helpers?.enqueueFont?.(e,a)??null}},"./packages/packages/core/editor-variables/src/transformers/empty-transformer.tsx":function(e,a,r){r.r(a),r.d(a,{EmptyTransformer:function(){return n}});var t=r("@elementor/editor-canvas");const n=(0,t.createTransformer)(e=>null)},"./packages/packages/core/editor-variables/src/transformers/inheritance-transformer.tsx":function(e,a,r){r.r(a),r.d(a,{inheritanceTransformer:function(){return u}});var t=r("react"),n=r("@elementor/editor-canvas"),o=r("@elementor/ui"),i=r("@wordpress/i18n"),s=r("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx"),l=r("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts"),c=r("./packages/packages/core/editor-variables/src/service.ts"),p=r("./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts");const u=(0,n.createTransformer)(e=>{const a=c.service.variables()[e];if(!a)return t.createElement("span",null,(0,i.__)("Missing variable","elementor"));const r=a.type===l.colorVariablePropTypeUtil.key,n=(0,p.resolveCssVariable)(e,a);return t.createElement(o.Stack,{direction:"row",spacing:.5,sx:{paddingInline:"1px"},alignItems:"center"},r&&t.createElement(s.ColorIndicator,{size:"inherit",value:a.value}),t.createElement(o.Typography,{variant:"caption",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"},n))})},"./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts":function(e,a,r){r.r(a),r.d(a,{resolveCssVariable:function(){return resolveCssVariable}});const resolveCssVariable=(e,a)=>{let r=e,t="";if(a&&(t=a.value),a&&!a.deleted&&(r=a.label),!r.trim())return null;const n=`--${r}`;return t.trim()?`var(${n}, ${t})`:`var(${n})`}},"./packages/packages/core/editor-variables/src/transformers/variable-transformer.ts":function(e,a,r){r.r(a),r.d(a,{variableTransformer:function(){return i}});var t=r("@elementor/editor-canvas"),n=r("./packages/packages/core/editor-variables/src/service.ts"),o=r("./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts");const i=(0,t.createTransformer)(e=>{const a=n.service.variables()[e]||n.service.findVariableByLabel(e);if(!a)return null;const r=n.service.findIdByLabel(a.label);return(0,o.resolveCssVariable)(r,a)})},"./packages/packages/core/editor-variables/src/utils/filter-by-search.ts":function(e,a,r){function filterBySearch(e,a){const r=a.toLowerCase();return e.filter(e=>e.label.toLowerCase().includes(r))}r.r(a),r.d(a,{filterBySearch:function(){return filterBySearch}})},"./packages/packages/core/editor-variables/src/utils/llm-propvalue-label-resolver.ts":function(e,a,r){r.r(a),r.d(a,{globalVariablesLLMResolvers:function(){return n}});var t=r("./packages/packages/core/editor-variables/src/service.ts");const defaultResolver=e=>a=>{const r=String(a);return{$$type:e,value:t.service.variables()[r]?r:t.service.findIdByLabel(r)}},n={"global-color-variable":defaultResolver("global-color-variable"),"global-font-variable":defaultResolver("global-font-variable"),"global-size-variable":defaultResolver("global-size-variable")}},"./packages/packages/core/editor-variables/src/utils/tracking.ts":function(e,a,r){r.r(a),r.d(a,{trackVariableEvent:function(){return trackVariableEvent},trackVariablesManagerEvent:function(){return trackVariablesManagerEvent}});var t=r("@elementor/events");const trackVariableEvent=({varType:e,controlPath:a,action:r})=>{const{dispatchEvent:n,config:o}=(0,t.getMixpanel)();if(!o?.names?.variables?.[r])return;const i=o.names.variables[r];n?.(i,{location:o?.locations?.variables||"",secondaryLocation:o?.secondaryLocations?.variablesPopover||"",trigger:o?.triggers?.click||"",var_type:e,control_path:a,action_type:i})},trackVariablesManagerEvent=({action:e,varType:a,controlPath:r})=>{const{dispatchEvent:n,config:o}=(0,t.getMixpanel)();if(!o?.names?.variables?.[e])return;const i=o.names.variables[e],s={location:o?.locations?.variablesManager||"",trigger:o?.triggers?.click||"",action_type:i};a&&(s.var_type=a),r&&(s.style_control_path=r),n?.(i,s)}},"./packages/packages/core/editor-variables/src/utils/unlink-variable.ts":function(e,a,r){r.r(a),r.d(a,{createUnlinkHandler:function(){return createUnlinkHandler},transformValueBeforeUnlink:function(){return transformValueBeforeUnlink}});var t=r("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function transformValueBeforeUnlink(e,a){const{valueTransformer:r}=(0,t.getVariableType)(a);return r?r(e.value,e.type):e.value}function createUnlinkHandler(e,a,r){return()=>{const{fallbackPropTypeUtil:n}=(0,t.getVariableType)(a),o=transformValueBeforeUnlink(e,a);r(n.create(o))}}},"./packages/packages/core/editor-variables/src/utils/validations.ts":function(e,a,r){r.r(a),r.d(a,{ERROR_MESSAGES:function(){return o},VARIABLE_LABEL_MAX_LENGTH:function(){return i},labelHint:function(){return labelHint},mapServerError:function(){return mapServerError},validateLabel:function(){return validateLabel},validateValue:function(){return validateValue}});var t=r("@elementor/icons"),n=r("@wordpress/i18n");const o={MISSING_VARIABLE_NAME:(0,n.__)("Give your variable a name.","elementor"),MISSING_VARIABLE_VALUE:(0,n.__)("Add a value to complete your variable.","elementor"),INVALID_CHARACTERS:(0,n.__)("Use letters, numbers, dashes (-), or underscores (_) for the name.","elementor"),NO_NON_SPECIAL_CHARACTER:(0,n.__)("Names have to include at least one non-special character.","elementor"),VARIABLE_LABEL_MAX_LENGTH:(0,n.__)("Keep names up to 50 characters.","elementor"),DUPLICATED_LABEL:(0,n.__)("This variable name already exists. Please choose a unique name.","elementor"),UNEXPECTED_ERROR:(0,n.__)("There was a glitch. Try saving your variable again.","elementor"),BATCH:{DUPLICATED_LABELS:(e,a)=>(0,n.sprintf)((0,n.__)("We found %1$d duplicated %2$s.","elementor"),e,a),UNEXPECTED_ERROR:(0,n.__)("There was a glitch.","elementor"),DUPLICATED_LABEL_ACTION:(0,n.__)("Take me there","elementor"),DUPLICATED_LABEL_ACTION_MESSAGE:(0,n.__)("Please rename the variables.","elementor"),UNEXPECTED_ERROR_ACTION_MESSAGE:(0,n.__)("Try saving your variables again.","elementor")}},i=50,mapServerError=e=>{if("duplicated_label"===e?.response?.data?.code)return{field:"label",message:o.DUPLICATED_LABEL};if("batch_duplicated_label"===e?.response?.data?.code){const a=e?.response?.data?.data??{},r=Object.keys(a).length,n=1===r?"name":"names",i=Object.keys(a);return{field:"label",message:o.BATCH.DUPLICATED_LABELS(r,n),severity:"error",IconComponent:t.AlertTriangleFilledIcon,action:{label:o.BATCH.DUPLICATED_LABEL_ACTION,message:o.BATCH.DUPLICATED_LABEL_ACTION_MESSAGE,data:{duplicatedIds:i}}}}return"batch_operation_failed"===e?.response?.data?.code?{field:"label",message:o.BATCH.UNEXPECTED_ERROR,severity:"secondary",IconComponent:t.InfoCircleFilledIcon,action:{message:o.BATCH.UNEXPECTED_ERROR_ACTION_MESSAGE}}:void 0},validateLabel=(e,a)=>{if(!e.trim())return o.MISSING_VARIABLE_NAME;if(!/^[a-zA-Z0-9_-]+$/.test(e))return o.INVALID_CHARACTERS;return/[a-zA-Z0-9]/.test(e)?i<e.length?o.VARIABLE_LABEL_MAX_LENGTH:Object.values(a??{}).some(a=>a.label===e)?o.DUPLICATED_LABEL:"":o.NO_NON_SPECIAL_CHARACTER},labelHint=e=>.8*i-1<e.length?o.VARIABLE_LABEL_MAX_LENGTH:"",validateValue=e=>e.trim()?"":o.MISSING_VARIABLE_VALUE},"./packages/packages/core/editor-variables/src/utils/variables-to-list.ts":function(e,a,r){r.r(a),r.d(a,{applySelectionFilters:function(){return applySelectionFilters},toNormalizedVariable:function(){return toNormalizedVariable},variablesToList:function(){return variablesToList}});const variablesToList=e=>Object.entries(e).map(([e,a])=>({key:e,...a})),toNormalizedVariable=({key:e,label:a,value:r,order:t})=>({key:e,label:a,value:r,order:t}),applySelectionFilters=(e,a)=>{const r={};return e.forEach(e=>(r[e.type]??=[]).push(e)),Object.entries(r).flatMap(([e,r])=>{const t=a[e]?.selectionFilter,n=r.map(toNormalizedVariable);return(t?.(n)??n).map(a=>({...a,type:e}))})}},"./packages/packages/core/editor-variables/src/variables-registry/create-variable-type-registry.ts":function(e,a,r){r.r(a),r.d(a,{createVariableTypeRegistry:function(){return createVariableTypeRegistry}});var t=r("@elementor/editor-canvas"),n=r("@elementor/editor-editing-panel"),o=r("./packages/packages/core/editor-variables/src/transformers/inheritance-transformer.tsx"),i=r("./packages/packages/core/editor-variables/src/transformers/variable-transformer.ts");function createVariableTypeRegistry(){const e={},registerTransformer=(e,a)=>{t.styleTransformersRegistry.register(e,a??i.variableTransformer)},registerInheritanceTransformer=e=>{n.stylesInheritanceTransformersRegistry.register(e,o.inheritanceTransformer)};return{registerVariableType:({key:a,icon:r,startIcon:t,valueField:n,propTypeUtil:o,variableType:i,defaultValue:s,selectionFilter:l,valueTransformer:c,styleTransformer:p,fallbackPropTypeUtil:u,isCompatible:d,emptyState:b,isActive:g=!0})=>{const m=a??o.key;d||(d=(e,a)=>"union"===e.kind&&a.type in e.prop_types),e[m]={icon:r,startIcon:t,valueField:n,propTypeUtil:o,variableType:i,defaultValue:s,selectionFilter:l,valueTransformer:c,fallbackPropTypeUtil:u,isCompatible:d,emptyState:b,isActive:g},registerTransformer(o.key,p),registerInheritanceTransformer(o.key)},getVariableType:a=>e[a],getVariableTypes:()=>e,hasVariableType:a=>a in e&&!!e[a].isActive}}},"./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts":function(e,a,r){r.r(a),r.d(a,{getVariableType:function(){return o},getVariableTypes:function(){return i},hasVariableType:function(){return s},registerVariableType:function(){return n}});var t=r("./packages/packages/core/editor-variables/src/variables-registry/create-variable-type-registry.ts");const{registerVariableType:n,getVariableType:o,getVariableTypes:i,hasVariableType:s}=(0,t.createVariableTypeRegistry)()},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-canvas":function(e){e.exports=window.elementorV2.editorCanvas},"@elementor/editor-controls":function(e){e.exports=window.elementorV2.editorControls},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-panels":function(e){e.exports=window.elementorV2.editorPanels},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/events":function(e){e.exports=window.elementorV2.events},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},a={};function __webpack_require__(r){var t=a[r];if(void 0!==t)return t.exports;var n=a[r]={exports:{}};return e[r](n,n.exports,__webpack_require__),n.exports}__webpack_require__.n=function(e){var a=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(a,{a:a}),a},__webpack_require__.d=function(e,a){for(var r in a)__webpack_require__.o(a,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:a[r]})},__webpack_require__.o=function(e,a){return Object.prototype.hasOwnProperty.call(e,a)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var r={};!function(){__webpack_require__.r(r),__webpack_require__.d(r,{GLOBAL_VARIABLES_URI:function(){return a.GLOBAL_VARIABLES_URI},Utils:function(){return s},init:function(){return e.init},registerVariableType:function(){return i.registerVariableType},registerVariableTypes:function(){return n.registerVariableTypes},service:function(){return o.service},sizeVariablePropTypeUtil:function(){return t.sizeVariablePropTypeUtil}});var e=__webpack_require__("./packages/packages/core/editor-variables/src/init.ts"),a=__webpack_require__("./packages/packages/core/editor-variables/src/mcp/variables-resource.ts"),t=__webpack_require__("./packages/packages/core/editor-variables/src/prop-types/size-variable-prop-type.ts"),n=__webpack_require__("./packages/packages/core/editor-variables/src/register-variable-types.tsx"),o=__webpack_require__("./packages/packages/core/editor-variables/src/service.ts"),i=__webpack_require__("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const s={globalVariablesLLMResolvers:__webpack_require__("./packages/packages/core/editor-variables/src/utils/llm-propvalue-label-resolver.ts").globalVariablesLLMResolvers}}(),(window.elementorV2=window.elementorV2||{}).editorVariables=r}(),window.elementorV2.editorVariables?.init?.();
//# sourceMappingURL=editor-variables.js.map