<?php

namespace VendorDuplicator\Aws;

/**
 * Builds AWS clients based on configuration settings.
 *
 * @method \VendorDuplicator\Aws\ACMPCA\ACMPCAClient createACMPCA(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionACMPCA(array $args = [])
 * @method \VendorDuplicator\Aws\ARCZonalShift\ARCZonalShiftClient createARCZonalShift(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionARCZonalShift(array $args = [])
 * @method \VendorDuplicator\Aws\AccessAnalyzer\AccessAnalyzerClient createAccessAnalyzer(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAccessAnalyzer(array $args = [])
 * @method \VendorDuplicator\Aws\Account\AccountClient createAccount(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAccount(array $args = [])
 * @method \VendorDuplicator\Aws\Acm\AcmClient createAcm(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAcm(array $args = [])
 * @method \VendorDuplicator\Aws\AlexaForBusiness\AlexaForBusinessClient createAlexaForBusiness(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAlexaForBusiness(array $args = [])
 * @method \VendorDuplicator\Aws\Amplify\AmplifyClient createAmplify(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAmplify(array $args = [])
 * @method \VendorDuplicator\Aws\AmplifyBackend\AmplifyBackendClient createAmplifyBackend(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAmplifyBackend(array $args = [])
 * @method \VendorDuplicator\Aws\AmplifyUIBuilder\AmplifyUIBuilderClient createAmplifyUIBuilder(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAmplifyUIBuilder(array $args = [])
 * @method \VendorDuplicator\Aws\ApiGateway\ApiGatewayClient createApiGateway(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApiGateway(array $args = [])
 * @method \VendorDuplicator\Aws\ApiGatewayManagementApi\ApiGatewayManagementApiClient createApiGatewayManagementApi(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApiGatewayManagementApi(array $args = [])
 * @method \VendorDuplicator\Aws\ApiGatewayV2\ApiGatewayV2Client createApiGatewayV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApiGatewayV2(array $args = [])
 * @method \VendorDuplicator\Aws\AppConfig\AppConfigClient createAppConfig(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppConfig(array $args = [])
 * @method \VendorDuplicator\Aws\AppConfigData\AppConfigDataClient createAppConfigData(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppConfigData(array $args = [])
 * @method \VendorDuplicator\Aws\AppFabric\AppFabricClient createAppFabric(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppFabric(array $args = [])
 * @method \VendorDuplicator\Aws\AppIntegrationsService\AppIntegrationsServiceClient createAppIntegrationsService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppIntegrationsService(array $args = [])
 * @method \VendorDuplicator\Aws\AppMesh\AppMeshClient createAppMesh(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppMesh(array $args = [])
 * @method \VendorDuplicator\Aws\AppRegistry\AppRegistryClient createAppRegistry(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppRegistry(array $args = [])
 * @method \VendorDuplicator\Aws\AppRunner\AppRunnerClient createAppRunner(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppRunner(array $args = [])
 * @method \VendorDuplicator\Aws\AppSync\AppSyncClient createAppSync(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppSync(array $args = [])
 * @method \VendorDuplicator\Aws\Appflow\AppflowClient createAppflow(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppflow(array $args = [])
 * @method \VendorDuplicator\Aws\ApplicationAutoScaling\ApplicationAutoScalingClient createApplicationAutoScaling(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApplicationAutoScaling(array $args = [])
 * @method \VendorDuplicator\Aws\ApplicationCostProfiler\ApplicationCostProfilerClient createApplicationCostProfiler(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApplicationCostProfiler(array $args = [])
 * @method \VendorDuplicator\Aws\ApplicationDiscoveryService\ApplicationDiscoveryServiceClient createApplicationDiscoveryService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApplicationDiscoveryService(array $args = [])
 * @method \VendorDuplicator\Aws\ApplicationInsights\ApplicationInsightsClient createApplicationInsights(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionApplicationInsights(array $args = [])
 * @method \VendorDuplicator\Aws\Appstream\AppstreamClient createAppstream(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAppstream(array $args = [])
 * @method \VendorDuplicator\Aws\Athena\AthenaClient createAthena(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAthena(array $args = [])
 * @method \VendorDuplicator\Aws\AuditManager\AuditManagerClient createAuditManager(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAuditManager(array $args = [])
 * @method \VendorDuplicator\Aws\AugmentedAIRuntime\AugmentedAIRuntimeClient createAugmentedAIRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAugmentedAIRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\AutoScaling\AutoScalingClient createAutoScaling(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAutoScaling(array $args = [])
 * @method \VendorDuplicator\Aws\AutoScalingPlans\AutoScalingPlansClient createAutoScalingPlans(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionAutoScalingPlans(array $args = [])
 * @method \VendorDuplicator\Aws\Backup\BackupClient createBackup(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBackup(array $args = [])
 * @method \VendorDuplicator\Aws\BackupGateway\BackupGatewayClient createBackupGateway(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBackupGateway(array $args = [])
 * @method \VendorDuplicator\Aws\BackupStorage\BackupStorageClient createBackupStorage(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBackupStorage(array $args = [])
 * @method \VendorDuplicator\Aws\Batch\BatchClient createBatch(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBatch(array $args = [])
 * @method \VendorDuplicator\Aws\BillingConductor\BillingConductorClient createBillingConductor(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBillingConductor(array $args = [])
 * @method \VendorDuplicator\Aws\Braket\BraketClient createBraket(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBraket(array $args = [])
 * @method \VendorDuplicator\Aws\Budgets\BudgetsClient createBudgets(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionBudgets(array $args = [])
 * @method \VendorDuplicator\Aws\Chime\ChimeClient createChime(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionChime(array $args = [])
 * @method \VendorDuplicator\Aws\ChimeSDKIdentity\ChimeSDKIdentityClient createChimeSDKIdentity(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionChimeSDKIdentity(array $args = [])
 * @method \VendorDuplicator\Aws\ChimeSDKMediaPipelines\ChimeSDKMediaPipelinesClient createChimeSDKMediaPipelines(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionChimeSDKMediaPipelines(array $args = [])
 * @method \VendorDuplicator\Aws\ChimeSDKMeetings\ChimeSDKMeetingsClient createChimeSDKMeetings(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionChimeSDKMeetings(array $args = [])
 * @method \VendorDuplicator\Aws\ChimeSDKMessaging\ChimeSDKMessagingClient createChimeSDKMessaging(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionChimeSDKMessaging(array $args = [])
 * @method \VendorDuplicator\Aws\ChimeSDKVoice\ChimeSDKVoiceClient createChimeSDKVoice(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionChimeSDKVoice(array $args = [])
 * @method \VendorDuplicator\Aws\CleanRooms\CleanRoomsClient createCleanRooms(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCleanRooms(array $args = [])
 * @method \VendorDuplicator\Aws\Cloud9\Cloud9Client createCloud9(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloud9(array $args = [])
 * @method \VendorDuplicator\Aws\CloudControlApi\CloudControlApiClient createCloudControlApi(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudControlApi(array $args = [])
 * @method \VendorDuplicator\Aws\CloudDirectory\CloudDirectoryClient createCloudDirectory(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudDirectory(array $args = [])
 * @method \VendorDuplicator\Aws\CloudFormation\CloudFormationClient createCloudFormation(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudFormation(array $args = [])
 * @method \VendorDuplicator\Aws\CloudFront\CloudFrontClient createCloudFront(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudFront(array $args = [])
 * @method \VendorDuplicator\Aws\CloudHSMV2\CloudHSMV2Client createCloudHSMV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudHSMV2(array $args = [])
 * @method \VendorDuplicator\Aws\CloudHsm\CloudHsmClient createCloudHsm(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudHsm(array $args = [])
 * @method \VendorDuplicator\Aws\CloudSearch\CloudSearchClient createCloudSearch(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudSearch(array $args = [])
 * @method \VendorDuplicator\Aws\CloudSearchDomain\CloudSearchDomainClient createCloudSearchDomain(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudSearchDomain(array $args = [])
 * @method \VendorDuplicator\Aws\CloudTrail\CloudTrailClient createCloudTrail(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudTrail(array $args = [])
 * @method \VendorDuplicator\Aws\CloudTrailData\CloudTrailDataClient createCloudTrailData(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudTrailData(array $args = [])
 * @method \VendorDuplicator\Aws\CloudWatch\CloudWatchClient createCloudWatch(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudWatch(array $args = [])
 * @method \VendorDuplicator\Aws\CloudWatchEvents\CloudWatchEventsClient createCloudWatchEvents(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudWatchEvents(array $args = [])
 * @method \VendorDuplicator\Aws\CloudWatchEvidently\CloudWatchEvidentlyClient createCloudWatchEvidently(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudWatchEvidently(array $args = [])
 * @method \VendorDuplicator\Aws\CloudWatchLogs\CloudWatchLogsClient createCloudWatchLogs(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudWatchLogs(array $args = [])
 * @method \VendorDuplicator\Aws\CloudWatchRUM\CloudWatchRUMClient createCloudWatchRUM(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCloudWatchRUM(array $args = [])
 * @method \VendorDuplicator\Aws\CodeArtifact\CodeArtifactClient createCodeArtifact(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeArtifact(array $args = [])
 * @method \VendorDuplicator\Aws\CodeBuild\CodeBuildClient createCodeBuild(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeBuild(array $args = [])
 * @method \VendorDuplicator\Aws\CodeCatalyst\CodeCatalystClient createCodeCatalyst(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeCatalyst(array $args = [])
 * @method \VendorDuplicator\Aws\CodeCommit\CodeCommitClient createCodeCommit(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeCommit(array $args = [])
 * @method \VendorDuplicator\Aws\CodeDeploy\CodeDeployClient createCodeDeploy(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeDeploy(array $args = [])
 * @method \VendorDuplicator\Aws\CodeGuruProfiler\CodeGuruProfilerClient createCodeGuruProfiler(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeGuruProfiler(array $args = [])
 * @method \VendorDuplicator\Aws\CodeGuruReviewer\CodeGuruReviewerClient createCodeGuruReviewer(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeGuruReviewer(array $args = [])
 * @method \VendorDuplicator\Aws\CodeGuruSecurity\CodeGuruSecurityClient createCodeGuruSecurity(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeGuruSecurity(array $args = [])
 * @method \VendorDuplicator\Aws\CodePipeline\CodePipelineClient createCodePipeline(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodePipeline(array $args = [])
 * @method \VendorDuplicator\Aws\CodeStar\CodeStarClient createCodeStar(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeStar(array $args = [])
 * @method \VendorDuplicator\Aws\CodeStarNotifications\CodeStarNotificationsClient createCodeStarNotifications(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeStarNotifications(array $args = [])
 * @method \VendorDuplicator\Aws\CodeStarconnections\CodeStarconnectionsClient createCodeStarconnections(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCodeStarconnections(array $args = [])
 * @method \VendorDuplicator\Aws\CognitoIdentity\CognitoIdentityClient createCognitoIdentity(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCognitoIdentity(array $args = [])
 * @method \VendorDuplicator\Aws\CognitoIdentityProvider\CognitoIdentityProviderClient createCognitoIdentityProvider(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCognitoIdentityProvider(array $args = [])
 * @method \VendorDuplicator\Aws\CognitoSync\CognitoSyncClient createCognitoSync(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCognitoSync(array $args = [])
 * @method \VendorDuplicator\Aws\Comprehend\ComprehendClient createComprehend(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionComprehend(array $args = [])
 * @method \VendorDuplicator\Aws\ComprehendMedical\ComprehendMedicalClient createComprehendMedical(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionComprehendMedical(array $args = [])
 * @method \VendorDuplicator\Aws\ComputeOptimizer\ComputeOptimizerClient createComputeOptimizer(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionComputeOptimizer(array $args = [])
 * @method \VendorDuplicator\Aws\ConfigService\ConfigServiceClient createConfigService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConfigService(array $args = [])
 * @method \VendorDuplicator\Aws\Connect\ConnectClient createConnect(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConnect(array $args = [])
 * @method \VendorDuplicator\Aws\ConnectCampaignService\ConnectCampaignServiceClient createConnectCampaignService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConnectCampaignService(array $args = [])
 * @method \VendorDuplicator\Aws\ConnectCases\ConnectCasesClient createConnectCases(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConnectCases(array $args = [])
 * @method \VendorDuplicator\Aws\ConnectContactLens\ConnectContactLensClient createConnectContactLens(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConnectContactLens(array $args = [])
 * @method \VendorDuplicator\Aws\ConnectParticipant\ConnectParticipantClient createConnectParticipant(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConnectParticipant(array $args = [])
 * @method \VendorDuplicator\Aws\ConnectWisdomService\ConnectWisdomServiceClient createConnectWisdomService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionConnectWisdomService(array $args = [])
 * @method \VendorDuplicator\Aws\ControlTower\ControlTowerClient createControlTower(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionControlTower(array $args = [])
 * @method \VendorDuplicator\Aws\CostExplorer\CostExplorerClient createCostExplorer(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCostExplorer(array $args = [])
 * @method \VendorDuplicator\Aws\CostandUsageReportService\CostandUsageReportServiceClient createCostandUsageReportService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCostandUsageReportService(array $args = [])
 * @method \VendorDuplicator\Aws\CustomerProfiles\CustomerProfilesClient createCustomerProfiles(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionCustomerProfiles(array $args = [])
 * @method \VendorDuplicator\Aws\DAX\DAXClient createDAX(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDAX(array $args = [])
 * @method \VendorDuplicator\Aws\DLM\DLMClient createDLM(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDLM(array $args = [])
 * @method \VendorDuplicator\Aws\DataExchange\DataExchangeClient createDataExchange(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDataExchange(array $args = [])
 * @method \VendorDuplicator\Aws\DataPipeline\DataPipelineClient createDataPipeline(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDataPipeline(array $args = [])
 * @method \VendorDuplicator\Aws\DataSync\DataSyncClient createDataSync(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDataSync(array $args = [])
 * @method \VendorDuplicator\Aws\DatabaseMigrationService\DatabaseMigrationServiceClient createDatabaseMigrationService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDatabaseMigrationService(array $args = [])
 * @method \VendorDuplicator\Aws\Detective\DetectiveClient createDetective(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDetective(array $args = [])
 * @method \VendorDuplicator\Aws\DevOpsGuru\DevOpsGuruClient createDevOpsGuru(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDevOpsGuru(array $args = [])
 * @method \VendorDuplicator\Aws\DeviceFarm\DeviceFarmClient createDeviceFarm(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDeviceFarm(array $args = [])
 * @method \VendorDuplicator\Aws\DirectConnect\DirectConnectClient createDirectConnect(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDirectConnect(array $args = [])
 * @method \VendorDuplicator\Aws\DirectoryService\DirectoryServiceClient createDirectoryService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDirectoryService(array $args = [])
 * @method \VendorDuplicator\Aws\DocDB\DocDBClient createDocDB(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDocDB(array $args = [])
 * @method \VendorDuplicator\Aws\DocDBElastic\DocDBElasticClient createDocDBElastic(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDocDBElastic(array $args = [])
 * @method \VendorDuplicator\Aws\DynamoDb\DynamoDbClient createDynamoDb(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDynamoDb(array $args = [])
 * @method \VendorDuplicator\Aws\DynamoDbStreams\DynamoDbStreamsClient createDynamoDbStreams(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionDynamoDbStreams(array $args = [])
 * @method \VendorDuplicator\Aws\EBS\EBSClient createEBS(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEBS(array $args = [])
 * @method \VendorDuplicator\Aws\EC2InstanceConnect\EC2InstanceConnectClient createEC2InstanceConnect(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEC2InstanceConnect(array $args = [])
 * @method \VendorDuplicator\Aws\ECRPublic\ECRPublicClient createECRPublic(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionECRPublic(array $args = [])
 * @method \VendorDuplicator\Aws\EKS\EKSClient createEKS(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEKS(array $args = [])
 * @method \VendorDuplicator\Aws\EMRContainers\EMRContainersClient createEMRContainers(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEMRContainers(array $args = [])
 * @method \VendorDuplicator\Aws\EMRServerless\EMRServerlessClient createEMRServerless(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEMRServerless(array $args = [])
 * @method \VendorDuplicator\Aws\Ec2\Ec2Client createEc2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEc2(array $args = [])
 * @method \VendorDuplicator\Aws\Ecr\EcrClient createEcr(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEcr(array $args = [])
 * @method \VendorDuplicator\Aws\Ecs\EcsClient createEcs(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEcs(array $args = [])
 * @method \VendorDuplicator\Aws\Efs\EfsClient createEfs(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEfs(array $args = [])
 * @method \VendorDuplicator\Aws\ElastiCache\ElastiCacheClient createElastiCache(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElastiCache(array $args = [])
 * @method \VendorDuplicator\Aws\ElasticBeanstalk\ElasticBeanstalkClient createElasticBeanstalk(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElasticBeanstalk(array $args = [])
 * @method \VendorDuplicator\Aws\ElasticInference\ElasticInferenceClient createElasticInference(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElasticInference(array $args = [])
 * @method \VendorDuplicator\Aws\ElasticLoadBalancing\ElasticLoadBalancingClient createElasticLoadBalancing(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElasticLoadBalancing(array $args = [])
 * @method \VendorDuplicator\Aws\ElasticLoadBalancingV2\ElasticLoadBalancingV2Client createElasticLoadBalancingV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElasticLoadBalancingV2(array $args = [])
 * @method \VendorDuplicator\Aws\ElasticTranscoder\ElasticTranscoderClient createElasticTranscoder(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElasticTranscoder(array $args = [])
 * @method \VendorDuplicator\Aws\ElasticsearchService\ElasticsearchServiceClient createElasticsearchService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionElasticsearchService(array $args = [])
 * @method \VendorDuplicator\Aws\Emr\EmrClient createEmr(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEmr(array $args = [])
 * @method \VendorDuplicator\Aws\EntityResolution\EntityResolutionClient createEntityResolution(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEntityResolution(array $args = [])
 * @method \VendorDuplicator\Aws\EventBridge\EventBridgeClient createEventBridge(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionEventBridge(array $args = [])
 * @method \VendorDuplicator\Aws\FIS\FISClient createFIS(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionFIS(array $args = [])
 * @method \VendorDuplicator\Aws\FMS\FMSClient createFMS(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionFMS(array $args = [])
 * @method \VendorDuplicator\Aws\FSx\FSxClient createFSx(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionFSx(array $args = [])
 * @method \VendorDuplicator\Aws\FinSpaceData\FinSpaceDataClient createFinSpaceData(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionFinSpaceData(array $args = [])
 * @method \VendorDuplicator\Aws\Firehose\FirehoseClient createFirehose(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionFirehose(array $args = [])
 * @method \VendorDuplicator\Aws\ForecastQueryService\ForecastQueryServiceClient createForecastQueryService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionForecastQueryService(array $args = [])
 * @method \VendorDuplicator\Aws\ForecastService\ForecastServiceClient createForecastService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionForecastService(array $args = [])
 * @method \VendorDuplicator\Aws\FraudDetector\FraudDetectorClient createFraudDetector(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionFraudDetector(array $args = [])
 * @method \VendorDuplicator\Aws\GameLift\GameLiftClient createGameLift(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGameLift(array $args = [])
 * @method \VendorDuplicator\Aws\GameSparks\GameSparksClient createGameSparks(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGameSparks(array $args = [])
 * @method \VendorDuplicator\Aws\Glacier\GlacierClient createGlacier(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGlacier(array $args = [])
 * @method \VendorDuplicator\Aws\GlobalAccelerator\GlobalAcceleratorClient createGlobalAccelerator(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGlobalAccelerator(array $args = [])
 * @method \VendorDuplicator\Aws\Glue\GlueClient createGlue(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGlue(array $args = [])
 * @method \VendorDuplicator\Aws\GlueDataBrew\GlueDataBrewClient createGlueDataBrew(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGlueDataBrew(array $args = [])
 * @method \VendorDuplicator\Aws\Greengrass\GreengrassClient createGreengrass(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGreengrass(array $args = [])
 * @method \VendorDuplicator\Aws\GreengrassV2\GreengrassV2Client createGreengrassV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGreengrassV2(array $args = [])
 * @method \VendorDuplicator\Aws\GroundStation\GroundStationClient createGroundStation(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGroundStation(array $args = [])
 * @method \VendorDuplicator\Aws\GuardDuty\GuardDutyClient createGuardDuty(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionGuardDuty(array $args = [])
 * @method \VendorDuplicator\Aws\Health\HealthClient createHealth(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionHealth(array $args = [])
 * @method \VendorDuplicator\Aws\HealthLake\HealthLakeClient createHealthLake(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionHealthLake(array $args = [])
 * @method \VendorDuplicator\Aws\Honeycode\HoneycodeClient createHoneycode(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionHoneycode(array $args = [])
 * @method \VendorDuplicator\Aws\IVS\IVSClient createIVS(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIVS(array $args = [])
 * @method \VendorDuplicator\Aws\IVSRealTime\IVSRealTimeClient createIVSRealTime(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIVSRealTime(array $args = [])
 * @method \VendorDuplicator\Aws\Iam\IamClient createIam(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIam(array $args = [])
 * @method \VendorDuplicator\Aws\IdentityStore\IdentityStoreClient createIdentityStore(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIdentityStore(array $args = [])
 * @method \VendorDuplicator\Aws\ImportExport\ImportExportClient createImportExport(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionImportExport(array $args = [])
 * @method \VendorDuplicator\Aws\Inspector\InspectorClient createInspector(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionInspector(array $args = [])
 * @method \VendorDuplicator\Aws\Inspector2\Inspector2Client createInspector2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionInspector2(array $args = [])
 * @method \VendorDuplicator\Aws\InternetMonitor\InternetMonitorClient createInternetMonitor(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionInternetMonitor(array $args = [])
 * @method \VendorDuplicator\Aws\IoT1ClickDevicesService\IoT1ClickDevicesServiceClient createIoT1ClickDevicesService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoT1ClickDevicesService(array $args = [])
 * @method \VendorDuplicator\Aws\IoT1ClickProjects\IoT1ClickProjectsClient createIoT1ClickProjects(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoT1ClickProjects(array $args = [])
 * @method \VendorDuplicator\Aws\IoTAnalytics\IoTAnalyticsClient createIoTAnalytics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTAnalytics(array $args = [])
 * @method \VendorDuplicator\Aws\IoTDeviceAdvisor\IoTDeviceAdvisorClient createIoTDeviceAdvisor(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTDeviceAdvisor(array $args = [])
 * @method \VendorDuplicator\Aws\IoTEvents\IoTEventsClient createIoTEvents(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTEvents(array $args = [])
 * @method \VendorDuplicator\Aws\IoTEventsData\IoTEventsDataClient createIoTEventsData(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTEventsData(array $args = [])
 * @method \VendorDuplicator\Aws\IoTFleetHub\IoTFleetHubClient createIoTFleetHub(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTFleetHub(array $args = [])
 * @method \VendorDuplicator\Aws\IoTFleetWise\IoTFleetWiseClient createIoTFleetWise(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTFleetWise(array $args = [])
 * @method \VendorDuplicator\Aws\IoTJobsDataPlane\IoTJobsDataPlaneClient createIoTJobsDataPlane(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTJobsDataPlane(array $args = [])
 * @method \VendorDuplicator\Aws\IoTRoboRunner\IoTRoboRunnerClient createIoTRoboRunner(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTRoboRunner(array $args = [])
 * @method \VendorDuplicator\Aws\IoTSecureTunneling\IoTSecureTunnelingClient createIoTSecureTunneling(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTSecureTunneling(array $args = [])
 * @method \VendorDuplicator\Aws\IoTSiteWise\IoTSiteWiseClient createIoTSiteWise(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTSiteWise(array $args = [])
 * @method \VendorDuplicator\Aws\IoTThingsGraph\IoTThingsGraphClient createIoTThingsGraph(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTThingsGraph(array $args = [])
 * @method \VendorDuplicator\Aws\IoTTwinMaker\IoTTwinMakerClient createIoTTwinMaker(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTTwinMaker(array $args = [])
 * @method \VendorDuplicator\Aws\IoTWireless\IoTWirelessClient createIoTWireless(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIoTWireless(array $args = [])
 * @method \VendorDuplicator\Aws\Iot\IotClient createIot(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIot(array $args = [])
 * @method \VendorDuplicator\Aws\IotDataPlane\IotDataPlaneClient createIotDataPlane(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionIotDataPlane(array $args = [])
 * @method \VendorDuplicator\Aws\Kafka\KafkaClient createKafka(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKafka(array $args = [])
 * @method \VendorDuplicator\Aws\KafkaConnect\KafkaConnectClient createKafkaConnect(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKafkaConnect(array $args = [])
 * @method \VendorDuplicator\Aws\KendraRanking\KendraRankingClient createKendraRanking(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKendraRanking(array $args = [])
 * @method \VendorDuplicator\Aws\Keyspaces\KeyspacesClient createKeyspaces(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKeyspaces(array $args = [])
 * @method \VendorDuplicator\Aws\Kinesis\KinesisClient createKinesis(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesis(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisAnalytics\KinesisAnalyticsClient createKinesisAnalytics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisAnalytics(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisAnalyticsV2\KinesisAnalyticsV2Client createKinesisAnalyticsV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisAnalyticsV2(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisVideo\KinesisVideoClient createKinesisVideo(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisVideo(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisVideoArchivedMedia\KinesisVideoArchivedMediaClient createKinesisVideoArchivedMedia(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisVideoArchivedMedia(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisVideoMedia\KinesisVideoMediaClient createKinesisVideoMedia(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisVideoMedia(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisVideoSignalingChannels\KinesisVideoSignalingChannelsClient createKinesisVideoSignalingChannels(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisVideoSignalingChannels(array $args = [])
 * @method \VendorDuplicator\Aws\KinesisVideoWebRTCStorage\KinesisVideoWebRTCStorageClient createKinesisVideoWebRTCStorage(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKinesisVideoWebRTCStorage(array $args = [])
 * @method \VendorDuplicator\Aws\Kms\KmsClient createKms(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionKms(array $args = [])
 * @method \VendorDuplicator\Aws\LakeFormation\LakeFormationClient createLakeFormation(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLakeFormation(array $args = [])
 * @method \VendorDuplicator\Aws\Lambda\LambdaClient createLambda(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLambda(array $args = [])
 * @method \VendorDuplicator\Aws\LexModelBuildingService\LexModelBuildingServiceClient createLexModelBuildingService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLexModelBuildingService(array $args = [])
 * @method \VendorDuplicator\Aws\LexModelsV2\LexModelsV2Client createLexModelsV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLexModelsV2(array $args = [])
 * @method \VendorDuplicator\Aws\LexRuntimeService\LexRuntimeServiceClient createLexRuntimeService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLexRuntimeService(array $args = [])
 * @method \VendorDuplicator\Aws\LexRuntimeV2\LexRuntimeV2Client createLexRuntimeV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLexRuntimeV2(array $args = [])
 * @method \VendorDuplicator\Aws\LicenseManager\LicenseManagerClient createLicenseManager(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLicenseManager(array $args = [])
 * @method \VendorDuplicator\Aws\LicenseManagerLinuxSubscriptions\LicenseManagerLinuxSubscriptionsClient createLicenseManagerLinuxSubscriptions(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLicenseManagerLinuxSubscriptions(array $args = [])
 * @method \VendorDuplicator\Aws\LicenseManagerUserSubscriptions\LicenseManagerUserSubscriptionsClient createLicenseManagerUserSubscriptions(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLicenseManagerUserSubscriptions(array $args = [])
 * @method \VendorDuplicator\Aws\Lightsail\LightsailClient createLightsail(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLightsail(array $args = [])
 * @method \VendorDuplicator\Aws\LocationService\LocationServiceClient createLocationService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLocationService(array $args = [])
 * @method \VendorDuplicator\Aws\LookoutEquipment\LookoutEquipmentClient createLookoutEquipment(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLookoutEquipment(array $args = [])
 * @method \VendorDuplicator\Aws\LookoutMetrics\LookoutMetricsClient createLookoutMetrics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLookoutMetrics(array $args = [])
 * @method \VendorDuplicator\Aws\LookoutforVision\LookoutforVisionClient createLookoutforVision(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionLookoutforVision(array $args = [])
 * @method \VendorDuplicator\Aws\MQ\MQClient createMQ(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMQ(array $args = [])
 * @method \VendorDuplicator\Aws\MTurk\MTurkClient createMTurk(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMTurk(array $args = [])
 * @method \VendorDuplicator\Aws\MWAA\MWAAClient createMWAA(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMWAA(array $args = [])
 * @method \VendorDuplicator\Aws\MachineLearning\MachineLearningClient createMachineLearning(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMachineLearning(array $args = [])
 * @method \VendorDuplicator\Aws\Macie\MacieClient createMacie(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMacie(array $args = [])
 * @method \VendorDuplicator\Aws\Macie2\Macie2Client createMacie2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMacie2(array $args = [])
 * @method \VendorDuplicator\Aws\MainframeModernization\MainframeModernizationClient createMainframeModernization(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMainframeModernization(array $args = [])
 * @method \VendorDuplicator\Aws\ManagedBlockchain\ManagedBlockchainClient createManagedBlockchain(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionManagedBlockchain(array $args = [])
 * @method \VendorDuplicator\Aws\ManagedBlockchainQuery\ManagedBlockchainQueryClient createManagedBlockchainQuery(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionManagedBlockchainQuery(array $args = [])
 * @method \VendorDuplicator\Aws\ManagedGrafana\ManagedGrafanaClient createManagedGrafana(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionManagedGrafana(array $args = [])
 * @method \VendorDuplicator\Aws\MarketplaceCatalog\MarketplaceCatalogClient createMarketplaceCatalog(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMarketplaceCatalog(array $args = [])
 * @method \VendorDuplicator\Aws\MarketplaceCommerceAnalytics\MarketplaceCommerceAnalyticsClient createMarketplaceCommerceAnalytics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMarketplaceCommerceAnalytics(array $args = [])
 * @method \VendorDuplicator\Aws\MarketplaceEntitlementService\MarketplaceEntitlementServiceClient createMarketplaceEntitlementService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMarketplaceEntitlementService(array $args = [])
 * @method \VendorDuplicator\Aws\MarketplaceMetering\MarketplaceMeteringClient createMarketplaceMetering(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMarketplaceMetering(array $args = [])
 * @method \VendorDuplicator\Aws\MediaConnect\MediaConnectClient createMediaConnect(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaConnect(array $args = [])
 * @method \VendorDuplicator\Aws\MediaConvert\MediaConvertClient createMediaConvert(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaConvert(array $args = [])
 * @method \VendorDuplicator\Aws\MediaLive\MediaLiveClient createMediaLive(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaLive(array $args = [])
 * @method \VendorDuplicator\Aws\MediaPackage\MediaPackageClient createMediaPackage(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaPackage(array $args = [])
 * @method \VendorDuplicator\Aws\MediaPackageV2\MediaPackageV2Client createMediaPackageV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaPackageV2(array $args = [])
 * @method \VendorDuplicator\Aws\MediaPackageVod\MediaPackageVodClient createMediaPackageVod(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaPackageVod(array $args = [])
 * @method \VendorDuplicator\Aws\MediaStore\MediaStoreClient createMediaStore(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaStore(array $args = [])
 * @method \VendorDuplicator\Aws\MediaStoreData\MediaStoreDataClient createMediaStoreData(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaStoreData(array $args = [])
 * @method \VendorDuplicator\Aws\MediaTailor\MediaTailorClient createMediaTailor(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMediaTailor(array $args = [])
 * @method \VendorDuplicator\Aws\MedicalImaging\MedicalImagingClient createMedicalImaging(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMedicalImaging(array $args = [])
 * @method \VendorDuplicator\Aws\MemoryDB\MemoryDBClient createMemoryDB(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMemoryDB(array $args = [])
 * @method \VendorDuplicator\Aws\MigrationHub\MigrationHubClient createMigrationHub(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMigrationHub(array $args = [])
 * @method \VendorDuplicator\Aws\MigrationHubConfig\MigrationHubConfigClient createMigrationHubConfig(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMigrationHubConfig(array $args = [])
 * @method \VendorDuplicator\Aws\MigrationHubOrchestrator\MigrationHubOrchestratorClient createMigrationHubOrchestrator(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMigrationHubOrchestrator(array $args = [])
 * @method \VendorDuplicator\Aws\MigrationHubRefactorSpaces\MigrationHubRefactorSpacesClient createMigrationHubRefactorSpaces(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMigrationHubRefactorSpaces(array $args = [])
 * @method \VendorDuplicator\Aws\MigrationHubStrategyRecommendations\MigrationHubStrategyRecommendationsClient createMigrationHubStrategyRecommendations(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMigrationHubStrategyRecommendations(array $args = [])
 * @method \VendorDuplicator\Aws\Mobile\MobileClient createMobile(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionMobile(array $args = [])
 * @method \VendorDuplicator\Aws\Neptune\NeptuneClient createNeptune(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionNeptune(array $args = [])
 * @method \VendorDuplicator\Aws\NetworkFirewall\NetworkFirewallClient createNetworkFirewall(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionNetworkFirewall(array $args = [])
 * @method \VendorDuplicator\Aws\NetworkManager\NetworkManagerClient createNetworkManager(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionNetworkManager(array $args = [])
 * @method \VendorDuplicator\Aws\NimbleStudio\NimbleStudioClient createNimbleStudio(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionNimbleStudio(array $args = [])
 * @method \VendorDuplicator\Aws\OAM\OAMClient createOAM(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOAM(array $args = [])
 * @method \VendorDuplicator\Aws\OSIS\OSISClient createOSIS(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOSIS(array $args = [])
 * @method \VendorDuplicator\Aws\Omics\OmicsClient createOmics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOmics(array $args = [])
 * @method \VendorDuplicator\Aws\OpenSearchServerless\OpenSearchServerlessClient createOpenSearchServerless(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOpenSearchServerless(array $args = [])
 * @method \VendorDuplicator\Aws\OpenSearchService\OpenSearchServiceClient createOpenSearchService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOpenSearchService(array $args = [])
 * @method \VendorDuplicator\Aws\OpsWorks\OpsWorksClient createOpsWorks(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOpsWorks(array $args = [])
 * @method \VendorDuplicator\Aws\OpsWorksCM\OpsWorksCMClient createOpsWorksCM(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOpsWorksCM(array $args = [])
 * @method \VendorDuplicator\Aws\Organizations\OrganizationsClient createOrganizations(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOrganizations(array $args = [])
 * @method \VendorDuplicator\Aws\Outposts\OutpostsClient createOutposts(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionOutposts(array $args = [])
 * @method \VendorDuplicator\Aws\PI\PIClient createPI(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPI(array $args = [])
 * @method \VendorDuplicator\Aws\Panorama\PanoramaClient createPanorama(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPanorama(array $args = [])
 * @method \VendorDuplicator\Aws\PaymentCryptography\PaymentCryptographyClient createPaymentCryptography(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPaymentCryptography(array $args = [])
 * @method \VendorDuplicator\Aws\PaymentCryptographyData\PaymentCryptographyDataClient createPaymentCryptographyData(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPaymentCryptographyData(array $args = [])
 * @method \VendorDuplicator\Aws\Personalize\PersonalizeClient createPersonalize(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPersonalize(array $args = [])
 * @method \VendorDuplicator\Aws\PersonalizeEvents\PersonalizeEventsClient createPersonalizeEvents(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPersonalizeEvents(array $args = [])
 * @method \VendorDuplicator\Aws\PersonalizeRuntime\PersonalizeRuntimeClient createPersonalizeRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPersonalizeRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\Pinpoint\PinpointClient createPinpoint(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPinpoint(array $args = [])
 * @method \VendorDuplicator\Aws\PinpointEmail\PinpointEmailClient createPinpointEmail(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPinpointEmail(array $args = [])
 * @method \VendorDuplicator\Aws\PinpointSMSVoice\PinpointSMSVoiceClient createPinpointSMSVoice(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPinpointSMSVoice(array $args = [])
 * @method \VendorDuplicator\Aws\PinpointSMSVoiceV2\PinpointSMSVoiceV2Client createPinpointSMSVoiceV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPinpointSMSVoiceV2(array $args = [])
 * @method \VendorDuplicator\Aws\Pipes\PipesClient createPipes(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPipes(array $args = [])
 * @method \VendorDuplicator\Aws\Polly\PollyClient createPolly(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPolly(array $args = [])
 * @method \VendorDuplicator\Aws\Pricing\PricingClient createPricing(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPricing(array $args = [])
 * @method \VendorDuplicator\Aws\PrivateNetworks\PrivateNetworksClient createPrivateNetworks(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPrivateNetworks(array $args = [])
 * @method \VendorDuplicator\Aws\PrometheusService\PrometheusServiceClient createPrometheusService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionPrometheusService(array $args = [])
 * @method \VendorDuplicator\Aws\Proton\ProtonClient createProton(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionProton(array $args = [])
 * @method \VendorDuplicator\Aws\QLDB\QLDBClient createQLDB(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionQLDB(array $args = [])
 * @method \VendorDuplicator\Aws\QLDBSession\QLDBSessionClient createQLDBSession(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionQLDBSession(array $args = [])
 * @method \VendorDuplicator\Aws\QuickSight\QuickSightClient createQuickSight(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionQuickSight(array $args = [])
 * @method \VendorDuplicator\Aws\RAM\RAMClient createRAM(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRAM(array $args = [])
 * @method \VendorDuplicator\Aws\RDSDataService\RDSDataServiceClient createRDSDataService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRDSDataService(array $args = [])
 * @method \VendorDuplicator\Aws\Rds\RdsClient createRds(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRds(array $args = [])
 * @method \VendorDuplicator\Aws\RecycleBin\RecycleBinClient createRecycleBin(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRecycleBin(array $args = [])
 * @method \VendorDuplicator\Aws\Redshift\RedshiftClient createRedshift(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRedshift(array $args = [])
 * @method \VendorDuplicator\Aws\RedshiftDataAPIService\RedshiftDataAPIServiceClient createRedshiftDataAPIService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRedshiftDataAPIService(array $args = [])
 * @method \VendorDuplicator\Aws\RedshiftServerless\RedshiftServerlessClient createRedshiftServerless(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRedshiftServerless(array $args = [])
 * @method \VendorDuplicator\Aws\Rekognition\RekognitionClient createRekognition(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRekognition(array $args = [])
 * @method \VendorDuplicator\Aws\ResilienceHub\ResilienceHubClient createResilienceHub(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionResilienceHub(array $args = [])
 * @method \VendorDuplicator\Aws\ResourceExplorer2\ResourceExplorer2Client createResourceExplorer2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionResourceExplorer2(array $args = [])
 * @method \VendorDuplicator\Aws\ResourceGroups\ResourceGroupsClient createResourceGroups(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionResourceGroups(array $args = [])
 * @method \VendorDuplicator\Aws\ResourceGroupsTaggingAPI\ResourceGroupsTaggingAPIClient createResourceGroupsTaggingAPI(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionResourceGroupsTaggingAPI(array $args = [])
 * @method \VendorDuplicator\Aws\RoboMaker\RoboMakerClient createRoboMaker(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoboMaker(array $args = [])
 * @method \VendorDuplicator\Aws\RolesAnywhere\RolesAnywhereClient createRolesAnywhere(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRolesAnywhere(array $args = [])
 * @method \VendorDuplicator\Aws\Route53\Route53Client createRoute53(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoute53(array $args = [])
 * @method \VendorDuplicator\Aws\Route53Domains\Route53DomainsClient createRoute53Domains(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoute53Domains(array $args = [])
 * @method \VendorDuplicator\Aws\Route53RecoveryCluster\Route53RecoveryClusterClient createRoute53RecoveryCluster(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoute53RecoveryCluster(array $args = [])
 * @method \VendorDuplicator\Aws\Route53RecoveryControlConfig\Route53RecoveryControlConfigClient createRoute53RecoveryControlConfig(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoute53RecoveryControlConfig(array $args = [])
 * @method \VendorDuplicator\Aws\Route53RecoveryReadiness\Route53RecoveryReadinessClient createRoute53RecoveryReadiness(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoute53RecoveryReadiness(array $args = [])
 * @method \VendorDuplicator\Aws\Route53Resolver\Route53ResolverClient createRoute53Resolver(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionRoute53Resolver(array $args = [])
 * @method \VendorDuplicator\Aws\S3\S3Client createS3(array $args = [])
 * @method \VendorDuplicator\Aws\S3\S3MultiRegionClient createMultiRegionS3(array $args = [])
 * @method \VendorDuplicator\Aws\S3Control\S3ControlClient createS3Control(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionS3Control(array $args = [])
 * @method \VendorDuplicator\Aws\S3Outposts\S3OutpostsClient createS3Outposts(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionS3Outposts(array $args = [])
 * @method \VendorDuplicator\Aws\SSMContacts\SSMContactsClient createSSMContacts(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSSMContacts(array $args = [])
 * @method \VendorDuplicator\Aws\SSMIncidents\SSMIncidentsClient createSSMIncidents(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSSMIncidents(array $args = [])
 * @method \VendorDuplicator\Aws\SSO\SSOClient createSSO(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSSO(array $args = [])
 * @method \VendorDuplicator\Aws\SSOAdmin\SSOAdminClient createSSOAdmin(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSSOAdmin(array $args = [])
 * @method \VendorDuplicator\Aws\SSOOIDC\SSOOIDCClient createSSOOIDC(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSSOOIDC(array $args = [])
 * @method \VendorDuplicator\Aws\SageMaker\SageMakerClient createSageMaker(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSageMaker(array $args = [])
 * @method \VendorDuplicator\Aws\SageMakerFeatureStoreRuntime\SageMakerFeatureStoreRuntimeClient createSageMakerFeatureStoreRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSageMakerFeatureStoreRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\SageMakerGeospatial\SageMakerGeospatialClient createSageMakerGeospatial(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSageMakerGeospatial(array $args = [])
 * @method \VendorDuplicator\Aws\SageMakerMetrics\SageMakerMetricsClient createSageMakerMetrics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSageMakerMetrics(array $args = [])
 * @method \VendorDuplicator\Aws\SageMakerRuntime\SageMakerRuntimeClient createSageMakerRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSageMakerRuntime(array $args = [])
 * @method \VendorDuplicator\Aws\SagemakerEdgeManager\SagemakerEdgeManagerClient createSagemakerEdgeManager(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSagemakerEdgeManager(array $args = [])
 * @method \VendorDuplicator\Aws\SavingsPlans\SavingsPlansClient createSavingsPlans(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSavingsPlans(array $args = [])
 * @method \VendorDuplicator\Aws\Scheduler\SchedulerClient createScheduler(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionScheduler(array $args = [])
 * @method \VendorDuplicator\Aws\Schemas\SchemasClient createSchemas(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSchemas(array $args = [])
 * @method \VendorDuplicator\Aws\SecretsManager\SecretsManagerClient createSecretsManager(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSecretsManager(array $args = [])
 * @method \VendorDuplicator\Aws\SecurityHub\SecurityHubClient createSecurityHub(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSecurityHub(array $args = [])
 * @method \VendorDuplicator\Aws\SecurityLake\SecurityLakeClient createSecurityLake(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSecurityLake(array $args = [])
 * @method \VendorDuplicator\Aws\ServerlessApplicationRepository\ServerlessApplicationRepositoryClient createServerlessApplicationRepository(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionServerlessApplicationRepository(array $args = [])
 * @method \VendorDuplicator\Aws\ServiceCatalog\ServiceCatalogClient createServiceCatalog(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionServiceCatalog(array $args = [])
 * @method \VendorDuplicator\Aws\ServiceDiscovery\ServiceDiscoveryClient createServiceDiscovery(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionServiceDiscovery(array $args = [])
 * @method \VendorDuplicator\Aws\ServiceQuotas\ServiceQuotasClient createServiceQuotas(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionServiceQuotas(array $args = [])
 * @method \VendorDuplicator\Aws\Ses\SesClient createSes(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSes(array $args = [])
 * @method \VendorDuplicator\Aws\SesV2\SesV2Client createSesV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSesV2(array $args = [])
 * @method \VendorDuplicator\Aws\Sfn\SfnClient createSfn(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSfn(array $args = [])
 * @method \VendorDuplicator\Aws\Shield\ShieldClient createShield(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionShield(array $args = [])
 * @method \VendorDuplicator\Aws\SimSpaceWeaver\SimSpaceWeaverClient createSimSpaceWeaver(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSimSpaceWeaver(array $args = [])
 * @method \VendorDuplicator\Aws\Sms\SmsClient createSms(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSms(array $args = [])
 * @method \VendorDuplicator\Aws\SnowBall\SnowBallClient createSnowBall(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSnowBall(array $args = [])
 * @method \VendorDuplicator\Aws\SnowDeviceManagement\SnowDeviceManagementClient createSnowDeviceManagement(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSnowDeviceManagement(array $args = [])
 * @method \VendorDuplicator\Aws\Sns\SnsClient createSns(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSns(array $args = [])
 * @method \VendorDuplicator\Aws\Sqs\SqsClient createSqs(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSqs(array $args = [])
 * @method \VendorDuplicator\Aws\Ssm\SsmClient createSsm(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSsm(array $args = [])
 * @method \VendorDuplicator\Aws\SsmSap\SsmSapClient createSsmSap(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSsmSap(array $args = [])
 * @method \VendorDuplicator\Aws\StorageGateway\StorageGatewayClient createStorageGateway(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionStorageGateway(array $args = [])
 * @method \VendorDuplicator\Aws\Sts\StsClient createSts(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSts(array $args = [])
 * @method \VendorDuplicator\Aws\Support\SupportClient createSupport(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSupport(array $args = [])
 * @method \VendorDuplicator\Aws\SupportApp\SupportAppClient createSupportApp(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSupportApp(array $args = [])
 * @method \VendorDuplicator\Aws\Swf\SwfClient createSwf(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSwf(array $args = [])
 * @method \VendorDuplicator\Aws\Synthetics\SyntheticsClient createSynthetics(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionSynthetics(array $args = [])
 * @method \VendorDuplicator\Aws\Textract\TextractClient createTextract(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTextract(array $args = [])
 * @method \VendorDuplicator\Aws\TimestreamQuery\TimestreamQueryClient createTimestreamQuery(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTimestreamQuery(array $args = [])
 * @method \VendorDuplicator\Aws\TimestreamWrite\TimestreamWriteClient createTimestreamWrite(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTimestreamWrite(array $args = [])
 * @method \VendorDuplicator\Aws\Tnb\TnbClient createTnb(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTnb(array $args = [])
 * @method \VendorDuplicator\Aws\TranscribeService\TranscribeServiceClient createTranscribeService(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTranscribeService(array $args = [])
 * @method \VendorDuplicator\Aws\Transfer\TransferClient createTransfer(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTransfer(array $args = [])
 * @method \VendorDuplicator\Aws\Translate\TranslateClient createTranslate(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionTranslate(array $args = [])
 * @method \VendorDuplicator\Aws\VPCLattice\VPCLatticeClient createVPCLattice(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionVPCLattice(array $args = [])
 * @method \VendorDuplicator\Aws\VerifiedPermissions\VerifiedPermissionsClient createVerifiedPermissions(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionVerifiedPermissions(array $args = [])
 * @method \VendorDuplicator\Aws\VoiceID\VoiceIDClient createVoiceID(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionVoiceID(array $args = [])
 * @method \VendorDuplicator\Aws\WAFV2\WAFV2Client createWAFV2(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWAFV2(array $args = [])
 * @method \VendorDuplicator\Aws\Waf\WafClient createWaf(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWaf(array $args = [])
 * @method \VendorDuplicator\Aws\WafRegional\WafRegionalClient createWafRegional(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWafRegional(array $args = [])
 * @method \VendorDuplicator\Aws\WellArchitected\WellArchitectedClient createWellArchitected(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWellArchitected(array $args = [])
 * @method \VendorDuplicator\Aws\WorkDocs\WorkDocsClient createWorkDocs(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWorkDocs(array $args = [])
 * @method \VendorDuplicator\Aws\WorkLink\WorkLinkClient createWorkLink(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWorkLink(array $args = [])
 * @method \VendorDuplicator\Aws\WorkMail\WorkMailClient createWorkMail(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWorkMail(array $args = [])
 * @method \VendorDuplicator\Aws\WorkMailMessageFlow\WorkMailMessageFlowClient createWorkMailMessageFlow(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWorkMailMessageFlow(array $args = [])
 * @method \VendorDuplicator\Aws\WorkSpaces\WorkSpacesClient createWorkSpaces(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWorkSpaces(array $args = [])
 * @method \VendorDuplicator\Aws\WorkSpacesWeb\WorkSpacesWebClient createWorkSpacesWeb(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionWorkSpacesWeb(array $args = [])
 * @method \VendorDuplicator\Aws\XRay\XRayClient createXRay(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionXRay(array $args = [])
 * @method \VendorDuplicator\Aws\drs\drsClient createdrs(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegiondrs(array $args = [])
 * @method \VendorDuplicator\Aws\finspace\finspaceClient createfinspace(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionfinspace(array $args = [])
 * @method \VendorDuplicator\Aws\imagebuilder\imagebuilderClient createimagebuilder(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionimagebuilder(array $args = [])
 * @method \VendorDuplicator\Aws\ivschat\ivschatClient createivschat(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionivschat(array $args = [])
 * @method \VendorDuplicator\Aws\kendra\kendraClient createkendra(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionkendra(array $args = [])
 * @method \VendorDuplicator\Aws\mgn\mgnClient createmgn(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionmgn(array $args = [])
 * @method \VendorDuplicator\Aws\signer\signerClient createsigner(array $args = [])
 * @method \VendorDuplicator\Aws\MultiRegionClient createMultiRegionsigner(array $args = [])
 */
class Sdk
{
    const VERSION = '3.278.3';
    /** @var array Arguments for creating clients */
    private $args;
    /**
     * Constructs a new SDK object with an associative array of default
     * client settings.
     *
     * @param array $args
     *
     * @throws \InvalidArgumentException
     * @see Aws\AwsClient::__construct for a list of available options.
     */
    public function __construct(array $args = [])
    {
        $this->args = $args;
        if (!isset($args['handler']) && !isset($args['http_handler'])) {
            $this->args['http_handler'] = default_http_handler();
        }
    }
    public function __call($name, array $args)
    {
        $args = isset($args[0]) ? $args[0] : [];
        if (\strpos($name, 'createMultiRegion') === 0) {
            return $this->createMultiRegionClient(\substr($name, 17), $args);
        }
        if (\strpos($name, 'create') === 0) {
            return $this->createClient(\substr($name, 6), $args);
        }
        throw new \BadMethodCallException("Unknown method: {$name}.");
    }
    /**
     * Get a client by name using an array of constructor options.
     *
     * @param string $name Service name or namespace (e.g., DynamoDb, s3).
     * @param array  $args Arguments to configure the client.
     *
     * @return AwsClientInterface
     * @throws \InvalidArgumentException if any required options are missing or
     *                                   the service is not supported.
     * @see Aws\AwsClient::__construct for a list of available options for args.
     */
    public function createClient($name, array $args = [])
    {
        // Get information about the service from the manifest file.
        $service = manifest($name);
        $namespace = $service['namespace'];
        // Instantiate the client class.
        $client = "VendorDuplicator\\Aws\\{$namespace}\\{$namespace}Client";
        return new $client($this->mergeArgs($namespace, $service, $args));
    }
    public function createMultiRegionClient($name, array $args = [])
    {
        // Get information about the service from the manifest file.
        $service = manifest($name);
        $namespace = $service['namespace'];
        $klass = "VendorDuplicator\\Aws\\{$namespace}\\{$namespace}MultiRegionClient";
        $klass = \class_exists($klass) ? $klass : MultiRegionClient::class;
        return new $klass($this->mergeArgs($namespace, $service, $args));
    }
    /**
     * Clone existing SDK instance with ability to pass an associative array
     * of extra client settings.
     *
     * @param array $args
     *
     * @return self
     */
    public function copy(array $args = [])
    {
        return new self($args + $this->args);
    }
    private function mergeArgs($namespace, array $manifest, array $args = [])
    {
        // Merge provided args with stored, service-specific args.
        if (isset($this->args[$namespace])) {
            $args += $this->args[$namespace];
        }
        // Provide the endpoint prefix in the args.
        if (!isset($args['service'])) {
            $args['service'] = $manifest['endpoint'];
        }
        return $args + $this->args;
    }
    /**
     * Determine the endpoint prefix from a client namespace.
     *
     * @param string $name Namespace name
     *
     * @return string
     * @internal
     * @deprecated Use the `\Aws\manifest()` function instead.
     */
    public static function getEndpointPrefix($name)
    {
        return manifest($name)['endpoint'];
    }
}
