/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-03-04 10:15:40 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `nJQ2o_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1856 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1458 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2981 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `level` varchar(25) NOT NULL DEFAULT '',
  `event_type` varchar(25) NOT NULL DEFAULT '',
  `details` text NOT NULL,
  `stacktrace` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=459 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logtime` int(10) unsigned DEFAULT NULL,
  `level` varchar(25) NOT NULL DEFAULT '',
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `message` text NOT NULL,
  `type` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) NOT NULL DEFAULT '',
  `username` varchar(150) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `ip_or_host` varchar(100) DEFAULT NULL,
  `referer_info` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  `event_data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `meta_key1` varchar(255) NOT NULL,
  `meta_key2` varchar(255) NOT NULL,
  `meta_key3` varchar(255) NOT NULL,
  `meta_key4` varchar(255) NOT NULL,
  `meta_key5` varchar(255) NOT NULL,
  `meta_value1` varchar(255) NOT NULL,
  `meta_value2` text NOT NULL,
  `meta_value3` text NOT NULL,
  `meta_value4` longtext NOT NULL,
  `meta_value5` longtext NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_logged_in_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `site_id` bigint(20) NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `expires` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `released` int(10) unsigned DEFAULT NULL,
  `failed_login_ip` varchar(100) NOT NULL DEFAULT '',
  `lock_reason` varchar(128) NOT NULL DEFAULT '',
  `unlock_key` varchar(128) NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT 1,
  `backtrace_log` text NOT NULL,
  `ip_lookup_result` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_message_store` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_key` text NOT NULL,
  `message_value` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) NOT NULL DEFAULT '',
  `block_reason` varchar(128) NOT NULL DEFAULT '',
  `country_origin` varchar(50) NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `unblock` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_cmplz_cookiebanners` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `banner_version` int(11) NOT NULL,
  `default` int(11) NOT NULL,
  `position` text NOT NULL,
  `checkbox_style` text NOT NULL,
  `use_logo` text NOT NULL,
  `logo_attachment_id` text NOT NULL,
  `close_button` text NOT NULL,
  `revoke` text NOT NULL,
  `manage_consent_options` text NOT NULL,
  `header` text NOT NULL,
  `dismiss` text NOT NULL,
  `save_preferences` text NOT NULL,
  `view_preferences` text NOT NULL,
  `category_functional` text NOT NULL,
  `category_all` text NOT NULL,
  `category_stats` text NOT NULL,
  `category_prefs` text NOT NULL,
  `accept` text NOT NULL,
  `message_optin` text NOT NULL,
  `use_categories` text NOT NULL,
  `disable_cookiebanner` int(11) NOT NULL,
  `banner_width` int(11) NOT NULL,
  `soft_cookiewall` int(11) NOT NULL,
  `dismiss_on_scroll` int(11) NOT NULL,
  `dismiss_on_timeout` int(11) NOT NULL,
  `dismiss_timeout` text NOT NULL,
  `accept_informational` text NOT NULL,
  `message_optout` text NOT NULL,
  `use_custom_cookie_css` text NOT NULL,
  `custom_css` text NOT NULL,
  `statistics` text NOT NULL,
  `functional_text` text NOT NULL,
  `statistics_text` text NOT NULL,
  `statistics_text_anonymous` text NOT NULL,
  `preferences_text` text NOT NULL,
  `marketing_text` text NOT NULL,
  `colorpalette_background` text NOT NULL,
  `colorpalette_text` text NOT NULL,
  `colorpalette_toggles` text NOT NULL,
  `colorpalette_border_radius` text NOT NULL,
  `border_width` text NOT NULL,
  `font_size` text NOT NULL,
  `colorpalette_button_accept` text NOT NULL,
  `colorpalette_button_deny` text NOT NULL,
  `colorpalette_button_settings` text NOT NULL,
  `buttons_border_radius` text NOT NULL,
  `animation` text NOT NULL,
  `use_box_shadow` int(11) NOT NULL,
  `header_footer_shadow` int(11) NOT NULL,
  `hide_preview` int(11) NOT NULL,
  `disable_width_correction` int(11) NOT NULL,
  `legal_documents` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_cmplz_cookies` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `sync` int(11) NOT NULL,
  `ignored` int(11) NOT NULL,
  `retention` text NOT NULL,
  `type` text NOT NULL,
  `serviceID` int(11) NOT NULL,
  `cookieFunction` text NOT NULL,
  `collectedPersonalData` text NOT NULL,
  `purpose` text NOT NULL,
  `language` varchar(6) NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `isOwnDomainCookie` int(11) NOT NULL,
  `domain` text NOT NULL,
  `deleted` int(11) NOT NULL,
  `isMembersOnly` int(11) NOT NULL,
  `showOnPolicy` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  `lastAddDate` int(11) NOT NULL,
  `firstAddDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_cmplz_dnsmpd` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `region` text NOT NULL,
  `global_optout` int(11) NOT NULL,
  `cross_context` int(11) NOT NULL,
  `limit_sensitive` int(11) NOT NULL,
  `request_for_access` int(11) NOT NULL,
  `right_to_be_forgotten` int(11) NOT NULL,
  `right_to_data_portability` int(11) NOT NULL,
  `request_date` int(11) NOT NULL,
  `resolved` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_cmplz_services` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `serviceType` varchar(250) NOT NULL,
  `category` varchar(250) NOT NULL,
  `thirdParty` int(11) NOT NULL,
  `sharesData` int(11) NOT NULL,
  `secondParty` int(11) NOT NULL,
  `privacyStatementURL` varchar(250) NOT NULL,
  `language` varchar(6) NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `sync` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `owner` varchar(60) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_frmt_form_entry` (
  `entry_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(191) NOT NULL,
  `draft_id` varchar(12) DEFAULT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `is_spam` tinyint(1) NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('active','spam','draft','abandoned') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`entry_id`),
  KEY `entry_is_spam` (`is_spam`),
  KEY `entry_status` (`status`),
  KEY `entry_form_status` (`form_id`,`status`),
  KEY `entry_type` (`entry_type`),
  KEY `entry_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_frmt_form_entry_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `meta_entry_id` (`entry_id`),
  KEY `meta_key_object` (`entry_id`,`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_frmt_form_reports` (
  `report_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `report_value` longtext NOT NULL,
  `status` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_frmt_form_views` (
  `view_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `page_id` bigint(20) unsigned NOT NULL,
  `ip` varchar(191) DEFAULT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT 1,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`view_id`),
  KEY `view_form_id` (`form_id`),
  KEY `view_ip` (`ip`),
  KEY `view_form_object` (`form_id`,`view_id`),
  KEY `view_form_object_ip` (`form_id`,`view_id`,`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_mwai_filemeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_mwai_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `refId` varchar(64) NOT NULL,
  `envId` varchar(128) DEFAULT NULL,
  `userId` varchar(64) DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `purpose` varchar(32) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `expires` datetime DEFAULT NULL,
  `path` text DEFAULT NULL,
  `url` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_file_id` (`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=8744 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12359 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1556 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_post_smtp_logmeta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `meta_key` longtext DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_post_smtp_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `solution` longtext DEFAULT NULL,
  `success` longtext DEFAULT NULL,
  `from_header` longtext DEFAULT NULL,
  `to_header` longtext DEFAULT NULL,
  `cc_header` longtext DEFAULT NULL,
  `bcc_header` longtext DEFAULT NULL,
  `reply_to_header` longtext DEFAULT NULL,
  `transport_uri` longtext DEFAULT NULL,
  `original_to` longtext DEFAULT NULL,
  `original_subject` longtext DEFAULT NULL,
  `original_message` longtext DEFAULT NULL,
  `original_headers` longtext DEFAULT NULL,
  `session_transcript` longtext DEFAULT NULL,
  `time` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_wpbot_chat_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `conversation_id` int(11) DEFAULT NULL,
  `message` longtext NOT NULL,
  `feedback` varchar(20) DEFAULT NULL,
  `meta_info` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_wpbot_response` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `query` text NOT NULL,
  `keyword` text NOT NULL,
  `response` text NOT NULL,
  `category` varchar(256) NOT NULL,
  `intent` varchar(256) NOT NULL,
  `custom` varchar(256) NOT NULL,
  `lang` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `query` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_2` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_3` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_4` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_5` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_6` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_7` (`query`,`keyword`,`response`),
  FULLTEXT KEY `query_8` (`query`,`keyword`,`response`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_wpbot_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_wpwbot_index` (
  `id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term` varchar(50) NOT NULL DEFAULT '0',
  `term_source` varchar(20) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '0',
  `count` bigint(20) unsigned NOT NULL DEFAULT 0,
  `in_stock` int(11) NOT NULL DEFAULT 0,
  `visibility` varchar(20) NOT NULL DEFAULT '0',
  `lang` varchar(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nJQ2o_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `nJQ2o_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `nJQ2o_users` VALUES 
("1","triplea","$wp$2y$12$Fg1ah7OELBtix5uucWSCduVe1puANKoZ5vg3aMaL/xetUECZ8OqMa","triplea","cgutierrez@tecninorte.com","https://grupoberdejo.es","2025-08-12 12:35:05","","0","admin");

INSERT IGNORE INTO `nJQ2o_usermeta` VALUES 
("1","1","nickname","triplea"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","nJQ2o_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","nJQ2o_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","nJQ2o_dashboard_quick_press_last_post_id","1348"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:10:\"81.43.69.0\";}"),
("19","1","closedpostboxes_dashboard","a:0:{}"),
("20","1","metaboxhidden_dashboard","a:6:{i:0;s:20:\"e-dashboard-overview\";i:1;s:21:\"dashboard_site_health\";i:2;s:13:\"wpmet-stories\";i:3;s:27:\"duplicator_dashboard_widget\";i:4;s:9:\"themeisle\";i:5;s:17:\"dashboard_primary\";}"),
("21","1","elementor_introduction","a:4:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:28:\"yoast-introduction-editor-v2\";b:1;s:27:\"e-editor-one-notice-pointer\";b:1;}"),
("22","1","nJQ2o_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:2:{s:12:\"welcomeGuide\";b:0;s:14:\"fullscreenMode\";b:0;}s:9:\"_modified\";s:24:\"2025-08-12T12:40:25.639Z\";}"),
("23","1","_hello_elementor_install_notice","1"),
("24","1","closedpostboxes_toplevel_page_maintenance","a:5:{i:0;s:8:\"mtnc-toc\";i:1;s:11:\"mtnc-themes\";i:2;s:11:\"mtnc-access\";i:3;s:8:\"mtnc-css\";i:4;s:17:\"mtnc-excludepages\";}"),
("25","1","metaboxhidden_toplevel_page_maintenance","a:0:{}"),
("26","1","nJQ2o_user-settings","libraryContent=browse&editor=tinymce"),
("27","1","nJQ2o_user-settings-time","1755161284"),
("28","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:42:\"e-dashboard-overview,dashboard_site_health\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:19:\"dashboard_right_now\";s:7:\"column4\";s:18:\"dashboard_activity\";}"),
("29","1","closedpostboxes_toplevel_page_aiowpsec","a:2:{i:0;s:15:\"spread_the_word\";i:1;s:15:\"know_developers\";}"),
("30","1","metaboxhidden_toplevel_page_aiowpsec","a:0:{}"),
("31","1","elementor_admin_notices","a:2:{s:20:\"ally_pages_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:25:\"plugin_image_optimization\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("32","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("33","1","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("34","1","nav_menu_recently_edited","5"),
("35","1","elementor_dismissed_editor_notices","a:2:{i:0;s:20:\"image_optimizer_hint\";i:1;s:19:\"ally_heading_notice\";}"),
("36","1","meta-box-order_post","a:3:{s:4:\"side\";s:92:\"auto_cache_custom_meta_box,submitdiv,categorydiv,postimagediv,tagsdiv-post_tag,pageparentdiv\";s:6:\"normal\";s:71:\"postexcerpt,trackbacksdiv,postcustom,commentstatusdiv,slugdiv,authordiv\";s:8:\"advanced\";s:0:\"\";}"),
("37","1","screen_layout_post","2"),
("38","1","aiowps_last_login_time","2026-03-02 12:47:24"),
("40","1","wpseo_seen_llm_txt_opt_in_notification","1"),
("41","1","_yoast_wpseo_introductions","a:1:{s:28:\"ai-brand-insights-pre-launch\";b:1;}"),
("42","1","_yoast_wpseo_profile_updated","1756374215"),
("71","1","nJQ2o_media_library_mode","list"),
("73","1","nJQ2o_elementor_enable_ai","1"),
("74","1","nJQ2o_elementor_pro_enable_notes_notifications","1"),
("75","1","essential-addons-for-elementor-lite_review_notice_dismissed","1"),
("79","1","_elementor_structure_popup_dismissed","1"),
("81","1","session_tokens","a:1:{s:64:\"1336191ca378ea4a55d51d912e064d89bcd9fb014677cfdda1d9be6771cb205e\";a:4:{s:10:\"expiration\";i:1772628444;s:2:\"ip\";s:12:\"81.43.69.125\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1772455644;}}"),
("82","1","frmt_dismissed_messages","a:1:{i:0;s:28:\"forminator_promote_free_plan\";}");

INSERT IGNORE INTO `nJQ2o_actionscheduler_actions` VALUES 
("866","action_scheduler/migration_hook","complete","2026-03-02 12:49:03","2026-03-02 12:49:03","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1772455743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1772455743;}","2","1","2026-03-02 12:49:23","2026-03-02 14:49:23","0",NULL),
("1561","forminator_daily_cron","canceled","2026-03-04 12:50:07","2026-03-04 12:50:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772628607;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772628607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1656","forminator_action_scheduler_cleanup","complete","2026-03-03 16:22:11","2026-03-03 16:22:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772554931;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:7200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772554931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:7200;}","1","1","2026-03-03 16:22:57","2026-03-03 18:22:57","0",NULL),
("1758","forminator_general_data_protection_cleanup","canceled","2026-03-03 16:50:17","2026-03-03 16:50:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556617;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1807","forminator_send_export","complete","2026-03-03 16:23:57","2026-03-03 16:23:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555037;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:23:59","2026-03-03 18:23:59","0",NULL),
("1808","forminator_process_report","complete","2026-03-03 16:23:57","2026-03-03 16:23:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555037;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:23:59","2026-03-03 18:23:59","0",NULL),
("1809","forminator_action_scheduler_cleanup","canceled","2026-03-03 18:22:57","2026-03-03 18:22:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772562177;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:7200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772562177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:7200;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1810","forminator_send_export","complete","2026-03-03 16:24:59","2026-03-03 16:24:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555099;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:25:01","2026-03-03 18:25:01","0",NULL),
("1811","forminator_process_report","complete","2026-03-03 16:24:59","2026-03-03 16:24:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555099;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:25:01","2026-03-03 18:25:01","0",NULL),
("1812","forminator_send_export","complete","2026-03-03 16:26:01","2026-03-03 16:26:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555161;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:26:07","2026-03-03 18:26:07","0",NULL),
("1813","forminator_process_report","complete","2026-03-03 16:26:01","2026-03-03 16:26:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555161;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:26:07","2026-03-03 18:26:07","0",NULL),
("1814","forminator_send_export","complete","2026-03-03 16:27:07","2026-03-03 16:27:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555227;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:27:08","2026-03-03 18:27:08","0",NULL),
("1815","forminator_process_report","complete","2026-03-03 16:27:07","2026-03-03 16:27:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555227;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:27:08","2026-03-03 18:27:08","0",NULL),
("1816","forminator_send_export","complete","2026-03-03 16:28:08","2026-03-03 16:28:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555288;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:28:23","2026-03-03 18:28:23","0",NULL),
("1817","forminator_process_report","complete","2026-03-03 16:28:08","2026-03-03 16:28:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555288;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:28:23","2026-03-03 18:28:23","0",NULL),
("1818","forminator_send_export","complete","2026-03-03 16:29:23","2026-03-03 16:29:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555363;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:29:39","2026-03-03 18:29:39","0",NULL),
("1819","forminator_process_report","complete","2026-03-03 16:29:23","2026-03-03 16:29:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555363;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:29:39","2026-03-03 18:29:39","0",NULL),
("1820","forminator_send_export","complete","2026-03-03 16:30:39","2026-03-03 16:30:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555439;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:30:53","2026-03-03 18:30:53","0",NULL),
("1821","forminator_process_report","complete","2026-03-03 16:30:39","2026-03-03 16:30:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555439;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:30:53","2026-03-03 18:30:53","0",NULL),
("1822","forminator_send_export","complete","2026-03-03 16:31:53","2026-03-03 16:31:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555513;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:32:28","2026-03-03 18:32:28","0",NULL),
("1823","forminator_process_report","complete","2026-03-03 16:31:53","2026-03-03 16:31:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555513;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:32:28","2026-03-03 18:32:28","0",NULL),
("1824","forminator_send_export","complete","2026-03-03 16:33:28","2026-03-03 16:33:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555608;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:33:36","2026-03-03 18:33:36","0",NULL),
("1825","forminator_process_report","complete","2026-03-03 16:33:28","2026-03-03 16:33:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555608;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:33:36","2026-03-03 18:33:36","0",NULL),
("1826","forminator_send_export","complete","2026-03-03 16:34:36","2026-03-03 16:34:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555676;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:34:47","2026-03-03 18:34:47","0",NULL),
("1827","forminator_process_report","complete","2026-03-03 16:34:36","2026-03-03 16:34:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555676;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:34:47","2026-03-03 18:34:47","0",NULL),
("1828","forminator_send_export","complete","2026-03-03 16:35:47","2026-03-03 16:35:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555747;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:35:51","2026-03-03 18:35:51","0",NULL),
("1829","forminator_process_report","complete","2026-03-03 16:35:47","2026-03-03 16:35:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555747;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:35:51","2026-03-03 18:35:51","0",NULL),
("1830","forminator_send_export","complete","2026-03-03 16:36:51","2026-03-03 16:36:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555811;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:36:51","2026-03-03 18:36:51","0",NULL),
("1831","forminator_process_report","complete","2026-03-03 16:36:51","2026-03-03 16:36:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555811;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:36:51","2026-03-03 18:36:51","0",NULL),
("1832","forminator_send_export","complete","2026-03-03 16:37:51","2026-03-03 16:37:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555871;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:37:53","2026-03-03 18:37:53","0",NULL),
("1833","forminator_process_report","complete","2026-03-03 16:37:51","2026-03-03 16:37:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555871;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:37:53","2026-03-03 18:37:53","0",NULL),
("1834","forminator_send_export","complete","2026-03-03 16:38:53","2026-03-03 16:38:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555933;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:39:23","2026-03-03 18:39:23","0",NULL),
("1835","forminator_process_report","complete","2026-03-03 16:38:53","2026-03-03 16:38:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772555933;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772555933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:39:23","2026-03-03 18:39:23","0",NULL),
("1836","forminator_send_export","complete","2026-03-03 16:40:23","2026-03-03 16:40:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556023;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:40:27","2026-03-03 18:40:27","0",NULL),
("1837","forminator_process_report","complete","2026-03-03 16:40:23","2026-03-03 16:40:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556023;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:40:27","2026-03-03 18:40:27","0",NULL),
("1838","forminator_send_export","complete","2026-03-03 16:41:27","2026-03-03 16:41:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556087;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:41:30","2026-03-03 18:41:30","0",NULL),
("1839","forminator_process_report","complete","2026-03-03 16:41:27","2026-03-03 16:41:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556087;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:41:30","2026-03-03 18:41:30","0",NULL),
("1840","forminator_send_export","complete","2026-03-03 16:42:30","2026-03-03 16:42:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556150;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:42:33","2026-03-03 18:42:33","0",NULL),
("1841","forminator_process_report","complete","2026-03-03 16:42:30","2026-03-03 16:42:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556150;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:42:33","2026-03-03 18:42:33","0",NULL),
("1842","forminator_send_export","complete","2026-03-03 16:43:33","2026-03-03 16:43:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556213;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:43:35","2026-03-03 18:43:35","0",NULL),
("1843","forminator_process_report","complete","2026-03-03 16:43:33","2026-03-03 16:43:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556213;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:43:35","2026-03-03 18:43:35","0",NULL),
("1844","forminator_send_export","complete","2026-03-03 16:44:35","2026-03-03 16:44:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556275;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:44:45","2026-03-03 18:44:45","0",NULL),
("1845","forminator_process_report","complete","2026-03-03 16:44:35","2026-03-03 16:44:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556275;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:44:45","2026-03-03 18:44:45","0",NULL),
("1846","forminator_send_export","complete","2026-03-03 16:45:45","2026-03-03 16:45:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556345;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:45:54","2026-03-03 18:45:54","0",NULL),
("1847","forminator_process_report","complete","2026-03-03 16:45:45","2026-03-03 16:45:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556345;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:45:54","2026-03-03 18:45:54","0",NULL),
("1848","forminator_send_export","complete","2026-03-03 16:46:54","2026-03-03 16:46:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556414;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:47:09","2026-03-03 18:47:09","0",NULL),
("1849","forminator_process_report","complete","2026-03-03 16:46:54","2026-03-03 16:46:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556414;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:47:09","2026-03-03 18:47:09","0",NULL),
("1850","forminator_send_export","complete","2026-03-03 16:48:09","2026-03-03 16:48:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556489;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:48:09","2026-03-03 18:48:09","0",NULL),
("1851","forminator_process_report","complete","2026-03-03 16:48:09","2026-03-03 16:48:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556489;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:48:09","2026-03-03 18:48:09","0",NULL),
("1852","forminator_send_export","complete","2026-03-03 16:49:09","2026-03-03 16:49:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556549;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:49:15","2026-03-03 18:49:15","0",NULL),
("1853","forminator_process_report","complete","2026-03-03 16:49:09","2026-03-03 16:49:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556549;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","1","2026-03-03 16:49:15","2026-03-03 18:49:15","0",NULL),
("1854","forminator_send_export","canceled","2026-03-03 16:50:15","2026-03-03 16:50:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556615;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1855","forminator_process_report","canceled","2026-03-03 16:50:15","2026-03-03 16:50:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772556615;s:18:\"\0*\0first_timestamp\";i:1772455703;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772556615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `nJQ2o_actionscheduler_groups` VALUES 
("1","forminator"),
("2","action-scheduler-migration");

INSERT IGNORE INTO `nJQ2o_actionscheduler_logs` VALUES 
("6","866","action created","2026-03-02 12:48:03","2026-03-02 12:48:03"),
("22","866","action started via Async Request","2026-03-02 12:49:23","2026-03-02 12:49:23"),
("23","866","action complete via Async Request","2026-03-02 12:49:23","2026-03-02 12:49:23"),
("2093","1561","action created","2026-03-03 12:50:07","2026-03-03 12:50:07"),
("2378","1656","action created","2026-03-03 14:22:11","2026-03-03 14:22:11"),
("2684","1758","action created","2026-03-03 15:50:17","2026-03-03 15:50:17"),
("2831","1807","action created","2026-03-03 16:22:57","2026-03-03 16:22:57"),
("2834","1808","action created","2026-03-03 16:22:57","2026-03-03 16:22:57"),
("2835","1656","action started via Async Request","2026-03-03 16:22:57","2026-03-03 16:22:57"),
("2836","1656","action complete via Async Request","2026-03-03 16:22:57","2026-03-03 16:22:57"),
("2837","1809","action created","2026-03-03 16:22:57","2026-03-03 16:22:57"),
("2838","1807","action started via Async Request","2026-03-03 16:23:59","2026-03-03 16:23:59"),
("2839","1807","action complete via Async Request","2026-03-03 16:23:59","2026-03-03 16:23:59"),
("2840","1810","action created","2026-03-03 16:23:59","2026-03-03 16:23:59"),
("2841","1808","action started via Async Request","2026-03-03 16:23:59","2026-03-03 16:23:59"),
("2842","1808","action complete via Async Request","2026-03-03 16:23:59","2026-03-03 16:23:59"),
("2843","1811","action created","2026-03-03 16:23:59","2026-03-03 16:23:59"),
("2844","1810","action started via Async Request","2026-03-03 16:25:01","2026-03-03 16:25:01"),
("2845","1810","action complete via Async Request","2026-03-03 16:25:01","2026-03-03 16:25:01"),
("2846","1812","action created","2026-03-03 16:25:01","2026-03-03 16:25:01"),
("2847","1811","action started via Async Request","2026-03-03 16:25:01","2026-03-03 16:25:01"),
("2848","1811","action complete via Async Request","2026-03-03 16:25:01","2026-03-03 16:25:01"),
("2849","1813","action created","2026-03-03 16:25:01","2026-03-03 16:25:01"),
("2850","1812","action started via Async Request","2026-03-03 16:26:07","2026-03-03 16:26:07"),
("2851","1812","action complete via Async Request","2026-03-03 16:26:07","2026-03-03 16:26:07"),
("2852","1814","action created","2026-03-03 16:26:07","2026-03-03 16:26:07"),
("2853","1813","action started via Async Request","2026-03-03 16:26:07","2026-03-03 16:26:07"),
("2854","1813","action complete via Async Request","2026-03-03 16:26:07","2026-03-03 16:26:07"),
("2855","1815","action created","2026-03-03 16:26:07","2026-03-03 16:26:07"),
("2856","1814","action started via Async Request","2026-03-03 16:27:08","2026-03-03 16:27:08"),
("2857","1814","action complete via Async Request","2026-03-03 16:27:08","2026-03-03 16:27:08"),
("2858","1816","action created","2026-03-03 16:27:08","2026-03-03 16:27:08"),
("2859","1815","action started via Async Request","2026-03-03 16:27:08","2026-03-03 16:27:08"),
("2860","1815","action complete via Async Request","2026-03-03 16:27:08","2026-03-03 16:27:08"),
("2861","1817","action created","2026-03-03 16:27:08","2026-03-03 16:27:08"),
("2862","1816","action started via Async Request","2026-03-03 16:28:23","2026-03-03 16:28:23"),
("2863","1816","action complete via Async Request","2026-03-03 16:28:23","2026-03-03 16:28:23"),
("2864","1818","action created","2026-03-03 16:28:23","2026-03-03 16:28:23"),
("2865","1817","action started via Async Request","2026-03-03 16:28:23","2026-03-03 16:28:23"),
("2866","1817","action complete via Async Request","2026-03-03 16:28:23","2026-03-03 16:28:23"),
("2867","1819","action created","2026-03-03 16:28:23","2026-03-03 16:28:23"),
("2868","1818","action started via Async Request","2026-03-03 16:29:39","2026-03-03 16:29:39"),
("2869","1818","action complete via Async Request","2026-03-03 16:29:39","2026-03-03 16:29:39"),
("2870","1820","action created","2026-03-03 16:29:39","2026-03-03 16:29:39"),
("2871","1819","action started via Async Request","2026-03-03 16:29:39","2026-03-03 16:29:39"),
("2872","1819","action complete via Async Request","2026-03-03 16:29:39","2026-03-03 16:29:39"),
("2873","1821","action created","2026-03-03 16:29:39","2026-03-03 16:29:39"),
("2874","1820","action started via Async Request","2026-03-03 16:30:53","2026-03-03 16:30:53"),
("2875","1820","action complete via Async Request","2026-03-03 16:30:53","2026-03-03 16:30:53"),
("2876","1822","action created","2026-03-03 16:30:53","2026-03-03 16:30:53"),
("2877","1821","action started via Async Request","2026-03-03 16:30:53","2026-03-03 16:30:53"),
("2878","1821","action complete via Async Request","2026-03-03 16:30:53","2026-03-03 16:30:53"),
("2879","1823","action created","2026-03-03 16:30:53","2026-03-03 16:30:53"),
("2880","1822","action started via Async Request","2026-03-03 16:32:28","2026-03-03 16:32:28"),
("2881","1822","action complete via Async Request","2026-03-03 16:32:28","2026-03-03 16:32:28"),
("2882","1824","action created","2026-03-03 16:32:28","2026-03-03 16:32:28"),
("2883","1823","action started via Async Request","2026-03-03 16:32:28","2026-03-03 16:32:28"),
("2884","1823","action complete via Async Request","2026-03-03 16:32:28","2026-03-03 16:32:28"),
("2885","1825","action created","2026-03-03 16:32:28","2026-03-03 16:32:28"),
("2886","1824","action started via WP Cron","2026-03-03 16:33:36","2026-03-03 16:33:36"),
("2887","1824","action complete via WP Cron","2026-03-03 16:33:36","2026-03-03 16:33:36"),
("2888","1826","action created","2026-03-03 16:33:36","2026-03-03 16:33:36"),
("2889","1825","action started via WP Cron","2026-03-03 16:33:36","2026-03-03 16:33:36"),
("2890","1825","action complete via WP Cron","2026-03-03 16:33:36","2026-03-03 16:33:36"),
("2891","1827","action created","2026-03-03 16:33:36","2026-03-03 16:33:36"),
("2892","1826","action started via Async Request","2026-03-03 16:34:47","2026-03-03 16:34:47"),
("2893","1826","action complete via Async Request","2026-03-03 16:34:47","2026-03-03 16:34:47"),
("2894","1828","action created","2026-03-03 16:34:47","2026-03-03 16:34:47"),
("2895","1827","action started via Async Request","2026-03-03 16:34:47","2026-03-03 16:34:47"),
("2896","1827","action complete via Async Request","2026-03-03 16:34:47","2026-03-03 16:34:47"),
("2897","1829","action created","2026-03-03 16:34:47","2026-03-03 16:34:47"),
("2898","1828","action started via Async Request","2026-03-03 16:35:51","2026-03-03 16:35:51"),
("2899","1828","action complete via Async Request","2026-03-03 16:35:51","2026-03-03 16:35:51"),
("2900","1830","action created","2026-03-03 16:35:51","2026-03-03 16:35:51"),
("2901","1829","action started via Async Request","2026-03-03 16:35:51","2026-03-03 16:35:51"),
("2902","1829","action complete via Async Request","2026-03-03 16:35:51","2026-03-03 16:35:51"),
("2903","1831","action created","2026-03-03 16:35:51","2026-03-03 16:35:51"),
("2904","1830","action started via Async Request","2026-03-03 16:36:51","2026-03-03 16:36:51"),
("2905","1830","action complete via Async Request","2026-03-03 16:36:51","2026-03-03 16:36:51"),
("2906","1832","action created","2026-03-03 16:36:51","2026-03-03 16:36:51"),
("2907","1831","action started via Async Request","2026-03-03 16:36:51","2026-03-03 16:36:51"),
("2908","1831","action complete via Async Request","2026-03-03 16:36:51","2026-03-03 16:36:51"),
("2909","1833","action created","2026-03-03 16:36:51","2026-03-03 16:36:51"),
("2910","1832","action started via Async Request","2026-03-03 16:37:53","2026-03-03 16:37:53"),
("2911","1832","action complete via Async Request","2026-03-03 16:37:53","2026-03-03 16:37:53"),
("2912","1834","action created","2026-03-03 16:37:53","2026-03-03 16:37:53"),
("2913","1833","action started via Async Request","2026-03-03 16:37:53","2026-03-03 16:37:53"),
("2914","1833","action complete via Async Request","2026-03-03 16:37:53","2026-03-03 16:37:53"),
("2915","1835","action created","2026-03-03 16:37:53","2026-03-03 16:37:53"),
("2916","1834","action started via Async Request","2026-03-03 16:39:23","2026-03-03 16:39:23"),
("2917","1834","action complete via Async Request","2026-03-03 16:39:23","2026-03-03 16:39:23"),
("2918","1836","action created","2026-03-03 16:39:23","2026-03-03 16:39:23"),
("2919","1835","action started via Async Request","2026-03-03 16:39:23","2026-03-03 16:39:23"),
("2920","1835","action complete via Async Request","2026-03-03 16:39:23","2026-03-03 16:39:23"),
("2921","1837","action created","2026-03-03 16:39:23","2026-03-03 16:39:23"),
("2922","1836","action started via Async Request","2026-03-03 16:40:27","2026-03-03 16:40:27"),
("2923","1836","action complete via Async Request","2026-03-03 16:40:27","2026-03-03 16:40:27"),
("2924","1838","action created","2026-03-03 16:40:27","2026-03-03 16:40:27"),
("2925","1837","action started via Async Request","2026-03-03 16:40:27","2026-03-03 16:40:27"),
("2926","1837","action complete via Async Request","2026-03-03 16:40:27","2026-03-03 16:40:27"),
("2927","1839","action created","2026-03-03 16:40:27","2026-03-03 16:40:27"),
("2928","1838","action started via Async Request","2026-03-03 16:41:30","2026-03-03 16:41:30"),
("2929","1838","action complete via Async Request","2026-03-03 16:41:30","2026-03-03 16:41:30"),
("2930","1840","action created","2026-03-03 16:41:30","2026-03-03 16:41:30"),
("2931","1839","action started via Async Request","2026-03-03 16:41:30","2026-03-03 16:41:30"),
("2932","1839","action complete via Async Request","2026-03-03 16:41:30","2026-03-03 16:41:30"),
("2933","1841","action created","2026-03-03 16:41:30","2026-03-03 16:41:30"),
("2934","1840","action started via Async Request","2026-03-03 16:42:33","2026-03-03 16:42:33"),
("2935","1840","action complete via Async Request","2026-03-03 16:42:33","2026-03-03 16:42:33"),
("2936","1842","action created","2026-03-03 16:42:33","2026-03-03 16:42:33"),
("2937","1841","action started via Async Request","2026-03-03 16:42:33","2026-03-03 16:42:33"),
("2938","1841","action complete via Async Request","2026-03-03 16:42:33","2026-03-03 16:42:33"),
("2939","1843","action created","2026-03-03 16:42:33","2026-03-03 16:42:33"),
("2940","1842","action started via Async Request","2026-03-03 16:43:35","2026-03-03 16:43:35"),
("2941","1842","action complete via Async Request","2026-03-03 16:43:35","2026-03-03 16:43:35"),
("2942","1844","action created","2026-03-03 16:43:35","2026-03-03 16:43:35"),
("2943","1843","action started via Async Request","2026-03-03 16:43:35","2026-03-03 16:43:35"),
("2944","1843","action complete via Async Request","2026-03-03 16:43:35","2026-03-03 16:43:35"),
("2945","1845","action created","2026-03-03 16:43:35","2026-03-03 16:43:35"),
("2946","1844","action started via Async Request","2026-03-03 16:44:45","2026-03-03 16:44:45"),
("2947","1844","action complete via Async Request","2026-03-03 16:44:45","2026-03-03 16:44:45"),
("2948","1846","action created","2026-03-03 16:44:45","2026-03-03 16:44:45"),
("2949","1845","action started via Async Request","2026-03-03 16:44:45","2026-03-03 16:44:45"),
("2950","1845","action complete via Async Request","2026-03-03 16:44:45","2026-03-03 16:44:45"),
("2951","1847","action created","2026-03-03 16:44:45","2026-03-03 16:44:45"),
("2952","1846","action started via Async Request","2026-03-03 16:45:54","2026-03-03 16:45:54"),
("2953","1846","action complete via Async Request","2026-03-03 16:45:54","2026-03-03 16:45:54"),
("2954","1848","action created","2026-03-03 16:45:54","2026-03-03 16:45:54"),
("2955","1847","action started via Async Request","2026-03-03 16:45:54","2026-03-03 16:45:54"),
("2956","1847","action complete via Async Request","2026-03-03 16:45:54","2026-03-03 16:45:54"),
("2957","1849","action created","2026-03-03 16:45:54","2026-03-03 16:45:54"),
("2958","1848","action started via Async Request","2026-03-03 16:47:09","2026-03-03 16:47:09"),
("2959","1848","action complete via Async Request","2026-03-03 16:47:09","2026-03-03 16:47:09"),
("2960","1850","action created","2026-03-03 16:47:09","2026-03-03 16:47:09"),
("2961","1849","action started via Async Request","2026-03-03 16:47:09","2026-03-03 16:47:09"),
("2962","1849","action complete via Async Request","2026-03-03 16:47:09","2026-03-03 16:47:09"),
("2963","1851","action created","2026-03-03 16:47:09","2026-03-03 16:47:09"),
("2964","1850","action started via Async Request","2026-03-03 16:48:09","2026-03-03 16:48:09"),
("2965","1850","action complete via Async Request","2026-03-03 16:48:09","2026-03-03 16:48:09"),
("2966","1852","action created","2026-03-03 16:48:09","2026-03-03 16:48:09"),
("2967","1851","action started via Async Request","2026-03-03 16:48:09","2026-03-03 16:48:09"),
("2968","1851","action complete via Async Request","2026-03-03 16:48:09","2026-03-03 16:48:09"),
("2969","1853","action created","2026-03-03 16:48:09","2026-03-03 16:48:09"),
("2970","1852","action started via Async Request","2026-03-03 16:49:15","2026-03-03 16:49:15"),
("2971","1852","action complete via Async Request","2026-03-03 16:49:15","2026-03-03 16:49:15"),
("2972","1854","action created","2026-03-03 16:49:15","2026-03-03 16:49:15"),
("2973","1853","action started via Async Request","2026-03-03 16:49:15","2026-03-03 16:49:15"),
("2974","1853","action complete via Async Request","2026-03-03 16:49:15","2026-03-03 16:49:15"),
("2975","1855","action created","2026-03-03 16:49:15","2026-03-03 16:49:15"),
("2976","1809","action canceled","2026-03-03 16:50:18","2026-03-03 16:50:18"),
("2977","1854","action canceled","2026-03-03 16:50:18","2026-03-03 16:50:18"),
("2978","1561","action canceled","2026-03-03 16:50:18","2026-03-03 16:50:18"),
("2979","1855","action canceled","2026-03-03 16:50:18","2026-03-03 16:50:18"),
("2980","1758","action canceled","2026-03-03 16:50:18","2026-03-03 16:50:18");

INSERT IGNORE INTO `nJQ2o_aiowps_audit_log` VALUES 
("282","1","1","triplea","81.43.69.125","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:496;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765877439",""),
("283","1","1","triplea","81.43.69.125","info","plugin_installed","{\"plugin\":{\"name\":\"RTMKit\",\"version\":\"1.6.8\",\"action\":\"installed\",\"network\":\"\"}}","a:24:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:245;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:98;s:8:\"function\";s:14:\"install_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1292;s:8:\"function\";s:19:\"install_requirement\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1125;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api.php\";s:4:\"line\";i:459;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:818;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/functions.php\";s:4:\"line\";i:1342;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765877526",""),
("284","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"RTMKit\",\"version\":\"1.6.8\",\"action\":\"activated\",\"network\":\"\"}}","a:24:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:289;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:277;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:98;s:8:\"function\";s:14:\"install_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1292;s:8:\"function\";s:19:\"install_requirement\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1125;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api.php\";s:4:\"line\";i:459;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:818;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/functions.php\";s:4:\"line\";i:1342;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765877526",""),
("285","1","1","triplea","81.43.69.125","info","plugin_installed","{\"plugin\":{\"name\":\"RTMForm Builder\",\"version\":\"1.2.4\",\"action\":\"installed\",\"network\":\"\"}}","a:24:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:245;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:98;s:8:\"function\";s:14:\"install_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1292;s:8:\"function\";s:19:\"install_requirement\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1125;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api.php\";s:4:\"line\";i:459;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:818;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/functions.php\";s:4:\"line\";i:1342;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765877529",""),
("286","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"RTMForm Builder\",\"version\":\"1.2.4\",\"action\":\"activated\",\"network\":\"\"}}","a:24:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:289;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:277;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:98;s:8:\"function\";s:14:\"install_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1292;s:8:\"function\";s:19:\"install_requirement\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1125;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api.php\";s:4:\"line\";i:459;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:818;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/functions.php\";s:4:\"line\";i:1342;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765877529",""),
("287","1","1","triplea","81.43.69.125","warning","user_deleted","{\"user_deleted\":{\"user_id\":2,\"reassign\":1,\"user_login\":\"vicente\"}}","a:9:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:524;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"user_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:56:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/user.php\";s:4:\"line\";i:463;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-admin/users.php\";s:4:\"line\";i:214;s:8:\"function\";s:14:\"wp_delete_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877564",""),
("288","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"PowerPack Lite for Elementor\",\"version\":\"2.9.6\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877883",""),
("289","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"6.3.1\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877898",""),
("290","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"ElementsKit Lite\",\"version\":\"3.7.2\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877906",""),
("291","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"25.9\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877923",""),
("292","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Complianz | GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.2\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877934",""),
("293","1","1","triplea","81.43.69.125","info","core_updated","{\"core_updated\":{\"old_version\":\"6.8.2\",\"new_version\":\"6.9\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:145;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/update-core.php\";s:4:\"line\";i:1603;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:71:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:178;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-admin/update-core.php\";s:4:\"line\";i:903;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-admin/update-core.php\";s:4:\"line\";i:1175;s:8:\"function\";s:15:\"do_core_upgrade\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765877950",""),
("294","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"All-In-One Security (AIOS)\",\"version\":\"5.4.4\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("295","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Complianz | GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.4.1\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("296","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Duplicate Page\",\"version\":\"4.5.6\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("297","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.33.4\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("298","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"ElementsKit Lite\",\"version\":\"3.7.7\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("299","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"6.5.4\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("300","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Login Designer\",\"version\":\"1.6.10\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("301","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Maintenance\",\"version\":\"4.19\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("302","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"PowerPack Lite for Elementor\",\"version\":\"2.9.8\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("303","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"PRO Elements\",\"version\":\"3.33.2\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("304","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"26.6\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878010",""),
("305","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"all-in-one-wp-security-and-firewall\",\"version\":\"5.4.4\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878015",""),
("306","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"complianz-gdpr\",\"version\":\"7.4.4.1\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878015",""),
("307","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.33.4\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878015",""),
("308","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"essential-addons-for-elementor-lite\",\"version\":\"6.5.4\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878015",""),
("309","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"26.6\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878015",""),
("310","1","1","triplea","81.43.69.125","info","theme_updated","{\"theme\":{\"name\":\"Hello Elementor\",\"version\":\"3.4.5\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:326;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:72:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:510;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:256;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878123",""),
("311","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"theme\",\"slug\":\"hello-elementor\",\"version\":\"3.4.5\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:72:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:510;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:256;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878124",""),
("312","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"ElementsKit Lite\",\"version\":\"3.7.7\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878639",""),
("313","1","1","triplea","81.43.69.125","warning","plugin_deleted","{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"6.5.4\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878646",""),
("314","1","1","triplea","81.43.69.125","warning","plugin_deleted","{\"plugin\":{\"name\":\"PowerPack Lite for Elementor\",\"version\":\"2.9.8\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765878650",""),
("315","1","1","triplea","81.43.69.125","info","plugin_installed","{\"plugin\":{\"name\":\"AI ChatBot - WPBot\",\"version\":\"7.5.7\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765879865",""),
("316","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"AI ChatBot - WPBot\",\"version\":\"7.5.7\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765879898",""),
("317","1","1","","213.229.190.25","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"26.6\"}}","a:20:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898177",""),
("318","1","1","admin","34.31.76.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898775",""),
("319","1","1","admin","34.31.76.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898776",""),
("320","1","1","admin","34.31.76.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898777","");

INSERT IGNORE INTO `nJQ2o_aiowps_audit_log` VALUES 
("321","1","1","admin","34.150.153.185","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765899670",""),
("322","1","1","admin","34.150.153.185","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765899671",""),
("323","1","1","admin","34.150.153.185","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765899671",""),
("324","1","1","","213.229.190.25","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.9\"}}","a:20:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466072",""),
("325","1","1","triplea","81.43.69.125","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1768466073",""),
("326","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"AI ChatBot - WPBot\",\"version\":\"7.6.9\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466116",""),
("327","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Complianz | GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.4.2\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466116",""),
("328","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.34.1\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466116",""),
("329","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"ElementsKit Lite\",\"version\":\"3.7.8\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466116",""),
("330","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Maintenance\",\"version\":\"4.20\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466116",""),
("331","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"26.7\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466116",""),
("332","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"complianz-gdpr\",\"version\":\"7.4.4.2\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466119",""),
("333","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.34.1\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466119",""),
("334","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"PRO Elements\",\"version\":\"3.34.0\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466226",""),
("335","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"AI ChatBot - WPBot\",\"version\":\"7.6.9\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466263",""),
("336","1","1","triplea","81.43.69.125","warning","plugin_deleted","{\"plugin\":{\"name\":\"AI ChatBot - WPBot\",\"version\":\"7.6.9\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466270",""),
("337","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"PRO Elements\",\"version\":\"3.34.0\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466281",""),
("338","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"RTMKit\",\"version\":\"1.6.8\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466315",""),
("339","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"RTMForm Builder\",\"version\":\"1.2.4\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466318",""),
("340","1","1","triplea","81.43.69.125","warning","plugin_deleted","{\"plugin\":{\"name\":\"RTMForm Builder\",\"version\":\"1.2.4\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466326",""),
("341","1","1","triplea","81.43.69.125","warning","plugin_deleted","{\"plugin\":{\"name\":\"RTMKit\",\"version\":\"1.6.8\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768466332",""),
("342","1","1","triplea","81.43.69.125","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1768498014",""),
("343","1","1","triplea","81.43.69.125","info","plugin_installed","{\"plugin\":{\"name\":\"Disable Admin Notices Individually\",\"version\":\"1.4.2\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768498175",""),
("344","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"disable-admin-notices\",\"version\":\"1.4.2\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768498177",""),
("345","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"Disable Admin Notices Individually\",\"version\":\"1.4.2\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768498182",""),
("346","1","1","admin","34.12.41.112","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768596864",""),
("347","1","1","admin","34.12.41.112","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768596865",""),
("348","1","1","admin","34.12.41.112","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768596866",""),
("349","1","1","admin","34.23.115.176","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768599736",""),
("350","1","1","admin","34.23.115.176","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768599737",""),
("351","1","1","admin","34.23.115.176","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768599738",""),
("352","1","1","admin","34.138.81.178","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768849722",""),
("353","1","1","admin","34.138.81.178","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768849722",""),
("354","1","1","admin","34.138.81.178","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768849723",""),
("355","1","1","admin","34.138.81.178","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768849723","");

INSERT IGNORE INTO `nJQ2o_aiowps_audit_log` VALUES 
("356","1","1","admin","35.229.42.123","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768851273",""),
("357","1","1","admin","35.229.42.123","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768851274",""),
("358","1","1","admin","35.229.42.123","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768851275",""),
("359","1","1","admin","130.211.54.205","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768926391",""),
("360","1","1","admin","130.211.54.205","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768926392",""),
("361","1","1","admin","130.211.54.205","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768926393",""),
("362","1","1","admin","35.190.182.226","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768928847",""),
("363","1","1","admin","35.190.182.226","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768928848",""),
("364","1","1","admin","35.190.182.226","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768928849",""),
("365","1","1","admin","34.23.156.98","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768984472",""),
("366","1","1","admin","34.23.156.98","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768984473",""),
("367","1","1","admin","34.23.156.98","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1768984474",""),
("368","1","1","admin","8.228.17.109","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769015193",""),
("369","1","1","admin","8.228.17.109","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769015193",""),
("370","1","1","admin","8.228.17.109","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769015194",""),
("371","1","1","admin","8.228.17.109","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769015194",""),
("372","1","1","admin","34.125.176.156","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769016404",""),
("373","1","1","admin","34.125.176.156","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769016406",""),
("374","1","1","admin","34.125.176.156","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769016407",""),
("375","1","1","admin","34.83.224.222","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769522778",""),
("376","1","1","admin","34.83.224.222","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769522780",""),
("377","1","1","admin","34.83.224.222","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769522781",""),
("378","1","1","admin","34.169.18.253","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769523475",""),
("379","1","1","admin","34.169.18.253","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769523476",""),
("380","1","1","admin","34.169.18.253","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769523477",""),
("381","1","1","admin","35.239.227.27","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769534969",""),
("382","1","1","admin","35.239.227.27","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769534970",""),
("383","1","1","admin","35.239.227.27","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769534971","");

INSERT IGNORE INTO `nJQ2o_aiowps_audit_log` VALUES 
("384","1","1","admin","136.112.244.23","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769700187",""),
("385","1","1","admin","136.112.244.23","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769700188",""),
("386","1","1","admin","35.188.5.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769700188",""),
("387","1","1","admin","35.188.5.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769700189",""),
("388","1","1","admin","136.112.244.23","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769700189",""),
("389","1","1","admin","35.188.5.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769700189",""),
("390","1","1","","213.229.190.25","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.9\"}}","a:20:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1769805311",""),
("391","1","1","triplea","81.43.69.125","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1770378348",""),
("392","1","1","triplea","81.43.69.125","info","core_updated","{\"core_updated\":{\"old_version\":\"6.9\",\"new_version\":\"6.9.1\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:145;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/update-core.php\";s:4:\"line\";i:1604;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:71:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:178;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-admin/update-core.php\";s:4:\"line\";i:903;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-admin/update-core.php\";s:4:\"line\";i:1175;s:8:\"function\";s:15:\"do_core_upgrade\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378401",""),
("393","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"All-In-One Security (AIOS)\",\"version\":\"5.4.6\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378441",""),
("394","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.35.3\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378441",""),
("395","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"ElementsKit Lite\",\"version\":\"3.7.9\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378441",""),
("396","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"26.9\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378441",""),
("397","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"all-in-one-wp-security-and-firewall\",\"version\":\"5.4.6\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378444",""),
("398","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"26.9\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770378444",""),
("399","1","1","admin","34.60.3.73","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770738960",""),
("400","1","1","admin","34.60.3.73","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770738961",""),
("401","1","1","admin","34.60.3.73","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770738962",""),
("402","1","1","admin","34.60.3.73","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770738962",""),
("403","1","1","admin","35.232.29.56","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770749607",""),
("404","1","1","admin","35.232.29.56","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770749608",""),
("405","1","1","admin","35.232.29.56","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770749609",""),
("406","1","1","admin","136.112.13.124","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770827128",""),
("407","1","1","admin","136.112.13.124","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770827128",""),
("408","1","1","admin","136.112.13.124","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770827129",""),
("409","1","1","admin","136.112.13.124","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770827129",""),
("410","1","1","admin","34.31.28.189","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770839196",""),
("411","1","1","admin","34.31.28.189","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770839197",""),
("412","1","1","admin","34.31.28.189","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770839198",""),
("413","1","1","triplea","212.166.220.47","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:514;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1771409500","");

INSERT IGNORE INTO `nJQ2o_aiowps_audit_log` VALUES 
("414","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Disable Admin Notices Individually\",\"version\":\"1.4.3\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771417007",""),
("415","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.35.5\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771417007",""),
("416","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"PRO Elements\",\"version\":\"3.35.0\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771417007",""),
("417","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"27.0\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771417007",""),
("418","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"PRO Elements\",\"version\":\"3.35.0\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771417030",""),
("419","1","1","triplea","81.43.69.125","info","theme_updated","{\"theme\":{\"name\":\"Hello Elementor\",\"version\":\"3.4.6\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:326;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:72:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:510;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:256;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771417049",""),
("420","1","1","triplea","81.43.69.125","info","plugin_installed","{\"plugin\":{\"name\":\"Themesflat Addons For Elementor\",\"version\":\"2.3.2\",\"action\":\"installed\",\"network\":\"\"}}","a:24:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:245;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:98;s:8:\"function\";s:14:\"install_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1292;s:8:\"function\";s:19:\"install_requirement\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1125;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api.php\";s:4:\"line\";i:467;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:821;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/functions.php\";s:4:\"line\";i:1343;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1771417959",""),
("421","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"Themesflat Addons For Elementor\",\"version\":\"2.3.2\",\"action\":\"activated\",\"network\":\"\"}}","a:24:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:289;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:277;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:99:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/template-kit-import/inc/api/class-requirements.php\";s:4:\"line\";i:98;s:8:\"function\";s:14:\"install_plugin\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1292;s:8:\"function\";s:19:\"install_requirement\";s:5:\"class\";s:36:\"Template_Kit_Import\\API\\Requirements\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1125;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:75:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/rest-api.php\";s:4:\"line\";i:467;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:54:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp.php\";s:4:\"line\";i:821;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/functions.php\";s:4:\"line\";i:1343;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1771417959",""),
("422","1","1","admin","34.31.113.99","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771781625",""),
("423","1","1","admin","34.31.113.99","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771781626",""),
("424","1","1","admin","34.31.113.99","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771781628",""),
("425","1","1","admin","34.42.103.7","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771782431",""),
("426","1","1","admin","34.42.103.7","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771782432",""),
("427","1","1","admin","34.42.103.7","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771782433",""),
("428","1","1","","213.229.190.25","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.9.1\"}}","a:20:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771831140",""),
("429","1","1","triplea","81.43.69.125","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:514;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1771841440",""),
("430","1","1","admin","136.119.205.252","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771865755",""),
("431","1","1","admin","136.119.205.252","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771865755",""),
("432","1","1","admin","136.119.205.252","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771865756",""),
("433","1","1","admin","136.119.205.252","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771865756",""),
("434","1","1","admin","34.66.132.36","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771866084",""),
("435","1","1","admin","34.66.132.36","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771866085",""),
("436","1","1","admin","34.66.132.36","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1771866086",""),
("437","1","1","admin","35.188.4.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772107086",""),
("438","1","1","admin","35.188.4.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772107087",""),
("439","1","1","admin","35.188.4.32","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772107088",""),
("440","1","1","admin","136.118.138.181","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772110893",""),
("441","1","1","admin","136.118.138.181","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772110894",""),
("442","1","1","admin","136.118.138.181","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772110896",""),
("443","1","1","triplea","81.43.69.125","info","successful_login","{\"successful_login\":{\"username\":\"triplea\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:135:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:136:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:124:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:105:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:514;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:45:\"/home/berdejo/grupoberdejo.es/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:43:\"/home/berdejo/grupoberdejo.es/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:41:\"/home/berdejo/grupoberdejo.es/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:39:\"/home/berdejo/grupoberdejo.es/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:48:\"/home/berdejo/grupoberdejo.es/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1772455644","");

INSERT IGNORE INTO `nJQ2o_aiowps_audit_log` VALUES 
("444","1","1","triplea","81.43.69.125","info","plugin_installed","{\"plugin\":{\"name\":\"Forminator\",\"version\":\"1.51.1\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772455670",""),
("445","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"forminator\",\"version\":\"1.51.1\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:69:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:64:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:53:\"/home/berdejo/grupoberdejo.es/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772455672",""),
("446","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"Forminator\",\"version\":\"1.51.1\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772455682",""),
("447","1","1","","213.229.190.25","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"complianz-gdpr\",\"version\":\"7.4.4.2\"}}","a:20:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772506437",""),
("448","1","1","","213.229.190.25","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.35.5\"}}","a:20:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:78:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:41:\"/home/berdejo/grupoberdejo.es/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772548694",""),
("449","1","1","triplea","81.43.69.125","info","plugin_activated","{\"plugin\":{\"name\":\"Complianz | GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.4.2\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772556596",""),
("450","1","1","triplea","81.43.69.125","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Forminator\",\"version\":\"1.51.1\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772556618",""),
("451","1","1","triplea","81.43.69.125","warning","plugin_deleted","{\"plugin\":{\"name\":\"Forminator\",\"version\":\"1.51.1\",\"action\":\"deleted\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/berdejo/grupoberdejo.es/wp-admin/plugins.php\";s:4:\"line\";i:430;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772556626",""),
("452","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.35.6\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772557090",""),
("453","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"ElementsKit Lite\",\"version\":\"3.8.1\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772557090",""),
("454","1","1","triplea","81.43.69.125","info","plugin_updated","{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"27.1.1\",\"action\":\"updated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772557090",""),
("455","1","1","triplea","81.43.69.125","info","translation_updated","{\"translation_updated\":{\"language\":\"es_ES\",\"type\":\"plugin\",\"slug\":\"elementskit-lite\",\"version\":\"3.8.1\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:80:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:73:\"/home/berdejo/grupoberdejo.es/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/berdejo/grupoberdejo.es/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772557092",""),
("456","1","1","admin","34.19.16.15","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772610123",""),
("457","1","1","admin","34.19.16.15","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772610125",""),
("458","1","1","admin","34.19.16.15","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"admin\",\"known\":false}}","a:19:{i:0;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:121:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:119:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:59:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:52:\"/home/berdejo/grupoberdejo.es/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:55:\"/home/berdejo/grupoberdejo.es/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:301;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4852;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:717;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:66:\"/home/berdejo/grupoberdejo.es/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:68:\"/home/berdejo/grupoberdejo.es/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/berdejo/grupoberdejo.es/xmlrpc.php\";s:4:\"line\";i:85;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1772610126","");

INSERT IGNORE INTO `nJQ2o_aiowps_logged_in_users` VALUES 
("12","1","triplea","81.43.69.125","1","1772455644","1772628444");

INSERT IGNORE INTO `nJQ2o_aiowps_login_lockdown` VALUES 
("34","0","admin","2025-12-16 15:26:17","1765898777","2025-12-16 16:26:17","1765902377","34.31.76.32","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("35","0","admin","2025-12-16 15:41:11","1765899672","2025-12-16 16:41:11","1765903272","34.150.153.185","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("36","0","admin","2026-01-16 20:54:26","1768596866","2026-01-16 21:54:26","1768600466","34.12.41.112","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("37","0","admin","2026-01-16 21:42:18","1768599740","2026-01-16 22:42:18","1768603340","34.23.115.176","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-east1)\",\"as\":\"AS396982 Google LLC\"}"),
("38","0","admin","2026-01-19 19:08:43","1768849723","2026-01-19 20:08:43","1768853323","34.138.81.178","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("39","0","admin","2026-01-19 19:08:43","1768849723","2026-01-19 20:08:43","1768853323","34.138.81.178","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("40","0","admin","2026-01-19 19:34:35","1768851275","2026-01-19 20:34:35","1768854875","35.229.42.123","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("41","0","admin","2026-01-20 16:26:33","1768926393","2026-01-20 17:26:33","1768929993","130.211.54.205","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (europe-west1)\",\"as\":\"AS396982 Google LLC\"}"),
("42","0","admin","2026-01-20 17:07:29","1768928849","2026-01-20 18:07:29","1768932449","35.190.182.226","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("43","0","admin","2026-01-21 08:34:34","1768984474","2026-01-21 09:34:34","1768988074","34.23.156.98","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("44","0","admin","2026-01-21 17:06:34","1769015194","2026-01-21 18:06:34","1769018794","8.228.17.109","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-west4)\",\"as\":\"AS396982 Google LLC\"}"),
("45","0","admin","2026-01-21 17:06:34","1769015195","2026-01-21 18:06:34","1769018795","8.228.17.109","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("46","0","admin","2026-01-21 17:26:47","1769016407","2026-01-21 18:26:47","1769020007","34.125.176.156","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("47","0","admin","2026-01-27 14:06:21","1769522781","2026-01-27 15:06:21","1769526381","34.83.224.222","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("48","0","admin","2026-01-27 14:17:57","1769523477","2026-01-27 15:17:57","1769527077","34.169.18.253","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("49","0","admin","2026-01-27 17:29:31","1769534972","2026-01-27 18:29:31","1769538572","35.239.227.27","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("50","0","admin","2026-01-29 15:23:09","1769700189","2026-01-29 16:23:09","1769703789","136.112.244.23","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("51","0","admin","2026-01-29 15:23:09","1769700190","2026-01-29 16:23:09","1769703790","35.188.5.32","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("52","0","admin","2026-02-10 15:56:02","1770738962","2026-02-10 16:56:02","1770742562","34.60.3.73","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("53","0","admin","2026-02-10 15:56:02","1770738962","2026-02-10 16:56:02","1770742562","34.60.3.73","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("54","0","admin","2026-02-10 18:53:29","1770749609","2026-02-10 19:53:29","1770753209","35.232.29.56","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("55","0","admin","2026-02-11 16:25:29","1770827129","2026-02-11 17:25:29","1770830729","136.112.13.124","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("56","0","admin","2026-02-11 16:25:29","1770827130","2026-02-11 17:25:29","1770830730","136.112.13.124","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("57","0","admin","2026-02-11 19:46:38","1770839198","2026-02-11 20:46:38","1770842798","34.31.28.189","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("58","0","admin","2026-02-22 17:33:48","1771781628","2026-02-22 18:33:48","1771785228","34.31.113.99","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("59","0","admin","2026-02-22 17:47:13","1771782433","2026-02-22 18:47:13","1771786033","34.42.103.7","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("60","0","admin","2026-02-23 16:55:56","1771865756","2026-02-23 17:55:56","1771869356","136.119.205.252","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("61","0","admin","2026-02-23 16:55:56","1771865756","2026-02-23 17:55:56","1771869356","136.119.205.252","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("62","0","admin","2026-02-23 17:01:26","1771866086","2026-02-23 18:01:26","1771869686","34.66.132.36","too_many_failed_logins","","-1","","{\"org\":\"Google Cloud (us-central1)\",\"as\":\"AS396982 Google LLC\"}"),
("63","0","admin","2026-02-26 11:58:08","1772107088","2026-02-26 12:58:08","1772110688","35.188.4.32","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("64","0","admin","2026-02-26 13:01:36","1772110896","2026-02-26 14:01:36","1772114496","136.118.138.181","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}"),
("65","0","admin","2026-03-04 07:42:06","1772610126","2026-03-04 08:42:06","1772613726","34.19.16.15","too_many_failed_logins","","-1","","{\"org\":\"AS396982 Google LLC\",\"as\":\"AS396982 Google LLC\"}");

INSERT IGNORE INTO `nJQ2o_cmplz_cookiebanners` VALUES 
("1","Banner A","37","1","bottom-right","slider","","0","1","Gestionar consentimiento","hover-hide-mobile","a:2:{s:4:\"text\";s:24:\"Gestionar consentimiento\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:7:\"Denegar\";s:4:\"show\";i:1;}","Guardar preferencias","Ver preferencias","Funcional","a:2:{s:4:\"text\";s:9:\"Marketing\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:13:\"Estadísticas\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:12:\"Preferencias\";s:4:\"show\";i:1;}","Aceptar","Para ofrecer las mejores experiencias, utilizamos tecnologías como las cookies para almacenar y/o acceder a la información del dispositivo. El consentimiento de estas tecnologías nos permitirá procesar datos como el comportamiento de navegación o las identificaciones únicas en este sitio. No consentir o retirar el consentimiento, puede afectar negativamente a ciertas características y funciones.","view-preferences","0","526","0","0","0","10","a:2:{s:4:\"text\";s:7:\"Aceptar\";s:4:\"show\";i:1;}","Para ofrecer las mejores experiencias, utilizamos tecnologías como las cookies para almacenar y/o acceder a la información del dispositivo. El consentimiento de estas tecnologías nos permitirá procesar datos como el comportamiento de navegación o las identificaciones únicas en este sitio. No consentir o retirar el consentimiento, puede afectar negativamente a ciertas características y funciones.","0","/* Container */\n.cmplz-cookiebanner{}\n\n/* Logo */\n.cmplz-cookiebanner .cmplz-logo{}\n/* Title */\n.cmplz-cookiebanner .cmplz-title{}\n/* Close icon */\n.cmplz-cookiebanner .cmplz-close{}\n\n/* Message */\n.cmplz-cookiebanner .cmplz-message{}\n\n /* All buttons */\n.cmplz-buttons .cmplz-btn{}\n/* Accept button */\n.cmplz-btn .cmplz-accept{} \n /* Deny button */\n.cmplz-btn .cmplz-deny{}\n /* Save preferences button */\n.cmplz-btn .cmplz-deny{}\n /* View preferences button */\n.cmplz-btn .cmplz-deny{}\n\n /* Document hyperlinks */\n.cmplz-links .cmplz-documents{}\n\n /* Categories */\n.cmplz-cookiebanner .cmplz-category{}\n.cmplz-cookiebanner .cmplz-category-title{} \n\n/* Manage consent tab */\n#cmplz-manage-consent .cmplz-manage-consent{} \n\n/* Soft cookie wall */\n.cmplz-soft-cookiewall{}\n\n/* Placeholder button - Per category */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice{}\n\n/* Placeholder button & message - Per service */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice,\n.cmplz-blocked-content-notice{}\nbutton.cmplz-accept-service{}\n\n/* Styles for the AMP notice */\n#cmplz-consent-ui, #cmplz-post-consent-ui {}\n/* Message */\n#cmplz-consent-ui .cmplz-consent-message {}\n/* Buttons */\n#cmplz-consent-ui button, #cmplz-post-consent-ui button {}","a:0:{}","a:2:{s:4:\"text\";s:325:\"El almacenamiento o acceso técnico es estrictamente necesario para el propósito legítimo de permitir el uso de un servicio específico explícitamente solicitado por el abonado o usuario, o con el único propósito de llevar a cabo la transmisión de una comunicación a través de una red de comunicaciones electrónicas.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:92:\"El almacenamiento o acceso técnico que es utilizado exclusivamente con fines estadísticos.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:352:\"El almacenamiento o acceso técnico que se utiliza exclusivamente con fines estadísticos anónimos. Sin un requerimiento, el cumplimiento voluntario por parte de tu proveedor de servicios de Internet, o los registros adicionales de un tercero, la información almacenada o recuperada sólo para este propósito no se puede utilizar para identificarte.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:143:\"El almacenamiento o acceso técnico es necesario para la finalidad legítima de almacenar preferencias no solicitadas por el abonado o usuario.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:191:\"El almacenamiento o acceso técnico es necesario para crear perfiles de usuario para enviar publicidad, o para rastrear al usuario en una web o en varias web con fines de marketing similares.\";s:4:\"show\";i:1;}","a:2:{s:5:\"color\";s:7:\"#ffffff\";s:6:\"border\";s:7:\"#f2f2f2\";}","a:2:{s:5:\"color\";s:7:\"#222222\";s:9:\"hyperlink\";s:7:\"#3b5398\";}","a:3:{s:10:\"background\";s:7:\"#1e73be\";s:6:\"bullet\";s:7:\"#ffffff\";s:8:\"inactive\";s:7:\"#F56E28\";}","a:5:{s:3:\"top\";i:12;s:5:\"right\";i:12;s:6:\"bottom\";i:12;s:4:\"left\";i:12;s:4:\"type\";s:2:\"px\";}","a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}","12","a:3:{s:10:\"background\";s:7:\"#f9be17\";s:6:\"border\";s:7:\"#f9be17\";s:4:\"text\";s:7:\"#ffffff\";}","a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#222222\";}","a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#333333\";}","a:5:{s:3:\"top\";i:6;s:5:\"right\";i:6;s:6:\"bottom\";i:6;s:4:\"left\";i:6;s:4:\"type\";s:2:\"px\";}","none","1","0","0","0","1");

INSERT IGNORE INTO `nJQ2o_cmplz_cookies` VALUES 
("1","e_globals","e_globals","1","1","session","localstorage","1","provide functions across pages","none","Functional","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("2","e_globals","e_globals","1","1","sesión","","2","proporcionar funcionalidad entre páginas","nada","Funcional","es","1","0","self","0","0","1","1756373987","1772556664","1756372022"),
("3","e_kit-elements-defaults","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1772556664","1756372022"),
("4","e_kit-elements-defaults","","1","0","","","0","","","","es","3","0","self","0","0","1","0","1772556664","1756372022"),
("5","elementor","elementor","1","0","persistent","localstorage","1","store performed actions on the website","anonymous ID","Statistics (anonymous)","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("6","elementor","elementor","1","0","persistente","","2","guardar acciones hechas por usuarios en el sitio web","ID anónima","Estadísticas (anónimas)","es","5","0","self","0","0","1","1756373987","1772556664","1756372022"),
("7","wp-autosave-*","wp-autosave","1","1","persistent","","3","store performed actions on the website","","Functional","en","0","0","self","0","0","1","1756373987","1756372022","1756372022"),
("8","wp-autosave-*","wp-autosave","1","1","persistente","","4","guardar acciones hechas por usuarios en el sitio web","","Funcional","es","7","0","self","0","0","1","1756373987","1756372022","1756372022"),
("9","wpEmojiSettingsSupports","wpemojisettingssupports","1","0","session","localstorage","3","store browser details","none","Functional","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("10","wpEmojiSettingsSupports","wpemojisettingssupports","1","0","sesión","","4","guardar detalles del navegador","nada","Funcional","es","9","0","self","0","0","1","1756373987","1772556664","1756372022"),
("11","wordpress_test_cookie","wordpress_test_cookie","1","0","session","cookie","3","read if cookies can be placed","","Functional","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("12","wordpress_test_cookie","wordpress_test_cookie","1","0","sesión","","4","chequear si se pueden instalar cookies","","Funcional","es","11","0","self","0","0","1","1756373987","1772556664","1756372022"),
("13","wp-settings-*","wp-settings","1","0","persistent","cookie","3","store user preferences","","Functional","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("14","wp-settings-*","wp-settings","1","0","persistente","","4","guardar las preferencias de los usuarios","","Funcional","es","13","0","self","0","0","1","1756373987","1772556664","1756372022"),
("15","wp-settings-time-*","wp-settings-time","1","0","1 year","cookie","3","store user preferences","","Functional","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("16","wp-settings-time-*","wp-settings-time","1","0","1 año","","4","guardar las preferencias de los usuarios","","Funcional","es","15","0","self","0","0","1","1756373987","1772556664","1756372022"),
("17","wordpress_logged_in_*","wordpress_logged_in_","1","0","persistent","cookie","3","Store logged in users","","Functional","en","0","0","self","0","0","1","1756373987","1772556664","1756372022"),
("18","wordpress_logged_in_*","wordpress_logged_in_","1","0","persistente","","4","mantener los usuarios logeados","","Funcional","es","17","0","self","0","0","1","1756373987","1772556664","1756372022"),
("19","chatbotParams-9","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("20","chatbotParams-9","","1","0","","","0","","","","es","19","0","self","0","0","1","0","1756373932","1756373029"),
("21","chatbotParams-0","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("22","chatbotParams-0","","1","0","","","0","","","","es","21","0","self","0","0","1","0","1756373932","1756373029"),
("23","environmentCategories-4","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("24","environmentCategories-4","","1","0","","","0","","","","es","23","0","self","0","0","1","0","1756373932","1756373029"),
("25","mwai-admin-chatbotKey","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("26","mwai-admin-chatbotKey","","1","0","","","0","","","","es","25","0","self","0","0","1","0","1756373932","1756373029"),
("27","mtnc_upsell_shown","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1772556664","1756373029"),
("28","mtnc_upsell_shown","","1","0","","","0","","","","es","27","0","self","0","0","1","0","1772556664","1756373029"),
("29","chatbotParams-6","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("30","chatbotParams-6","","1","0","","","0","","","","es","29","0","self","0","0","1","0","1756373932","1756373029"),
("31","e_my_templates_source","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1758102477","1756373029"),
("32","e_my_templates_source","","1","0","","","0","","","","es","31","0","self","0","0","1","0","1758102477","1756373029"),
("33","e_site-editor","e_site-editor","1","1","session","Local Storage","1","provide admin functions","none","Functional","en","0","0","self","0","0","1","1756373987","1756373932","1756373029"),
("34","e_site-editor","e_site-editor","1","1","sesión","","2","provide admin functions","nada","Funcional","es","33","0","self","0","0","1","1756373987","1756373932","1756373029"),
("35","_grecaptcha","_grecaptcha","1","0","6 months","Cookie","5","provide spam protection","browsing device information","Functional","en","0","0","self","0","0","1","1756373987","1756373932","1756373029"),
("36","_grecaptcha","_grecaptcha","1","0","6 meses","","6","proporcionar protección contra correo no deseado","información del dispositivo navegador","Funcional","es","35","0","self","0","0","1","1756373987","1756373932","1756373029"),
("37","e_event-tracker","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("38","e_event-tracker","","1","0","","","0","","","","es","37","0","self","0","0","1","0","1756373932","1756373029"),
("39","chatbotParams-10","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("40","chatbotParams-10","","1","0","","","0","","","","es","39","0","self","0","0","1","0","1756373932","1756373029"),
("41","WP_PREFERENCES_USER_*","wp_preferences_user_","1","0","persistent","Local Storage","3","store user preferences","none","Functional","en","0","0","self","0","0","1","1756373987","1756373932","1756373029"),
("42","WP_PREFERENCES_USER_*","wp_preferences_user_","1","0","persistente","","4","guardar las preferencias de los usuarios","nada","Funcional","es","41","0","self","0","1","1","1756373987","1756373932","1756373029"),
("43","chatbotParams-11","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("44","chatbotParams-11","","1","0","","","0","","","","es","43","0","self","0","0","1","0","1756373932","1756373029"),
("45","environmentCategories","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("46","environmentCategories","","1","0","","","0","","","","es","45","0","self","0","0","1","0","1756373932","1756373029"),
("47","chatbotParams-14","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("48","chatbotParams-14","","1","0","","","0","","","","es","47","0","self","0","0","1","0","1756373932","1756373029"),
("49","mtnc_upsell_shown_timestamp","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1772556664","1756373029"),
("50","mtnc_upsell_shown_timestamp","","1","0","","","0","","","","es","49","0","self","0","0","1","0","1772556664","1756373029"),
("51","chatbotParams-7","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("52","chatbotParams-7","","1","0","","","0","","","","es","51","0","self","0","0","1","0","1756373932","1756373029"),
("53","mwai-chat-default","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373029"),
("54","mwai-chat-default","","1","0","","","0","","","","es","53","0","self","0","0","1","0","1756373932","1756373029"),
("55","chatbotParams","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("56","chatbotParams","","1","0","","","0","","","","es","55","0","self","0","0","1","0","1756373932","1756373030"),
("57","environmentCategories-3","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("58","environmentCategories-3","","1","0","","","0","","","","es","57","0","self","0","0","1","0","1756373932","1756373030"),
("59","mwai_settings_section","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("60","mwai_settings_section","","1","0","","","0","","","","es","59","0","self","0","0","1","0","1756373932","1756373030"),
("61","chatbotParams-3","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("62","chatbotParams-3","","1","0","","","0","","","","es","61","0","self","0","0","1","0","1756373932","1756373030"),
("63","chatbotParams-8","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("64","chatbotParams-8","","1","0","","","0","","","","es","63","0","self","0","0","1","0","1756373932","1756373030"),
("65","chatbotParams-1","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("66","chatbotParams-1","","1","0","","","0","","","","es","65","0","self","0","0","1","0","1756373932","1756373030"),
("67","mwai-chat-chatbot-1obxks","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("68","mwai-chat-chatbot-1obxks","","1","0","","","0","","","","es","67","0","self","0","0","1","0","1756373932","1756373030"),
("69","chatbotParams-13","","1","0","","localstorage","0","","","","en","0","0","self","0","0","1","0","1756373932","1756373030"),
("70","chatbotParams-13","","1","0","","","0","","","","es","69","0","self","0","0","1","0","1756373932","1756373030"),
("71","cmplz_functional","","1","0","365 días","","0","","","","en","0","0","thirdparty","0","0","1","0","0","1756373998"),
("72","cmplz_statistics","","1","0","365 días","","0","","","","en","0","0","thirdparty","0","0","1","0","0","1756373998"),
("73","cmplz_preferences","","1","0","365 días","","0","","","","en","0","0","thirdparty","0","0","1","0","0","1756373998"),
("74","cmplz_marketing","","1","0","365 días","","0","","","","en","0","0","thirdparty","0","0","1","0","0","1756373998"),
("75","cmplz_functional","","1","0","365 días","","0","","","","es","71","0","thirdparty","0","0","1","0","1758102470","1758102470"),
("76","cmplz_statistics","","1","0","365 días","","0","","","","es","72","0","thirdparty","0","0","1","0","1758102470","1758102470"),
("77","cmplz_preferences","","1","0","365 días","","0","","","","es","73","0","thirdparty","0","0","1","0","1758102470","1758102470"),
("78","cmplz_marketing","","1","0","365 días","","0","","","","es","74","0","thirdparty","0","0","1","0","1758102470","1758102470");

INSERT IGNORE INTO `nJQ2o_cmplz_services` VALUES 
("1","Elementor","","","","0","0","0","","en","0","1","0"),
("2","Elementor","","","","0","0","0","","es","1","1","0"),
("3","WordPress","","","","0","0","0","","en","0","1","0"),
("4","WordPress","","","","0","0","0","","es","3","1","0"),
("5","Google reCAPTCHA","","","","0","0","0","","en","0","1","0"),
("6","Google reCAPTCHA","","","utility","0","0","0","","es","5","1","0"),
("7","Google Fonts","","","utility","0","0","0","","en","0","1","0"),
("8","Google Fonts","","","utility","0","0","0","","es","7","1","0"),
("9","Google Maps","","","utility","0","0","0","","en","0","1","0"),
("10","Google Maps","","","utility","0","0","0","","es","9","1","0");

INSERT IGNORE INTO `nJQ2o_duplicator_backups` VALUES 
("7","20260304_grupofamiliarberdejoafamily","4eaa492779be432a5419_20260304101516","20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516_archive.zip","20","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 7,\n    \"VersionWP\": \"6.9.1\",\n    \"VersionDB\": \"10.11.16\",\n    \"VersionPHP\": \"8.4.18\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20260304_grupofamiliarberdejoafamily\",\n    \"Hash\": \"4eaa492779be432a5419_20260304101516\",\n    \"NameHash\": \"20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/grupoberdejo.es\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516_scan.json\",\n    \"timer_start\": 1772619339.232513904571533203125,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/.opcache\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/.tmb\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/bps-backup\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/cache\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/old-cache\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/updraft\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/wfcache\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/.htaccess\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/.user.ini\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/php.ini\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/web.config\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-config.php\",\n            \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/berdejo\\/grupoberdejo.es\",\n        \"Size\": 297674485,\n        \"Dirs\": [],\n        \"DirCount\": 2898,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 16052,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"iD5ZGvofrT6EswEWKhuKGRQM8+LEGdiOcvxqmG3DAQmDruqA0qN0R+37KiJS+crZC3WXynFxIx5XTCAHLCqBXg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"berdejo_grupo\",\n            \"tablesBaseCount\": 53,\n            \"tablesFinalCount\": 53,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 4115,\n            \"tablesSizeOnDisk\": 29884416,\n            \"tablesList\": {\n                \"nJQ2o_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"nJQ2o_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"151\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_aiowps_audit_log\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 0,\n                    \"size\": 606208\n                },\n                \"nJQ2o_aiowps_debug_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_aiowps_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_aiowps_global_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_aiowps_logged_in_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"nJQ2o_aiowps_login_lockdown\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"nJQ2o_aiowps_message_store\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_aiowps_permanent_block\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_cmplz_cookiebanners\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_cmplz_cookies\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_cmplz_dnsmpd\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_cmplz_services\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"nJQ2o_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"nJQ2o_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"nJQ2o_e_events\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"nJQ2o_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"nJQ2o_e_submissions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"nJQ2o_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"nJQ2o_e_submissions_values\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_frmt_form_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"nJQ2o_frmt_form_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"nJQ2o_frmt_form_reports\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_frmt_form_views\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"nJQ2o_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_mwai_filemeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_mwai_files\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_options\": {\n                    \"inaccurateRows\": \"687\",\n                    \"insertedRows\": 0,\n                    \"size\": 1310720\n                },\n                \"nJQ2o_postmeta\": {\n                    \"inaccurateRows\": \"2356\",\n                    \"insertedRows\": 0,\n                    \"size\": 19218432\n                },\n                \"nJQ2o_posts\": {\n                    \"inaccurateRows\": \"366\",\n                    \"insertedRows\": 0,\n                    \"size\": 5636096\n                },\n                \"nJQ2o_post_smtp_logmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_post_smtp_logs\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"nJQ2o_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_terms\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_term_relationships\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_term_taxonomy\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_usermeta\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"nJQ2o_wpbot_chat_report\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_wpbot_response\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"nJQ2o_wpbot_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_wpwbot_index\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"nJQ2o_yoast_indexable\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"nJQ2o_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"nJQ2o_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"nJQ2o_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"nJQ2o_yoast_seo_links\": {\n                    \"inaccurateRows\": \"81\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.16\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\\/home\\/berdejo\\/grupoberdejo.es\\/wp-content\\/backups-dup-pro\\/tmp\\/20260304_grupofamiliarberdejoafamily_4eaa492779be432a5419_20260304101516_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1772619341,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"nJQ2o_users\",\n            \"nJQ2o_usermeta\",\n            \"nJQ2o_actionscheduler_actions\",\n            \"nJQ2o_actionscheduler_claims\",\n            \"nJQ2o_actionscheduler_groups\",\n            \"nJQ2o_actionscheduler_logs\",\n            \"nJQ2o_aiowps_audit_log\",\n            \"nJQ2o_aiowps_debug_log\",\n            \"nJQ2o_aiowps_events\",\n            \"nJQ2o_aiowps_global_meta\",\n            \"nJQ2o_aiowps_logged_in_users\",\n            \"nJQ2o_aiowps_login_lockdown\",\n            \"nJQ2o_aiowps_message_store\",\n            \"nJQ2o_aiowps_permanent_block\",\n            \"nJQ2o_cmplz_cookiebanners\",\n            \"nJQ2o_cmplz_cookies\",\n            \"nJQ2o_cmplz_dnsmpd\",\n            \"nJQ2o_cmplz_services\",\n            \"nJQ2o_commentmeta\",\n            \"nJQ2o_comments\",\n            \"nJQ2o_duplicator_backups\",\n            \"nJQ2o_duplicator_entities\",\n            \"nJQ2o_e_events\",\n            \"nJQ2o_e_notes\",\n            \"nJQ2o_e_notes_users_relations\",\n            \"nJQ2o_e_submissions\",\n            \"nJQ2o_e_submissions_actions_log\",\n            \"nJQ2o_e_submissions_values\",\n            \"nJQ2o_frmt_form_entry\",\n            \"nJQ2o_frmt_form_entry_meta\",\n            \"nJQ2o_frmt_form_reports\",\n            \"nJQ2o_frmt_form_views\",\n            \"nJQ2o_links\",\n            \"nJQ2o_mwai_filemeta\",\n            \"nJQ2o_mwai_files\",\n            \"nJQ2o_options\",\n            \"nJQ2o_postmeta\",\n            \"nJQ2o_posts\",\n            \"nJQ2o_post_smtp_logmeta\",\n            \"nJQ2o_post_smtp_logs\",\n            \"nJQ2o_termmeta\",\n            \"nJQ2o_terms\",\n            \"nJQ2o_term_relationships\",\n            \"nJQ2o_term_taxonomy\",\n            \"nJQ2o_wpbot_chat_report\",\n            \"nJQ2o_wpbot_response\",\n            \"nJQ2o_wpbot_sessions\",\n            \"nJQ2o_wpwbot_index\",\n            \"nJQ2o_yoast_indexable\",\n            \"nJQ2o_yoast_indexable_hierarchy\",\n            \"nJQ2o_yoast_migrations\",\n            \"nJQ2o_yoast_primary_term\",\n            \"nJQ2o_yoast_seo_links\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1772619339.2468750476837158203125,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 4116,\n            \"tables\": {\n                \"nJQ2o_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_audit_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_debug_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_global_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_logged_in_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_login_lockdown\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_message_store\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_aiowps_permanent_block\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_cmplz_cookiebanners\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_cmplz_cookies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_cmplz_dnsmpd\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_cmplz_services\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_frmt_form_entry\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_frmt_form_entry_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_frmt_form_reports\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_frmt_form_views\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_mwai_filemeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_mwai_files\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_post_smtp_logmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_post_smtp_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_wpbot_chat_report\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_wpbot_response\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_wpbot_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_wpwbot_index\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_yoast_indexable\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_yoast_indexable_hierarchy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_yoast_migrations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_yoast_primary_term\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"nJQ2o_yoast_seo_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 6,\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2026-03-04 10:15:24\",\n    \"updated\": \"2026-03-04 10:15:41\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.16.1","2026-03-04 10:15:24","2026-03-04 10:15:41");

INSERT IGNORE INTO `nJQ2o_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"cgutierrez@tecninorte.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"cgutierrez@tecninorte.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/grupoberdejo.es\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1755507033,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:33\",\n    \"updated\": \"2026-03-04 10:15:16\"\n}","4.5.16.1","2025-08-18 08:50:33","2026-03-04 10:15:16"),
("2","DUP_PRO_Secure_Global_Entity","","","","","","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:33\",\n    \"updated\": \"2026-01-15 17:26:55\"\n}","4.5.16.1","2025-08-18 08:50:33","2026-01-15 17:26:55"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"62+JUEYXOKYEh7QDh206hk7HLKQbGK0YWStHKRuaUnnTmtk3bk0iPyMivIseNBwywA7J5RyDU28M6jf09FP61uJgWezoFG+UY\\/93gZcR3ujGOV\\/6rWLoMxfIOS6tfz\\/IKdR1ot43vUwncKkF3hRHDiL4xxnMvgcBeT6nGRKP5eLeF+MPVZ1RiEBni9vpx6J0TcMALoYH6NvSjBhR6oSNOGvyfCVK8aAmpUM5Dn1CcsaHu2oQACB6zq+LxTSWHR0wMOG0RmJcP9814qQLzTKX+AhHyDXclaec\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:33\",\n    \"updated\": \"2026-01-15 17:26:55\"\n}","4.5.16.1","2025-08-18 08:50:33","2026-01-15 17:26:55"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"\",\n    \"updated\": \"2026-03-02 15:17:33\"\n}","4.5.16.1","0000-00-00 00:00:00","2026-03-02 15:17:33"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"zxiWuJ7gdKl\\/omgmDaTf3qBQjiBeBTK8bDHLvSe8M0R1V01Q7jfI2AWiw1wVqFGBHSoUiFYItFMTelekUrhhxQ==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:33\",\n    \"updated\": \"2025-08-18 08:50:33\"\n}","4.5.16.1","2025-08-18 08:50:33","2025-08-18 08:50:33"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"Ohn9BawKc7pj+M0QWjH7hMy1mu3lO2JbL3965B7WcwZqC5c3WCN4yVI7RYn\\/EQe+NvGQegy0FiiteRVZKAWe1A==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:33\",\n    \"updated\": \"2026-03-04 10:15:16\"\n}","4.5.16.1","2025-08-18 08:50:33","2026-03-04 10:15:16"),
("7","Dynamic_Entity","","","","","","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:33\",\n    \"updated\": \"2025-08-18 08:50:33\"\n}","4.5.16.1","2025-08-18 08:50:33","2025-08-18 08:50:33"),
("8","LicenseDataEntity","","","","","","{\n                                        \"licenseKey\": \"\\/\\/gW3aFp1X1rhzp1w6MR0yXQuxdZOdYkh6I\\/1MfO9tRsqQyHGBxYVKaLpqphuKACibeHpH\\/8fCZWvFU4nbDoKYac5oegj8JcQNPFsPcRC5qIPE2qVMNYoQ4KlcDpv5d9\",\n                                        \"status\": \"Y1SKR8q9ppd9P0RrycloF7z4mkO2qw\\/8W4foCGje5IhOddz8IHiWfQR57Gt7xAkeQaZ\\/2FSVLTXtjg\\/wk6hFdokicy1MFG1k\",\n                                        \"type\": \"OPGuBTP8dTZJzfAu+AUyUTMWfmbOcuc2D+Nv+wLlh6pfyzK7dIqDGrrJpDKWtn0VudMQXFuV21CAjybhpnQBKbHZUS9Zc8b6\",\n                                        \"data\": \"EoYiu7ud+Vy+ztIiL5hCnzTlQ3TNV+Es\\/UgDUcG5oZftgMoz4\\/iefd7AqysBt3x5FTD8FAoPi4diJEms\\/89NS834LlEOUD2eknFR2LwqP7wUlhBPyRAPjgbcZOJCDZZ5v0yIv6pBrfA\\/HBoz0OYqdV9KdMNIxZ6Q6cESYTjyurY41nrrj01EaV\\/vrzKytnKDf4PSY4m1iQrUh9v3Z7Pghp2GHLMCQd75ryOwWDG8SpOLT9cVo4YrMv+LLXc2YM0Y3aYb6Dz4qtNIO2Q6pP454YCWyIr3PMuRTXR\\/8tu0768s1wtXp\\/eWe8FEb0J5InxbmpnJ\\/npvsLNu\\/bA8K7G7qqOAGF+ByjC5MDwy2mWV8ZcIjuECLRJ1Ud0QlgjMME+hbjf7J28ivc0tq5u69e92sKN4Nx+ZoqvvdDDEV9sTprWWxVNzQeO3T5BhSJCP5gLRRrcoJBb+3WPgnKSz2EfYdydXbVQ+ZJz0mXNngTV+NiE=\",\n                                        \"lastRemoteUpdate\": \"2026-03-04 12:15:40\",\n                                        \"id\": 8,\n                                        \"value1\": \"\",\n                                        \"value2\": \"\",\n                                        \"value3\": \"\",\n                                        \"value4\": \"\",\n                                        \"value5\": \"\",\n                                        \"version\": \"4.5.16\",\n                                        \"created\": \"2024-03-01 04:00:00\",\n                                        \"updated\": \"2026-03-04 12:15:40\"\n                                    }","4.5.16.1","2025-08-18 08:50:33","2026-01-15 17:26:55"),
("9","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1772619338,\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.1\",\n    \"created\": \"2025-08-18 08:50:34\",\n    \"updated\": \"2026-03-04 10:15:38\"\n}","4.5.16.1","2025-08-18 08:50:34","2026-03-04 10:15:38");

INSERT IGNORE INTO `nJQ2o_e_events` VALUES 
("1","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-12T14:40:03.600-02:00\"}","2025-08-12 14:40:03"),
("2","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-12T14:40:05.440-02:00\"}","2025-08-12 14:40:05"),
("3","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2025-08-12T14:40:05.429-02:00\"}","2025-08-12 14:40:05"),
("4","{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\"}\",\"ts\":\"2025-08-12T14:40:06.918-02:00\"}","2025-08-12 14:40:06"),
("5","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"goodToGo\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-08-12T14:40:06.930-02:00\"}","2025-08-12 14:40:06");

INSERT IGNORE INTO `nJQ2o_e_submissions` VALUES 
("1","submission","61c40ece-a5f3-4d61-957a-33caa8c4300d","2","165","https://grupoberdejo.es/contactar/","Contactar","64f8922","Formulario de contacto Web","0","1","81.43.69.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0","1","1","new","0","{\"edit_post_id\":\"165\"}","2025-08-22 08:23:37","2025-08-22 08:23:37","2025-08-22 08:23:37","2025-08-22 08:23:37");

INSERT IGNORE INTO `nJQ2o_e_submissions_actions_log` VALUES 
("1","1","email","Email","success",NULL,"2025-08-22 08:23:37","2025-08-22 08:23:37","2025-08-22 08:23:37","2025-08-22 08:23:37");

INSERT IGNORE INTO `nJQ2o_e_submissions_values` VALUES 
("1","1","name","CARLOS GUTIERREZ"),
("2","1","email","cgutierrez@tecninorte.es"),
("3","1","field_4611f15","605262472"),
("4","1","message","Esto es una prueba desde la web..."),
("5","1","field_33e7dc7","on");

INSERT IGNORE INTO `nJQ2o_frmt_form_reports` VALUES 
("1","a:5:{s:7:\"exclude\";a:1:{i:0;i:1;}s:8:\"settings\";a:3:{s:5:\"label\";s:12:\"Form reports\";s:6:\"module\";s:5:\"forms\";s:10:\"forms_type\";s:3:\"all\";}s:8:\"schedule\";a:3:{s:9:\"frequency\";s:7:\"monthly\";s:8:\"monthDay\";s:1:\"4\";s:9:\"monthTime\";s:8:\"04:00 AM\";}s:13:\"report_status\";s:8:\"inactive\";s:10:\"recipients\";a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:5:\"admin\";s:5:\"email\";s:25:\"cgutierrez@tecninorte.com\";s:4:\"role\";s:13:\"Administrator\";s:6:\"avatar\";s:113:\"https://secure.gravatar.com/avatar/061a5047c1ea2c431291f2c73b5e2b6b9f7a7ba7f3504fec7ff29621524f7e55?s=96&d=mm&r=g\";}}}","inactive","2026-03-02 14:48:02","2026-03-02 14:48:02");

INSERT IGNORE INTO `nJQ2o_frmt_form_views` VALUES 
("1","1349","0",NULL,"1","2026-03-02 14:54:02","0000-00-00 00:00:00");

INSERT IGNORE INTO `nJQ2o_options` VALUES 
("1","cron","a:22:{i:1772619596;a:1:{s:29:\"cmplz_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"cmplz_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1772619900;a:1:{s:26:\"aios_15_minutes_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"aios-every-15-minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1772620288;a:1:{s:18:\"mwai_files_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1772620505;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1772620800;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1772627705;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1772627784;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1772628002;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1772633105;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1772633711;a:1:{s:34:\"disable_admin_notices_log_activity\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1772634905;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1772634990;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1772642996;a:1:{s:20:\"cmplz_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"cmplz_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1772696400;a:2:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1772703706;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1772756925;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1773064800;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1773146112;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1773161396;a:1:{s:21:\"cmplz_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"cmplz_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1773214800;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1775148596;a:1:{s:22:\"cmplz_every_month_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:13:\"cmplz_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://grupoberdejo.es","yes"),
("3","home","https://grupoberdejo.es","yes"),
("4","blogname","Grupo familiar Berdejo | A family office Berdejo, una empresa familiar - Asesoría laboral y fiscal - Abogados - Compliance - RGPD","on"),
("5","blogdescription","","on"),
("6","users_can_register","0","on"),
("7","admin_email","cgutierrez@tecninorte.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","10","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:163:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:19:\"tf_header_footer/?$\";s:36:\"index.php?post_type=tf_header_footer\";s:49:\"tf_header_footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=tf_header_footer&feed=$matches[1]\";s:44:\"tf_header_footer/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=tf_header_footer&feed=$matches[1]\";s:36:\"tf_header_footer/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=tf_header_footer&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"elementor_component/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"elementor_component/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"elementor_component/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"elementor_component/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"elementor_component/([^/]+)/embed/?$\";s:52:\"index.php?elementor_component=$matches[1]&embed=true\";s:40:\"elementor_component/([^/]+)/trackback/?$\";s:46:\"index.php?elementor_component=$matches[1]&tb=1\";s:48:\"elementor_component/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&paged=$matches[2]\";s:55:\"elementor_component/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&cpage=$matches[2]\";s:44:\"elementor_component/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementor_component=$matches[1]&page=$matches[2]\";s:36:\"elementor_component/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"elementor_component/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"elementor_component/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"elementor_component/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:38:\"elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:46:\"elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:53:\"elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:42:\"elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:44:\"tf_header_footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"tf_header_footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"tf_header_footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tf_header_footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tf_header_footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"tf_header_footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"tf_header_footer/([^/]+)/embed/?$\";s:49:\"index.php?tf_header_footer=$matches[1]&embed=true\";s:37:\"tf_header_footer/([^/]+)/trackback/?$\";s:43:\"index.php?tf_header_footer=$matches[1]&tb=1\";s:57:\"tf_header_footer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tf_header_footer=$matches[1]&feed=$matches[2]\";s:52:\"tf_header_footer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tf_header_footer=$matches[1]&feed=$matches[2]\";s:45:\"tf_header_footer/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tf_header_footer=$matches[1]&paged=$matches[2]\";s:52:\"tf_header_footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?tf_header_footer=$matches[1]&cpage=$matches[2]\";s:41:\"tf_header_footer/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?tf_header_footer=$matches[1]&page=$matches[2]\";s:33:\"tf_header_footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"tf_header_footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"tf_header_footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tf_header_footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tf_header_footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"tf_header_footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1273&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:16:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:33:\"complianz-gdpr/complianz-gpdr.php\";i:3;s:47:\"disable-admin-notices/disable-admin-notices.php\";i:4;s:38:\"disable-update-notifications/index.php\";i:5;s:32:\"duplicate-page/duplicatepage.php\";i:6;s:33:\"duplicator-pro/duplicator-pro.php\";i:7;s:33:\"duplicator-pro/duplicator-pro.php\";i:8;s:23:\"elementor/elementor.php\";i:9;s:37:\"elementskit-lite/elementskit-lite.php\";i:11;s:33:\"login-designer/login-designer.php\";i:12;s:27:\"maintenance/maintenance.php\";i:13;s:29:\"pro-elements/pro-elements.php\";i:14;s:43:\"template-kit-import/template-kit-import.php\";i:15;s:67:\"themesflat-addons-for-elementor/themesflat-addons-for-elementor.php\";i:16;s:61:\"wp-disable-automatic-updates/wp-disable-automatic-updates.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","2","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","hello-elementor","on"),
("42","stylesheet","hello-elementor","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60717","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","page","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","1273","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","834","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","1539","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1786964485","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","60421","on"),
("102","nJQ2o_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:81:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:14:\"manage_privacy\";b:1;s:19:\"manage_postman_smtp\";b:1;s:19:\"manage_postman_logs\";b:1;s:17:\"manage_forminator\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on"),
("103","fresh_site","0","off"),
("104","user_count","1","off"),
("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("106","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","auto"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("125","nonce_key","[nf<CWu#N~IMI5Q(CT[!#h^+loS$OljM(?XJlC9be7ueE)l$:`kQ%H+=Il<UgYoj","off"),
("126","nonce_salt","k0H@2eikM1v96}7/ON}^8&v0kv;r<A^_Nu17 OBH;AZm71P)!_yuk4r{)aFAmHOF","off"),
("127","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1755002393;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("129","recovery_keys","a:0:{}","off"),
("135","WPLANG","es_ES","auto"),
("158","recently_activated","a:1:{s:25:\"forminator/forminator.php\";i:1772556618;}","off"),
("166","finished_updating_comment_type","1","auto"),
("217","current_theme","Hello Elementor","auto"),
("218","theme_mods_hello-elementor","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}","on"),
("219","theme_switched","","auto"),
("220","hello_theme_version","3.4.6","auto"),
("223","elementor_connect_site_key","b888dea53f8450d0c0d0b2fa1a6aea4c","auto"),
("224","_hello-elementor_notifications","a:2:{s:7:\"timeout\";i:1772662492;s:5:\"value\";s:8157:\"[{\"id\":\"hello-theme-3.4.6\",\"title\":\"3.4.6 - 2026-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Updated Elementor assets<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}","off"),
("226","elementor_active_kit","1269","auto"),
("227","elementor_font_display","swap","auto"),
("231","elementor_landing_pages_activation","0","auto"),
("232","elementor_checklist","{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":true,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}","auto"),
("233","elementor_version","3.35.6","auto"),
("234","elementor_install_history","a:9:{s:6:\"3.31.2\";i:1755002402;s:6:\"3.31.3\";i:1756822209;s:6:\"3.31.4\";i:1757415873;s:6:\"3.31.5\";i:1757666052;s:6:\"3.33.4\";i:1765878017;s:6:\"3.34.1\";i:1768466120;s:6:\"3.35.3\";i:1770378480;s:6:\"3.35.5\";i:1771417014;s:6:\"3.35.6\";i:1772557273;}","auto"),
("235","elementor_events_db_version","1.0.0","off"),
("237","elementor_log","a:43:{s:32:\"2eb42b1e00ddac1165efe18db4a2dda5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"PRO Elements/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:47:\"PRO Elements/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"46715ee3517bd3a6bda312f8144594cb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"PRO Elements/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"PRO Elements/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"b3b675266a2740f1918902ff39b559ea\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"7c301a00f9d819df12d3b00419566210\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ff9f55d1c2d6e80a0aa36613c9a06582\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"90f1b213219fe26a5ecb7c95ea5efeca\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"2fe0a6ce1a03491fa0fd02bc6a0570a1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c0db4e197815d2c0884de8b9846dc9ab\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:40:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-16 11:40:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.5\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"62a008db21ceb2eae4447678b545942b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:52:29\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:81:\"hexdec(): Passing null to parameter #1 ($hex_string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:31;s:14:\"\0*\0times_dates\";a:31:{i:0;s:19:\"2025-12-16 11:52:29\";i:1;s:19:\"2025-12-16 12:01:24\";i:2;s:19:\"2025-12-16 12:02:27\";i:3;s:19:\"2025-12-16 12:26:40\";i:4;s:19:\"2025-12-16 12:35:25\";i:5;s:19:\"2026-02-18 14:32:59\";i:6;s:19:\"2026-02-18 14:37:51\";i:7;s:19:\"2026-02-18 14:52:17\";i:8;s:19:\"2026-02-18 14:54:23\";i:9;s:19:\"2026-02-18 17:13:51\";i:10;s:19:\"2026-02-23 20:24:43\";i:11;s:19:\"2026-03-02 17:57:53\";i:12;s:19:\"2026-03-02 18:08:26\";i:13;s:19:\"2026-03-02 20:18:59\";i:14;s:19:\"2026-03-03 12:21:17\";i:15;s:19:\"2026-03-03 12:24:02\";i:16;s:19:\"2026-03-03 12:25:02\";i:17;s:19:\"2026-03-03 12:43:38\";i:18;s:19:\"2026-03-03 17:49:01\";i:19;s:19:\"2026-03-03 17:56:30\";i:20;s:19:\"2026-03-03 18:00:38\";i:21;s:19:\"2026-03-03 18:03:15\";i:22;s:19:\"2026-03-03 18:07:06\";i:23;s:19:\"2026-03-03 18:23:25\";i:24;s:19:\"2026-03-03 18:24:44\";i:25;s:19:\"2026-03-03 18:38:20\";i:26;s:19:\"2026-03-03 18:38:29\";i:27;s:19:\"2026-03-03 18:43:14\";i:28;s:19:\"2026-03-03 18:48:48\";i:29;s:19:\"2026-03-03 18:54:53\";i:30;s:19:\"2026-03-03 18:55:40\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:81:\"hexdec(): Passing null to parameter #1 ($hex_string) of type string is deprecated\";s:4:\"file\";s:91:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:230;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:91:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:230;}s:32:\"b1cf13440ef42ef57b873e65a27f44b9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:52:37\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:37:\"Trying to access array offset on null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-12-16 11:52:37\";i:1;s:19:\"2025-12-16 12:01:31\";i:2;s:19:\"2025-12-16 12:02:30\";i:3;s:19:\"2025-12-16 12:26:47\";i:4;s:19:\"2025-12-16 12:35:33\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:37:\"Trying to access array offset on null\";s:4:\"file\";s:91:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1649;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:91:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:1649;}s:32:\"e08dc8801dea680e1228c8c693f257ee\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-12-16 11:52:38\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:38:\"Trying to access array offset on false\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-12-16 11:52:38\";i:1;s:19:\"2025-12-16 12:01:34\";i:2;s:19:\"2026-02-18 14:33:32\";i:3;s:19:\"2026-02-18 14:54:33\";i:4;s:19:\"2026-02-18 17:14:04\";i:5;s:19:\"2026-02-18 17:14:39\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:38:\"Trying to access array offset on false\";s:4:\"file\";s:86:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:113;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:86:\"/home/berdejo/grupoberdejo.es/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:113;}s:32:\"813d8949b649547472ac942fbae2fd3a\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-12-16 10:02:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Document.querySelector: &#039;#&#039; is not a valid selector\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:83;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2026-03-03 10:43:59\";i:1;s:19:\"2026-03-03 10:43:59\";i:2;s:19:\"2026-03-03 10:43:59\";i:3;s:19:\"2026-03-03 10:43:59\";i:4;s:19:\"2026-03-03 10:43:59\";i:5;s:19:\"2026-03-03 10:43:59\";i:6;s:19:\"2026-03-03 10:44:06\";i:7;s:19:\"2026-03-03 10:44:06\";i:8;s:19:\"2026-03-03 10:44:06\";i:9;s:19:\"2026-03-03 10:44:06\";i:10;s:19:\"2026-03-03 10:44:06\";i:11;s:19:\"2026-03-03 10:44:06\";i:12;s:19:\"2026-03-03 10:44:13\";i:13;s:19:\"2026-03-03 10:44:13\";i:14;s:19:\"2026-03-03 10:44:13\";i:15;s:19:\"2026-03-03 10:44:13\";i:16;s:19:\"2026-03-03 10:44:13\";i:17;s:19:\"2026-03-03 10:44:13\";i:18;s:19:\"2026-03-03 10:44:19\";i:19;s:19:\"2026-03-03 10:44:19\";i:20;s:19:\"2026-03-03 10:44:19\";i:21;s:19:\"2026-03-03 10:44:19\";i:22;s:19:\"2026-03-03 10:44:19\";i:23;s:19:\"2026-03-03 10:44:19\";i:24;s:19:\"2026-03-03 10:44:27\";i:25;s:19:\"2026-03-03 10:44:27\";i:26;s:19:\"2026-03-03 10:44:27\";i:27;s:19:\"2026-03-03 10:44:27\";i:28;s:19:\"2026-03-03 10:44:27\";i:29;s:19:\"2026-03-03 10:44:27\";i:30;s:19:\"2026-03-03 10:45:57\";i:31;s:19:\"2026-03-03 10:45:57\";i:32;s:19:\"2026-03-03 10:45:57\";i:33;s:19:\"2026-03-03 10:46:04\";i:34;s:19:\"2026-03-03 10:46:04\";i:35;s:19:\"2026-03-03 15:45:05\";i:36;s:19:\"2026-03-03 15:54:40\";i:37;s:19:\"2026-03-03 15:54:40\";i:38;s:19:\"2026-03-03 15:54:40\";i:39;s:19:\"2026-03-03 16:55:04\";i:40;s:19:\"2026-03-03 16:55:04\";i:41;s:19:\"2026-03-03 16:55:04\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1765879330\";s:7:\"message\";s:51:\"Document.querySelector: \'#\' is not a valid selector\";s:3:\"url\";s:87:\"https://grupoberdejo.es/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.4\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:6:\"916748\";}s:7:\"\0*\0file\";s:87:\"https://grupoberdejo.es/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.4\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:6:\"916748\";}s:32:\"c88a0303912f26e6db116151ebe9af49\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:35:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:35:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f094d03abeb96225f7f42b3cc7eede60\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:35:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:35:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5dbd4758091db77e5a3bffffea25b0cf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:35:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:35:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"7cc65c0ef43046e03aaa096070cebb6f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:35:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:35:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"3c2a634023faee1befbd977afc7cbd0b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:35:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:35:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"62bd304b525a75fc0126e5630b04778d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:37:14\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:37:14\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"3cb1534aee919aa675ebf718ee59cafd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:37:14\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"PRO Elements/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:37:14\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:47:\"PRO Elements/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"0602b2ec18f876e9c8cfab9ad7b85246\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:37:14\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"PRO Elements/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:37:14\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"PRO Elements/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"fcd7037c6abb07f07983e5bf2d041cab\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:37:14\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.34.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:37:14\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.34.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bd8c6b13370d94f977001750da3e8a56\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-15 10:37:14\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.34.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-15 10:37:14\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.34.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2ad5efe79aafd6092c5e87b3b9328e3c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-06 13:48:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-06 13:48:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"665ea9186c72ef669f2de72b1715b97a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-06 13:48:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-06 13:48:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5ae0d50a3f8b17a2ebb9e373c170271d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-06 13:48:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-06 13:48:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a1a0939fca28018d44b701d6bc09dcb7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-06 13:48:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.1\";s:2:\"to\";s:6:\"3.35.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-06 13:48:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.1\";s:2:\"to\";s:6:\"3.35.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2f33564c2f57249f0bb452feb9f3e241\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-06 13:48:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.1\";s:2:\"to\";s:6:\"3.35.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-06 13:48:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.1\";s:2:\"to\";s:6:\"3.35.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"694e812599f043426d682503ba65737d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2026-02-06 11:48:26\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:30:\"r.startsWith is not a function\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-06 11:48:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1770378506\";s:7:\"message\";s:30:\"r.startsWith is not a function\";s:3:\"url\";s:86:\"https://grupoberdejo.es/wp-content/plugins/elementor/assets/js/admin.min.js?ver=3.35.3\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"45739\";}s:7:\"\0*\0file\";s:86:\"https://grupoberdejo.es/wp-content/plugins/elementor/assets/js/admin.min.js?ver=3.35.3\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"45739\";}s:32:\"72ddb72f1d054b647fa0fc080868dba4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.3\";s:2:\"to\";s:6:\"3.35.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.3\";s:2:\"to\";s:6:\"3.35.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c6b1d9ae2acdfa0d7d76bd46cc045bff\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:53\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"3c51352b59b415d5e4cf59da3ebdccfa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"PRO Elements/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:53\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:47:\"PRO Elements/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"2753ac24f27f5dd5b5d6ddf8920de221\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"PRO Elements/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:53\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"PRO Elements/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"de5b3470b20fcebc2dca1b81aa6e14fa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.34.0\";s:2:\"to\";s:6:\"3.35.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.34.0\";s:2:\"to\";s:6:\"3.35.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"007c8197efa1cba7d97928a82aaaa839\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.34.0\";s:2:\"to\";s:6:\"3.35.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:12:\"PRO Elements\";s:4:\"from\";s:6:\"3.34.0\";s:2:\"to\";s:6:\"3.35.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"072ac86e16c263098401e20db9d7a961\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7ec8e435db601701e8ed0f0131392ea9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"758ce1c9854492cee38f00d0b4d80abd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"08c6a6296758ad9bee75c8d3355be5ae\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.3\";s:2:\"to\";s:6:\"3.35.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.3\";s:2:\"to\";s:6:\"3.35.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ac19071a1978905cfe8d2741dc4e62f4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-18 14:16:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.3\";s:2:\"to\";s:6:\"3.35.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-18 14:16:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.3\";s:2:\"to\";s:6:\"3.35.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"72373348512fc33e9bd61520609ee18c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-03-03 19:01:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-03-03 19:01:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"fda2f5eb2cc07cc498591bb3fad33319\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-03-03 19:01:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-03-03 19:01:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"15423848de0ca773b9b25450b387f835\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-03-03 19:01:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-03-03 19:01:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d82a049b767b27f07759b847e77bd0bb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-03-03 19:01:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.5\";s:2:\"to\";s:6:\"3.35.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-03-03 19:01:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.35.5\";s:2:\"to\";s:6:\"3.35.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}","off"),
("238","elementor_onboarded","1","auto"),
("239","_elementor_onboarding_features","a:2:{s:9:\"essential\";a:0:{}s:8:\"advanced\";a:0:{}}","auto"),
("240","e_editor_counter","155","auto"),
("241","_elementor_installed_time","1755002409","auto"),
("242","_elementor_free_to_pro_upsell","a:2:{s:7:\"timeout\";i:1757677899;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}","off"),
("243","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1772567693;s:5:\"value\";s:12452:\"[{\"id\":\"components-3.35\",\"title\":\"Components\",\"description\":\"Build modular, reusable sections that update everywhere and decide how much control to give away to your team or clients.\",\"topic\":\"Version 4 beta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/components-3-35.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-components-3.35-blog\",\"readMoreText\":\"Learn More\"},{\"id\":\"one-launch\",\"title\":\"Introducing Elementor One\",\"description\":\"The complete website building experience. All the tools to create, optimize, and manage websites, unified under one roof.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/one-launch.png\",\"chipTags\":[\"New Launch\"],\"cta\":\"Explore Elementor One\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/launch-whats-new\"},{\"id\":\"atomic-tabs-3.34\",\"title\":\"Atomic Tabs\",\"description\":\"Nest any type of content inside tab triggers or content panels, unlocking a truly atomic way of design.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tabs-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"interactions-3.34\",\"title\":\"Entrance Interactions\",\"description\":\"Add subtle, performance\\u2011minded Fade, Scale or Slide effects to your elements from the new Interaction panel.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/interactions-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-manager-3.33\",\"title\":\"Variables Manager\",\"description\":\"Centralize and control all your color, typography, and size tokens for consistent, scalable design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-variables-manager.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-custom-css\\/\"},{\"id\":\"blend-mode-3.33\",\"title\":\"Blend Mode\",\"description\":\"Layer and blend visuals to create depth, contrast, and cinematic design effects.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-blend.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}","off"),
("246","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("247","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:59:\"The atomic foundation of version 4 is ready for real sites!\";s:7:\"excerpt\";s:296:\"The alpha phase is complete. Version 4 is now in beta, and the atomic foundation is ready to be used on real sites! This is the final step before the official release of version 4.0, activating the new features automatically on new sites, and becoming the default editing experience in Elementor.\";s:7:\"created\";i:1770651621;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:113:\"https://elementor.com/blog/editor-4-beta/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("250","_elementor_local_google_fonts","a:9:{s:6:\"roboto\";a:2:{s:3:\"url\";s:80:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1755002432;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:84:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1755070731;}s:8:\"notosans\";a:2:{s:3:\"url\";s:82:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/notosans.css\";s:7:\"version\";i:1755159396;}s:13:\"librefranklin\";a:2:{s:3:\"url\";s:87:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/librefranklin.css\";s:7:\"version\";i:1756831429;}s:8:\"worksans\";a:2:{s:3:\"url\";s:82:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/worksans.css\";s:7:\"version\";i:1757432977;}s:10:\"montserrat\";a:2:{s:3:\"url\";s:84:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/montserrat.css\";s:7:\"version\";i:1757432988;}s:6:\"outfit\";a:2:{s:3:\"url\";s:80:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/outfit.css\";s:7:\"version\";i:1765877541;}s:4:\"syne\";a:2:{s:3:\"url\";s:78:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/syne.css\";s:7:\"version\";i:1771417987;}s:7:\"manrope\";a:2:{s:3:\"url\";s:81:\"https://grupoberdejo.es/wp-content/uploads/elementor/google-fonts/css/manrope.css\";s:7:\"version\";i:1771417992;}}","auto"),
("256","duplicate_page_options","a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}","auto"),
("259","maintenance_meta","a:4:{s:13:\"first_version\";s:4:\"4.06\";s:13:\"first_install\";i:1755002451;s:11:\"old_version\";b:0;s:20:\"hide_welcome_pointer\";b:1;}","auto"),
("260","mtnc_db_version","2","auto"),
("261","maintenance_options","a:26:{s:5:\"state\";i:1;s:13:\"exclude_pages\";a:2:{s:4:\"post\";a:0:{}s:4:\"page\";a:0:{}}s:10:\"page_title\";s:28:\"La Web esta en mantenimiento\";s:7:\"heading\";s:36:\"El modo mantenimiento está activado\";s:11:\"description\";s:65:\"Estamos trabajando en nuestra nueva Web.\r\nDisculpe las molestias.\";s:11:\"footer_text\";s:133:\"© Grupo familiar Berdejo | A family office Berdejo, una empresa familiar - Asesoría laboral y fiscal - Abogados - Compliance - RGPD\";s:14:\"show_some_love\";b:0;s:8:\"is_login\";b:1;s:10:\"logo_width\";s:3:\"220\";s:11:\"logo_height\";s:0:\"\";s:4:\"logo\";s:1:\"0\";s:11:\"retina_logo\";s:1:\"0\";s:7:\"body_bg\";s:2:\"99\";s:17:\"bg_image_portrait\";s:1:\"0\";s:13:\"preloader_img\";s:1:\"0\";s:13:\"body_bg_color\";s:7:\"#111111\";s:10:\"font_color\";s:7:\"#ffffff\";s:17:\"controls_bg_color\";s:7:\"#111111\";s:16:\"body_font_family\";s:9:\"Open Sans\";s:16:\"body_font_subset\";s:3:\"300\";s:11:\"503_enabled\";b:0;s:7:\"is_blur\";b:0;s:14:\"blur_intensity\";s:1:\"5\";s:15:\"gg_analytics_id\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";s:16:\"default_settings\";b:0;}","auto"),
("322","aio_wp_security_configs","a:123:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:1:\"1\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";i:3;s:24:\"aiowps_retry_time_period\";i:5;s:26:\"aiowps_lockout_time_length\";i:60;s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:25:\"cgutierrez@tecninorte.com\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"wf3xlog5hzeekku00agd\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:1:\"1\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:13:\"88.26.184.220\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:13:\"88.26.184.220\";s:27:\"aiowps_enable_login_captcha\";s:1:\"1\";s:34:\"aiowps_enable_custom_login_captcha\";s:1:\"1\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"765o2ivh888mm7mengtv\";s:42:\"aiowps_enable_manual_registration_approval\";s:1:\"1\";s:39:\"aiowps_enable_registration_page_captcha\";s:1:\"1\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:27:\"aiowps_disable_file_editing\";s:1:\"1\";s:37:\"aiowps_prevent_default_wp_file_access\";s:1:\"1\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:27:\"aiowps_max_file_upload_size\";i:30;s:31:\"aiowps_enable_pingback_firewall\";s:1:\"0\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:1:\"1\";s:26:\"aiowps_disable_index_views\";s:1:\"1\";s:30:\"aiowps_disable_trace_and_track\";s:1:\"1\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"0\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"0\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"0\";s:25:\"aiowps_enable_5g_firewall\";s:1:\"1\";s:25:\"aiowps_enable_6g_firewall\";s:1:\"1\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:1:\"1\";s:28:\"aiowps_enable_login_honeypot\";s:1:\"1\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:553:\"<h2 style=\"text-align: center\">CERRADO POR MANTENIMIENTO</h2>\r\n<p style=\"text-align: center\"><span class=\"VIiyi\" lang=\"es\"><span class=\"JLqJ4b ChMk0b\" data-language-for-alternatives=\"es\" data-language-to-translate-into=\"en\" data-phrase-index=\"0\">Este sitio no está disponible actualmente.</span> </span></p>\r\n<p style=\"text-align: center\"><span class=\"VIiyi\" lang=\"es\"><span class=\"JLqJ4b ChMk0b\" data-language-for-alternatives=\"es\" data-language-to-translate-into=\"en\" data-phrase-index=\"1\">Por favor, inténtelo de nuevo más tarde.</span></span></p>\";s:30:\"aiowps_enable_spambot_blocking\";s:1:\"1\";s:29:\"aiowps_enable_comment_captcha\";s:1:\"1\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:1:\"1\";s:33:\"aiowps_spam_ip_min_comments_block\";i:3;s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:25:\"cgutierrez@tecninorte.com\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:1:\"1\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:25:\"aiowps_recaptcha_site_key\";s:40:\"6LcbuF8UAAAAAH4as2NZQ4A-VrBDFVXuvTa6eDpL\";s:27:\"aiowps_recaptcha_secret_key\";s:40:\"6LcbuF8UAAAAAO6afIell-ep7g-Hh1-lHWx0ARLr\";s:24:\"aiowps_default_recaptcha\";s:1:\"0\";s:28:\"aiowps_block_fake_googlebots\";s:1:\"1\";s:22:\"aiowps_login_page_slug\";s:11:\"zonaprivada\";s:19:\"aiowps_fcd_filename\";s:26:\"aiowps_fcd_data_3f1uwejr7t\";s:35:\"aiowps_enable_lost_password_captcha\";s:1:\"1\";s:23:\"aiowps_last_backup_time\";s:19:\"2022-12-15 09:55:58\";s:12:\"installed-at\";i:1660729496;s:14:\"dismiss_notice\";i:1667987096;s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:22:\"aiowps_default_captcha\";s:11:\"simple-math\";s:35:\"aiowps_disable_application_password\";s:0:\"\";s:33:\"aiowps_enable_trash_spam_comments\";s:1:\"1\";s:37:\"aiowps_trash_spam_comments_after_days\";i:14;s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:33:\"aiowps_disable_rss_and_atom_feeds\";s:0:\"\";s:17:\"dismissdashnotice\";i:1781177771;s:31:\"aiowps_enable_spambot_detecting\";s:1:\"1\";s:27:\"aiowps_spam_comments_should\";s:1:\"0\";s:25:\"aiowps_turnstile_site_key\";s:0:\"\";s:27:\"aiowps_turnstile_secret_key\";s:0:\"\";s:32:\"aiowps_http_authentication_admin\";s:0:\"\";s:35:\"aiowps_http_authentication_frontend\";s:0:\"\";s:35:\"aiowps_http_authentication_username\";s:4:\"root\";s:35:\"aiowps_http_authentication_password\";s:8:\"password\";s:42:\"aiowps_http_authentication_failure_message\";s:21:\"<h1>Unauthorized</h1>\";s:40:\"aiowps_enable_password_protected_captcha\";s:1:\"1\";s:34:\"aiowps_enable_woo_checkout_captcha\";s:0:\"\";s:36:\"aiowps_enable_contact_form_7_captcha\";s:0:\"\";s:35:\"aiowps_auto_delete_default_wp_files\";s:1:\"1\";s:32:\"aiowps_spambot_detect_usecookies\";s:0:\"\";s:35:\"aios_roles_disallowed_rest_requests\";a:0:{}s:28:\"aios_whitelisted_rest_routes\";a:0:{}s:22:\"aiowps_turnstile_theme\";s:4:\"auto\";s:32:\"aiowps_upgrade_unsafe_http_calls\";s:0:\"\";s:47:\"aiowps_upgrade_unsafe_http_calls_url_exceptions\";s:0:\"\";}","auto"),
("323","aios_antibot_key_map_info","a:3:{i:0;a:4:{i:0;a:2:{i:0;s:8:\"sdc78iq2\";i:1;s:12:\"1ikeqv9s8nmf\";}i:1;a:2:{i:0;s:8:\"b6xjd6bh\";i:1;s:12:\"2juryzhwai9o\";}i:2;a:2:{i:0;s:8:\"cawl0h4s\";i:1;s:12:\"h5jctu5meak1\";}i:3;a:2:{i:0;s:8:\"2mhs32he\";i:1;s:12:\"2gwav6ndq4z7\";}}i:1;a:4:{i:0;a:2:{i:0;s:8:\"fy20q6bq\";i:1;s:12:\"xnzo7s1a62mh\";}i:1;a:2:{i:0;s:8:\"avmx0sxi\";i:1;s:12:\"unu0j6yl9rky\";}i:2;a:2:{i:0;s:8:\"w1d433j2\";i:1;s:12:\"4la8612k0ssp\";}i:3;a:2:{i:0;s:8:\"r06uotto\";i:1;s:12:\"nevrpav0tjpy\";}}i:2;i:1772841600;}","off"),
("324","aiowpsec_db_version","2.1.4","auto"),
("325","aiowpsec_firewall_version","1.0.8","auto"),
("327","simba_tfa_priv_key_format","1","off"),
("328","updraft_lock_aios_15_minutes_cron_event","0","no"),
("338","fs_active_plugins","O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:32:\"login-designer/includes/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1755071442;s:11:\"plugin_path\";s:33:\"login-designer/login-designer.php\";}}s:7:\"abspath\";s:30:\"/home/berdejo/grupoberdejo.es/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:33:\"login-designer/login-designer.php\";s:8:\"sdk_path\";s:32:\"login-designer/includes/freemius\";s:7:\"version\";s:6:\"2.12.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1758103767;}}","auto"),
("339","fs_debug_mode","","auto"),
("340","fs_accounts","a:8:{s:21:\"id_slug_type_path_map\";a:1:{i:11442;a:3:{s:4:\"slug\";s:14:\"login-designer\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:33:\"login-designer/login-designer.php\";}}s:11:\"plugin_data\";a:1:{s:14:\"login-designer\";a:17:{s:19:\"last_load_timestamp\";i:1772605208;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:33:\"login-designer/login-designer.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1755071442;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:6:\"2.12.1\";s:11:\"sdk_version\";s:6:\"2.12.0\";s:16:\"sdk_upgrade_mode\";b:0;s:18:\"sdk_downgrade_mode\";b:1;s:19:\"plugin_last_version\";s:5:\"1.6.8\";s:14:\"plugin_version\";s:6:\"1.6.10\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:27:\"ferreraarquitectotecnico.es\";s:9:\"server_ip\";s:14:\"213.229.190.25\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1755071442;s:7:\"version\";s:5:\"1.6.8\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1755071453;s:7:\"version\";s:5:\"1.6.8\";}}}s:13:\"file_slug_map\";a:1:{s:33:\"login-designer/login-designer.php\";s:14:\"login-designer\";}s:7:\"plugins\";a:1:{s:14:\"login-designer\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:5:\"11442\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_8ce3c04198a7961c26bba01883213\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:14:\"Login Designer\";s:4:\"slug\";s:14:\"login-designer\";s:12:\"premium_slug\";s:22:\"login-designer-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:33:\"login-designer/login-designer.php\";s:7:\"version\";s:6:\"1.6.10\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"155e5eb38486f9ba731f833772c6c04a\";s:13:\"admin_notices\";a:0:{}}","auto"),
("341","fs_api_cache","a:0:{}","off"),
("344","login_designer_settings","a:3:{s:19:\"login_designer_page\";i:13;s:14:\"branding_color\";s:7:\"#000000\";s:19:\"branding_icon_color\";s:7:\"#000000\";}","on"),
("347","login_designer_activation_date","1755071443","off"),
("352","login_designer","a:18:{s:4:\"logo\";i:15;s:10:\"logo_width\";i:316;s:11:\"logo_height\";i:92;s:8:\"bg_image\";s:81:\"https://grupoberdejo.es/wp-content/uploads/2025/08/fotografia-monte-picota-1.webp\";s:8:\"template\";s:2:\"01\";s:16:\"bg_image_gallery\";s:5:\"bg_09\";s:8:\"bg_color\";s:7:\"#ffffff\";s:11:\"form_shadow\";i:0;s:19:\"form_shadow_opacity\";i:0;s:17:\"form_side_padding\";i:40;s:10:\"form_width\";i:0;s:8:\"field_bg\";s:7:\"#ffffff\";s:12:\"field_border\";i:2;s:17:\"field_padding_top\";i:6;s:20:\"field_padding_bottom\";i:6;s:12:\"field_radius\";i:3;s:12:\"field_shadow\";i:0;s:20:\"field_shadow_opacity\";i:0;}","on"),
("454","elementor_disable_color_schemes","yes","auto"),
("455","elementor_disable_typography_schemes","yes","auto"),
("459","elementskit-lite__banner_last_check","1772619292","auto"),
("460","elementskit-lite__banner_data","O:8:\"stdClass\":10:{s:8:\"10022460\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022460;s:5:\"title\";s:28:\"Wpmet Ramadan Dashboard 2026\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1772409600;s:3:\"end\";i:1773705600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:33:\"https://wpmet.com/deals/?rui=1265\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Ramadan Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022458\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022458;s:5:\"title\";s:31:\"Wpmet Ramadan Sale Ownpage 2026\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1772409600;s:3:\"end\";i:1773705600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:33:\"https://wpmet.com/deals/?rui=1265\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Ramadan Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022430\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022430;s:5:\"title\";s:38:\"Wpmet January CRO for bundle Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1771286400;s:3:\"end\";i:1771718400;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:33:\"https://wpmet.com/deals/?rui=1265\";s:11:\"button_text\";s:17:\"Secure $749 Price\";s:11:\"notice_body\";s:263:\"<h2 class=\"gkit-heading-title\">Get the AIO Bundle for $749!<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #ff0000; ; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the AIO Bundle Plugin Bundle (80% OFF) </strong></strong></h2>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022431\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022431;s:5:\"title\";s:37:\"Wpmet January CRO for bundle Own Page\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1768608000;s:3:\"end\";i:1771718400;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:33:\"https://wpmet.com/deals/?rui=1265\";s:11:\"button_text\";s:17:\"Secure $749 Price\";s:11:\"notice_body\";s:263:\"<h2 class=\"gkit-heading-title\">Get the AIO Bundle for $749!<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #ff0000; ; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the AIO Bundle Plugin Bundle (80% OFF) </strong></strong></h2>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022095\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022095;s:5:\"title\";s:31:\"Wpmet Holiday Sale Ownpage 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768608000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Holiday Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022094\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022094;s:5:\"title\";s:28:\"Wpmet Holiday Sale Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";b:0;s:3:\"end\";i:1768608000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Holiday Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021821\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021821;s:5:\"title\";s:32:\"Wpmet Notice BFCM Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:259:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021820\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021820;s:5:\"title\";s:24:\"Wpmet BFCM Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:257:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save